/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServersRequest extends MigrationHubStrategyRequest implements
        ToCopyableBuilder<ListServersRequest.Builder, ListServersRequest> {
    private static final SdkField<String> FILTER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterValue").getter(getter(ListServersRequest::filterValue)).setter(setter(Builder::filterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterValue").build()).build();

    private static final SdkField<List<Group>> GROUP_ID_FILTER_FIELD = SdkField
            .<List<Group>> builder(MarshallingType.LIST)
            .memberName("groupIdFilter")
            .getter(getter(ListServersRequest::groupIdFilter))
            .setter(setter(Builder::groupIdFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupIdFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Group> builder(MarshallingType.SDK_POJO)
                                            .constructor(Group::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListServersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SERVER_CRITERIA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverCriteria").getter(getter(ListServersRequest::serverCriteriaAsString))
            .setter(setter(Builder::serverCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCriteria").build()).build();

    private static final SdkField<String> SORT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sort")
            .getter(getter(ListServersRequest::sortAsString)).setter(setter(Builder::sort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_VALUE_FIELD,
            GROUP_ID_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SERVER_CRITERIA_FIELD, SORT_FIELD));

    private final String filterValue;

    private final List<Group> groupIdFilter;

    private final Integer maxResults;

    private final String nextToken;

    private final String serverCriteria;

    private final String sort;

    private ListServersRequest(BuilderImpl builder) {
        super(builder);
        this.filterValue = builder.filterValue;
        this.groupIdFilter = builder.groupIdFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.serverCriteria = builder.serverCriteria;
        this.sort = builder.sort;
    }

    /**
     * <p>
     * Specifies the filter value, which is based on the type of server criteria. For example, if
     * <code>serverCriteria</code> is <code>OS_NAME</code>, and the <code>filterValue</code> is equal to
     * <code>WindowsServer</code>, then <code>ListServers</code> returns all of the servers matching the OS name
     * <code>WindowsServer</code>.
     * </p>
     * 
     * @return Specifies the filter value, which is based on the type of server criteria. For example, if
     *         <code>serverCriteria</code> is <code>OS_NAME</code>, and the <code>filterValue</code> is equal to
     *         <code>WindowsServer</code>, then <code>ListServers</code> returns all of the servers matching the OS name
     *         <code>WindowsServer</code>.
     */
    public final String filterValue() {
        return filterValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupIdFilter property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupIdFilter() {
        return groupIdFilter != null && !(groupIdFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the group ID to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupIdFilter} method.
     * </p>
     * 
     * @return Specifies the group ID to filter on.
     */
    public final List<Group> groupIdFilter() {
        return groupIdFilter;
    }

    /**
     * <p>
     * The maximum number of items to include in the response. The maximum value is 100.
     * </p>
     * 
     * @return The maximum number of items to include in the response. The maximum value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token from a previous call that you use to retrieve the next set of results. For example, if a previous call
     * to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10 results
     * along with a token. You then use the returned token to retrieve the next set of 10.
     * </p>
     * 
     * @return The token from a previous call that you use to retrieve the next set of results. For example, if a
     *         previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll
     *         receive a set of 10 results along with a token. You then use the returned token to retrieve the next set
     *         of 10.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Criteria for filtering servers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverCriteria}
     * will return {@link ServerCriteria#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serverCriteriaAsString}.
     * </p>
     * 
     * @return Criteria for filtering servers.
     * @see ServerCriteria
     */
    public final ServerCriteria serverCriteria() {
        return ServerCriteria.fromValue(serverCriteria);
    }

    /**
     * <p>
     * Criteria for filtering servers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverCriteria}
     * will return {@link ServerCriteria#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serverCriteriaAsString}.
     * </p>
     * 
     * @return Criteria for filtering servers.
     * @see ServerCriteria
     */
    public final String serverCriteriaAsString() {
        return serverCriteria;
    }

    /**
     * <p>
     * Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sort} will return
     * {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortAsString}.
     * </p>
     * 
     * @return Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order.
     * @see SortOrder
     */
    public final SortOrder sort() {
        return SortOrder.fromValue(sort);
    }

    /**
     * <p>
     * Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sort} will return
     * {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortAsString}.
     * </p>
     * 
     * @return Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order.
     * @see SortOrder
     */
    public final String sortAsString() {
        return sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filterValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupIdFilter() ? groupIdFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(serverCriteriaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServersRequest)) {
            return false;
        }
        ListServersRequest other = (ListServersRequest) obj;
        return Objects.equals(filterValue(), other.filterValue()) && hasGroupIdFilter() == other.hasGroupIdFilter()
                && Objects.equals(groupIdFilter(), other.groupIdFilter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(serverCriteriaAsString(), other.serverCriteriaAsString())
                && Objects.equals(sortAsString(), other.sortAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServersRequest").add("FilterValue", filterValue())
                .add("GroupIdFilter", hasGroupIdFilter() ? groupIdFilter() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("ServerCriteria", serverCriteriaAsString()).add("Sort", sortAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterValue":
            return Optional.ofNullable(clazz.cast(filterValue()));
        case "groupIdFilter":
            return Optional.ofNullable(clazz.cast(groupIdFilter()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "serverCriteria":
            return Optional.ofNullable(clazz.cast(serverCriteriaAsString()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sortAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServersRequest, T> g) {
        return obj -> g.apply((ListServersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListServersRequest> {
        /**
         * <p>
         * Specifies the filter value, which is based on the type of server criteria. For example, if
         * <code>serverCriteria</code> is <code>OS_NAME</code>, and the <code>filterValue</code> is equal to
         * <code>WindowsServer</code>, then <code>ListServers</code> returns all of the servers matching the OS name
         * <code>WindowsServer</code>.
         * </p>
         * 
         * @param filterValue
         *        Specifies the filter value, which is based on the type of server criteria. For example, if
         *        <code>serverCriteria</code> is <code>OS_NAME</code>, and the <code>filterValue</code> is equal to
         *        <code>WindowsServer</code>, then <code>ListServers</code> returns all of the servers matching the OS
         *        name <code>WindowsServer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValue(String filterValue);

        /**
         * <p>
         * Specifies the group ID to filter on.
         * </p>
         * 
         * @param groupIdFilter
         *        Specifies the group ID to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIdFilter(Collection<Group> groupIdFilter);

        /**
         * <p>
         * Specifies the group ID to filter on.
         * </p>
         * 
         * @param groupIdFilter
         *        Specifies the group ID to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIdFilter(Group... groupIdFilter);

        /**
         * <p>
         * Specifies the group ID to filter on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.Group.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.migrationhubstrategy.model.Group#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.Group.Builder#build()} is called
         * immediately and its result is passed to {@link #groupIdFilter(List<Group>)}.
         * 
         * @param groupIdFilter
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.Group.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupIdFilter(java.util.Collection<Group>)
         */
        Builder groupIdFilter(Consumer<Group.Builder>... groupIdFilter);

        /**
         * <p>
         * The maximum number of items to include in the response. The maximum value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to include in the response. The maximum value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token from a previous call that you use to retrieve the next set of results. For example, if a previous
         * call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll receive a set of 10
         * results along with a token. You then use the returned token to retrieve the next set of 10.
         * </p>
         * 
         * @param nextToken
         *        The token from a previous call that you use to retrieve the next set of results. For example, if a
         *        previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You'll
         *        receive a set of 10 results along with a token. You then use the returned token to retrieve the next
         *        set of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Criteria for filtering servers.
         * </p>
         * 
         * @param serverCriteria
         *        Criteria for filtering servers.
         * @see ServerCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerCriteria
         */
        Builder serverCriteria(String serverCriteria);

        /**
         * <p>
         * Criteria for filtering servers.
         * </p>
         * 
         * @param serverCriteria
         *        Criteria for filtering servers.
         * @see ServerCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerCriteria
         */
        Builder serverCriteria(ServerCriteria serverCriteria);

        /**
         * <p>
         * Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order.
         * </p>
         * 
         * @param sort
         *        Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sort(String sort);

        /**
         * <p>
         * Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order.
         * </p>
         * 
         * @param sort
         *        Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sort(SortOrder sort);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubStrategyRequest.BuilderImpl implements Builder {
        private String filterValue;

        private List<Group> groupIdFilter = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private String serverCriteria;

        private String sort;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServersRequest model) {
            super(model);
            filterValue(model.filterValue);
            groupIdFilter(model.groupIdFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            serverCriteria(model.serverCriteria);
            sort(model.sort);
        }

        public final String getFilterValue() {
            return filterValue;
        }

        public final void setFilterValue(String filterValue) {
            this.filterValue = filterValue;
        }

        @Override
        public final Builder filterValue(String filterValue) {
            this.filterValue = filterValue;
            return this;
        }

        public final List<Group.Builder> getGroupIdFilter() {
            List<Group.Builder> result = GroupIdsCopier.copyToBuilder(this.groupIdFilter);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupIdFilter(Collection<Group.BuilderImpl> groupIdFilter) {
            this.groupIdFilter = GroupIdsCopier.copyFromBuilder(groupIdFilter);
        }

        @Override
        public final Builder groupIdFilter(Collection<Group> groupIdFilter) {
            this.groupIdFilter = GroupIdsCopier.copy(groupIdFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIdFilter(Group... groupIdFilter) {
            groupIdFilter(Arrays.asList(groupIdFilter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIdFilter(Consumer<Group.Builder>... groupIdFilter) {
            groupIdFilter(Stream.of(groupIdFilter).map(c -> Group.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServerCriteria() {
            return serverCriteria;
        }

        public final void setServerCriteria(String serverCriteria) {
            this.serverCriteria = serverCriteria;
        }

        @Override
        public final Builder serverCriteria(String serverCriteria) {
            this.serverCriteria = serverCriteria;
            return this;
        }

        @Override
        public final Builder serverCriteria(ServerCriteria serverCriteria) {
            this.serverCriteria(serverCriteria == null ? null : serverCriteria.toString());
            return this;
        }

        public final String getSort() {
            return sort;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public final Builder sort(SortOrder sort) {
            this.sort(sort == null ? null : sort.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServersRequest build() {
            return new ListServersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
