/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status summary of the server analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerStatusSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerStatusSummary.Builder, ServerStatusSummary> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(ServerStatusSummary::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> RUN_TIME_ASSESSMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runTimeAssessmentStatus").getter(getter(ServerStatusSummary::runTimeAssessmentStatusAsString))
            .setter(setter(Builder::runTimeAssessmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runTimeAssessmentStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD,
            RUN_TIME_ASSESSMENT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final String runTimeAssessmentStatus;

    private ServerStatusSummary(BuilderImpl builder) {
        this.count = builder.count;
        this.runTimeAssessmentStatus = builder.runTimeAssessmentStatus;
    }

    /**
     * <p>
     * The number of servers successfully analyzed, partially successful or failed analysis.
     * </p>
     * 
     * @return The number of servers successfully analyzed, partially successful or failed analysis.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The status of the run time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runTimeAssessmentStatus} will return {@link RunTimeAssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #runTimeAssessmentStatusAsString}.
     * </p>
     * 
     * @return The status of the run time.
     * @see RunTimeAssessmentStatus
     */
    public final RunTimeAssessmentStatus runTimeAssessmentStatus() {
        return RunTimeAssessmentStatus.fromValue(runTimeAssessmentStatus);
    }

    /**
     * <p>
     * The status of the run time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #runTimeAssessmentStatus} will return {@link RunTimeAssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #runTimeAssessmentStatusAsString}.
     * </p>
     * 
     * @return The status of the run time.
     * @see RunTimeAssessmentStatus
     */
    public final String runTimeAssessmentStatusAsString() {
        return runTimeAssessmentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(runTimeAssessmentStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerStatusSummary)) {
            return false;
        }
        ServerStatusSummary other = (ServerStatusSummary) obj;
        return Objects.equals(count(), other.count())
                && Objects.equals(runTimeAssessmentStatusAsString(), other.runTimeAssessmentStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerStatusSummary").add("Count", count())
                .add("RunTimeAssessmentStatus", runTimeAssessmentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "runTimeAssessmentStatus":
            return Optional.ofNullable(clazz.cast(runTimeAssessmentStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerStatusSummary, T> g) {
        return obj -> g.apply((ServerStatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerStatusSummary> {
        /**
         * <p>
         * The number of servers successfully analyzed, partially successful or failed analysis.
         * </p>
         * 
         * @param count
         *        The number of servers successfully analyzed, partially successful or failed analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The status of the run time.
         * </p>
         * 
         * @param runTimeAssessmentStatus
         *        The status of the run time.
         * @see RunTimeAssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunTimeAssessmentStatus
         */
        Builder runTimeAssessmentStatus(String runTimeAssessmentStatus);

        /**
         * <p>
         * The status of the run time.
         * </p>
         * 
         * @param runTimeAssessmentStatus
         *        The status of the run time.
         * @see RunTimeAssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunTimeAssessmentStatus
         */
        Builder runTimeAssessmentStatus(RunTimeAssessmentStatus runTimeAssessmentStatus);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private String runTimeAssessmentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerStatusSummary model) {
            count(model.count);
            runTimeAssessmentStatus(model.runTimeAssessmentStatus);
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getRunTimeAssessmentStatus() {
            return runTimeAssessmentStatus;
        }

        public final void setRunTimeAssessmentStatus(String runTimeAssessmentStatus) {
            this.runTimeAssessmentStatus = runTimeAssessmentStatus;
        }

        @Override
        public final Builder runTimeAssessmentStatus(String runTimeAssessmentStatus) {
            this.runTimeAssessmentStatus = runTimeAssessmentStatus;
            return this;
        }

        @Override
        public final Builder runTimeAssessmentStatus(RunTimeAssessmentStatus runTimeAssessmentStatus) {
            this.runTimeAssessmentStatus(runTimeAssessmentStatus == null ? null : runTimeAssessmentStatus.toString());
            return this;
        }

        @Override
        public ServerStatusSummary build() {
            return new ServerStatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
