/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.TransformationToolName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformationTool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformationTool> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(TransformationTool.getter(TransformationTool::description)).setter(TransformationTool.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TransformationTool.getter(TransformationTool::nameAsString)).setter(TransformationTool.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TRANFORMATION_TOOL_INSTALLATION_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tranformationToolInstallationLink").getter(TransformationTool.getter(TransformationTool::tranformationToolInstallationLink)).setter(TransformationTool.setter(Builder::tranformationToolInstallationLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tranformationToolInstallationLink").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, NAME_FIELD, TRANFORMATION_TOOL_INSTALLATION_LINK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("description", DESCRIPTION_FIELD);
            this.put("name", NAME_FIELD);
            this.put("tranformationToolInstallationLink", TRANFORMATION_TOOL_INSTALLATION_LINK_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String name;
    private final String tranformationToolInstallationLink;

    private TransformationTool(BuilderImpl builder) {
        this.description = builder.description;
        this.name = builder.name;
        this.tranformationToolInstallationLink = builder.tranformationToolInstallationLink;
    }

    public final String description() {
        return this.description;
    }

    public final TransformationToolName name() {
        return TransformationToolName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final String tranformationToolInstallationLink() {
        return this.tranformationToolInstallationLink;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tranformationToolInstallationLink());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformationTool)) {
            return false;
        }
        TransformationTool other = (TransformationTool)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.tranformationToolInstallationLink(), other.tranformationToolInstallationLink());
    }

    public final String toString() {
        return ToString.builder((String)"TransformationTool").add("Description", (Object)this.description()).add("Name", (Object)this.nameAsString()).add("TranformationToolInstallationLink", (Object)this.tranformationToolInstallationLink()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "tranformationToolInstallationLink": {
                return Optional.ofNullable(clazz.cast(this.tranformationToolInstallationLink()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransformationTool, T> g) {
        return obj -> g.apply((TransformationTool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String name;
        private String tranformationToolInstallationLink;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformationTool model) {
            this.description(model.description);
            this.name(model.name);
            this.tranformationToolInstallationLink(model.tranformationToolInstallationLink);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(TransformationToolName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getTranformationToolInstallationLink() {
            return this.tranformationToolInstallationLink;
        }

        public final void setTranformationToolInstallationLink(String tranformationToolInstallationLink) {
            this.tranformationToolInstallationLink = tranformationToolInstallationLink;
        }

        @Override
        public final Builder tranformationToolInstallationLink(String tranformationToolInstallationLink) {
            this.tranformationToolInstallationLink = tranformationToolInstallationLink;
            return this;
        }

        public TransformationTool build() {
            return new TransformationTool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformationTool> {
        public Builder description(String var1);

        public Builder name(String var1);

        public Builder name(TransformationToolName var1);

        public Builder tranformationToolInstallationLink(String var1);
    }
}

