/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhubstrategy.model.CollectorHealth;
import software.amazon.awssdk.services.migrationhubstrategy.model.ConfigurationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Collector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Collector> {
    private static final SdkField<String> COLLECTOR_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collectorHealth").getter(Collector.getter(Collector::collectorHealthAsString)).setter(Collector.setter(Builder::collectorHealth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectorHealth").build()}).build();
    private static final SdkField<String> COLLECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collectorId").getter(Collector.getter(Collector::collectorId)).setter(Collector.setter(Builder::collectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectorId").build()}).build();
    private static final SdkField<String> COLLECTOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collectorVersion").getter(Collector.getter(Collector::collectorVersion)).setter(Collector.setter(Builder::collectorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectorVersion").build()}).build();
    private static final SdkField<ConfigurationSummary> CONFIGURATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationSummary").getter(Collector.getter(Collector::configurationSummary)).setter(Collector.setter(Builder::configurationSummary)).constructor(ConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationSummary").build()}).build();
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostName").getter(Collector.getter(Collector::hostName)).setter(Collector.setter(Builder::hostName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostName").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddress").getter(Collector.getter(Collector::ipAddress)).setter(Collector.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> LAST_ACTIVITY_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastActivityTimeStamp").getter(Collector.getter(Collector::lastActivityTimeStamp)).setter(Collector.setter(Builder::lastActivityTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastActivityTimeStamp").build()}).build();
    private static final SdkField<String> REGISTERED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registeredTimeStamp").getter(Collector.getter(Collector::registeredTimeStamp)).setter(Collector.setter(Builder::registeredTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredTimeStamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTOR_HEALTH_FIELD, COLLECTOR_ID_FIELD, COLLECTOR_VERSION_FIELD, CONFIGURATION_SUMMARY_FIELD, HOST_NAME_FIELD, IP_ADDRESS_FIELD, LAST_ACTIVITY_TIME_STAMP_FIELD, REGISTERED_TIME_STAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String collectorHealth;
    private final String collectorId;
    private final String collectorVersion;
    private final ConfigurationSummary configurationSummary;
    private final String hostName;
    private final String ipAddress;
    private final String lastActivityTimeStamp;
    private final String registeredTimeStamp;

    private Collector(BuilderImpl builder) {
        this.collectorHealth = builder.collectorHealth;
        this.collectorId = builder.collectorId;
        this.collectorVersion = builder.collectorVersion;
        this.configurationSummary = builder.configurationSummary;
        this.hostName = builder.hostName;
        this.ipAddress = builder.ipAddress;
        this.lastActivityTimeStamp = builder.lastActivityTimeStamp;
        this.registeredTimeStamp = builder.registeredTimeStamp;
    }

    public final CollectorHealth collectorHealth() {
        return CollectorHealth.fromValue(this.collectorHealth);
    }

    public final String collectorHealthAsString() {
        return this.collectorHealth;
    }

    public final String collectorId() {
        return this.collectorId;
    }

    public final String collectorVersion() {
        return this.collectorVersion;
    }

    public final ConfigurationSummary configurationSummary() {
        return this.configurationSummary;
    }

    public final String hostName() {
        return this.hostName;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String lastActivityTimeStamp() {
        return this.lastActivityTimeStamp;
    }

    public final String registeredTimeStamp() {
        return this.registeredTimeStamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectorHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastActivityTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredTimeStamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Collector)) {
            return false;
        }
        Collector other = (Collector)obj;
        return Objects.equals(this.collectorHealthAsString(), other.collectorHealthAsString()) && Objects.equals(this.collectorId(), other.collectorId()) && Objects.equals(this.collectorVersion(), other.collectorVersion()) && Objects.equals(this.configurationSummary(), other.configurationSummary()) && Objects.equals(this.hostName(), other.hostName()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.lastActivityTimeStamp(), other.lastActivityTimeStamp()) && Objects.equals(this.registeredTimeStamp(), other.registeredTimeStamp());
    }

    public final String toString() {
        return ToString.builder((String)"Collector").add("CollectorHealth", (Object)this.collectorHealthAsString()).add("CollectorId", (Object)this.collectorId()).add("CollectorVersion", (Object)this.collectorVersion()).add("ConfigurationSummary", (Object)this.configurationSummary()).add("HostName", (Object)this.hostName()).add("IpAddress", (Object)this.ipAddress()).add("LastActivityTimeStamp", (Object)this.lastActivityTimeStamp()).add("RegisteredTimeStamp", (Object)this.registeredTimeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collectorHealth": {
                return Optional.ofNullable(clazz.cast(this.collectorHealthAsString()));
            }
            case "collectorId": {
                return Optional.ofNullable(clazz.cast(this.collectorId()));
            }
            case "collectorVersion": {
                return Optional.ofNullable(clazz.cast(this.collectorVersion()));
            }
            case "configurationSummary": {
                return Optional.ofNullable(clazz.cast(this.configurationSummary()));
            }
            case "hostName": {
                return Optional.ofNullable(clazz.cast(this.hostName()));
            }
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "lastActivityTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastActivityTimeStamp()));
            }
            case "registeredTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.registeredTimeStamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("collectorHealth", COLLECTOR_HEALTH_FIELD);
        map.put("collectorId", COLLECTOR_ID_FIELD);
        map.put("collectorVersion", COLLECTOR_VERSION_FIELD);
        map.put("configurationSummary", CONFIGURATION_SUMMARY_FIELD);
        map.put("hostName", HOST_NAME_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("lastActivityTimeStamp", LAST_ACTIVITY_TIME_STAMP_FIELD);
        map.put("registeredTimeStamp", REGISTERED_TIME_STAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Collector, T> g) {
        return obj -> g.apply((Collector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String collectorHealth;
        private String collectorId;
        private String collectorVersion;
        private ConfigurationSummary configurationSummary;
        private String hostName;
        private String ipAddress;
        private String lastActivityTimeStamp;
        private String registeredTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Collector model) {
            this.collectorHealth(model.collectorHealth);
            this.collectorId(model.collectorId);
            this.collectorVersion(model.collectorVersion);
            this.configurationSummary(model.configurationSummary);
            this.hostName(model.hostName);
            this.ipAddress(model.ipAddress);
            this.lastActivityTimeStamp(model.lastActivityTimeStamp);
            this.registeredTimeStamp(model.registeredTimeStamp);
        }

        public final String getCollectorHealth() {
            return this.collectorHealth;
        }

        public final void setCollectorHealth(String collectorHealth) {
            this.collectorHealth = collectorHealth;
        }

        @Override
        public final Builder collectorHealth(String collectorHealth) {
            this.collectorHealth = collectorHealth;
            return this;
        }

        @Override
        public final Builder collectorHealth(CollectorHealth collectorHealth) {
            this.collectorHealth(collectorHealth == null ? null : collectorHealth.toString());
            return this;
        }

        public final String getCollectorId() {
            return this.collectorId;
        }

        public final void setCollectorId(String collectorId) {
            this.collectorId = collectorId;
        }

        @Override
        public final Builder collectorId(String collectorId) {
            this.collectorId = collectorId;
            return this;
        }

        public final String getCollectorVersion() {
            return this.collectorVersion;
        }

        public final void setCollectorVersion(String collectorVersion) {
            this.collectorVersion = collectorVersion;
        }

        @Override
        public final Builder collectorVersion(String collectorVersion) {
            this.collectorVersion = collectorVersion;
            return this;
        }

        public final ConfigurationSummary.Builder getConfigurationSummary() {
            return this.configurationSummary != null ? this.configurationSummary.toBuilder() : null;
        }

        public final void setConfigurationSummary(ConfigurationSummary.BuilderImpl configurationSummary) {
            this.configurationSummary = configurationSummary != null ? configurationSummary.build() : null;
        }

        @Override
        public final Builder configurationSummary(ConfigurationSummary configurationSummary) {
            this.configurationSummary = configurationSummary;
            return this;
        }

        public final String getHostName() {
            return this.hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getLastActivityTimeStamp() {
            return this.lastActivityTimeStamp;
        }

        public final void setLastActivityTimeStamp(String lastActivityTimeStamp) {
            this.lastActivityTimeStamp = lastActivityTimeStamp;
        }

        @Override
        public final Builder lastActivityTimeStamp(String lastActivityTimeStamp) {
            this.lastActivityTimeStamp = lastActivityTimeStamp;
            return this;
        }

        public final String getRegisteredTimeStamp() {
            return this.registeredTimeStamp;
        }

        public final void setRegisteredTimeStamp(String registeredTimeStamp) {
            this.registeredTimeStamp = registeredTimeStamp;
        }

        @Override
        public final Builder registeredTimeStamp(String registeredTimeStamp) {
            this.registeredTimeStamp = registeredTimeStamp;
            return this;
        }

        public Collector build() {
            return new Collector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Collector> {
        public Builder collectorHealth(String var1);

        public Builder collectorHealth(CollectorHealth var1);

        public Builder collectorId(String var1);

        public Builder collectorVersion(String var1);

        public Builder configurationSummary(ConfigurationSummary var1);

        default public Builder configurationSummary(Consumer<ConfigurationSummary.Builder> configurationSummary) {
            return this.configurationSummary((ConfigurationSummary)((ConfigurationSummary.Builder)ConfigurationSummary.builder().applyMutation(configurationSummary)).build());
        }

        public Builder hostName(String var1);

        public Builder ipAddress(String var1);

        public Builder lastActivityTimeStamp(String var1);

        public Builder registeredTimeStamp(String var1);
    }
}

