/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The anti-pattern report result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AntipatternReportResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AntipatternReportResult.Builder, AntipatternReportResult> {
    private static final SdkField<AnalyzerNameUnion> ANALYZER_NAME_FIELD = SdkField
            .<AnalyzerNameUnion> builder(MarshallingType.SDK_POJO).memberName("analyzerName")
            .getter(getter(AntipatternReportResult::analyzerName)).setter(setter(Builder::analyzerName))
            .constructor(AnalyzerNameUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerName").build()).build();

    private static final SdkField<S3Object> ANTI_PATTERN_REPORT_S3_OBJECT_FIELD = SdkField
            .<S3Object> builder(MarshallingType.SDK_POJO).memberName("antiPatternReportS3Object")
            .getter(getter(AntipatternReportResult::antiPatternReportS3Object))
            .setter(setter(Builder::antiPatternReportS3Object)).constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antiPatternReportS3Object").build())
            .build();

    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("antipatternReportStatus").getter(getter(AntipatternReportResult::antipatternReportStatusAsString))
            .setter(setter(Builder::antipatternReportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatus").build())
            .build();

    private static final SdkField<String> ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("antipatternReportStatusMessage")
            .getter(getter(AntipatternReportResult::antipatternReportStatusMessage))
            .setter(setter(Builder::antipatternReportStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportStatusMessage")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_NAME_FIELD,
            ANTI_PATTERN_REPORT_S3_OBJECT_FIELD, ANTIPATTERN_REPORT_STATUS_FIELD, ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AnalyzerNameUnion analyzerName;

    private final S3Object antiPatternReportS3Object;

    private final String antipatternReportStatus;

    private final String antipatternReportStatusMessage;

    private AntipatternReportResult(BuilderImpl builder) {
        this.analyzerName = builder.analyzerName;
        this.antiPatternReportS3Object = builder.antiPatternReportS3Object;
        this.antipatternReportStatus = builder.antipatternReportStatus;
        this.antipatternReportStatusMessage = builder.antipatternReportStatusMessage;
    }

    /**
     * <p>
     * The analyzer name.
     * </p>
     * 
     * @return The analyzer name.
     */
    public final AnalyzerNameUnion analyzerName() {
        return analyzerName;
    }

    /**
     * Returns the value of the AntiPatternReportS3Object property for this object.
     * 
     * @return The value of the AntiPatternReportS3Object property for this object.
     */
    public final S3Object antiPatternReportS3Object() {
        return antiPatternReportS3Object;
    }

    /**
     * <p>
     * The status of the anti-pattern report generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #antipatternReportStatus} will return {@link AntipatternReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #antipatternReportStatusAsString}.
     * </p>
     * 
     * @return The status of the anti-pattern report generation.
     * @see AntipatternReportStatus
     */
    public final AntipatternReportStatus antipatternReportStatus() {
        return AntipatternReportStatus.fromValue(antipatternReportStatus);
    }

    /**
     * <p>
     * The status of the anti-pattern report generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #antipatternReportStatus} will return {@link AntipatternReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #antipatternReportStatusAsString}.
     * </p>
     * 
     * @return The status of the anti-pattern report generation.
     * @see AntipatternReportStatus
     */
    public final String antipatternReportStatusAsString() {
        return antipatternReportStatus;
    }

    /**
     * <p>
     * The status message for the anti-pattern.
     * </p>
     * 
     * @return The status message for the anti-pattern.
     */
    public final String antipatternReportStatusMessage() {
        return antipatternReportStatusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analyzerName());
        hashCode = 31 * hashCode + Objects.hashCode(antiPatternReportS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(antipatternReportStatusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AntipatternReportResult)) {
            return false;
        }
        AntipatternReportResult other = (AntipatternReportResult) obj;
        return Objects.equals(analyzerName(), other.analyzerName())
                && Objects.equals(antiPatternReportS3Object(), other.antiPatternReportS3Object())
                && Objects.equals(antipatternReportStatusAsString(), other.antipatternReportStatusAsString())
                && Objects.equals(antipatternReportStatusMessage(), other.antipatternReportStatusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AntipatternReportResult").add("AnalyzerName", analyzerName())
                .add("AntiPatternReportS3Object", antiPatternReportS3Object())
                .add("AntipatternReportStatus", antipatternReportStatusAsString())
                .add("AntipatternReportStatusMessage", antipatternReportStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzerName":
            return Optional.ofNullable(clazz.cast(analyzerName()));
        case "antiPatternReportS3Object":
            return Optional.ofNullable(clazz.cast(antiPatternReportS3Object()));
        case "antipatternReportStatus":
            return Optional.ofNullable(clazz.cast(antipatternReportStatusAsString()));
        case "antipatternReportStatusMessage":
            return Optional.ofNullable(clazz.cast(antipatternReportStatusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analyzerName", ANALYZER_NAME_FIELD);
        map.put("antiPatternReportS3Object", ANTI_PATTERN_REPORT_S3_OBJECT_FIELD);
        map.put("antipatternReportStatus", ANTIPATTERN_REPORT_STATUS_FIELD);
        map.put("antipatternReportStatusMessage", ANTIPATTERN_REPORT_STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AntipatternReportResult, T> g) {
        return obj -> g.apply((AntipatternReportResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AntipatternReportResult> {
        /**
         * <p>
         * The analyzer name.
         * </p>
         * 
         * @param analyzerName
         *        The analyzer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerName(AnalyzerNameUnion analyzerName);

        /**
         * <p>
         * The analyzer name.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalyzerNameUnion.Builder} avoiding the
         * need to create one manually via {@link AnalyzerNameUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalyzerNameUnion.Builder#build()} is called immediately and its
         * result is passed to {@link #analyzerName(AnalyzerNameUnion)}.
         * 
         * @param analyzerName
         *        a consumer that will call methods on {@link AnalyzerNameUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyzerName(AnalyzerNameUnion)
         */
        default Builder analyzerName(Consumer<AnalyzerNameUnion.Builder> analyzerName) {
            return analyzerName(AnalyzerNameUnion.builder().applyMutation(analyzerName).build());
        }

        /**
         * Sets the value of the AntiPatternReportS3Object property for this object.
         *
         * @param antiPatternReportS3Object
         *        The new value for the AntiPatternReportS3Object property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antiPatternReportS3Object(S3Object antiPatternReportS3Object);

        /**
         * Sets the value of the AntiPatternReportS3Object property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Object.Builder} avoiding the need to
         * create one manually via {@link S3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #antiPatternReportS3Object(S3Object)}.
         * 
         * @param antiPatternReportS3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #antiPatternReportS3Object(S3Object)
         */
        default Builder antiPatternReportS3Object(Consumer<S3Object.Builder> antiPatternReportS3Object) {
            return antiPatternReportS3Object(S3Object.builder().applyMutation(antiPatternReportS3Object).build());
        }

        /**
         * <p>
         * The status of the anti-pattern report generation.
         * </p>
         * 
         * @param antipatternReportStatus
         *        The status of the anti-pattern report generation.
         * @see AntipatternReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AntipatternReportStatus
         */
        Builder antipatternReportStatus(String antipatternReportStatus);

        /**
         * <p>
         * The status of the anti-pattern report generation.
         * </p>
         * 
         * @param antipatternReportStatus
         *        The status of the anti-pattern report generation.
         * @see AntipatternReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AntipatternReportStatus
         */
        Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus);

        /**
         * <p>
         * The status message for the anti-pattern.
         * </p>
         * 
         * @param antipatternReportStatusMessage
         *        The status message for the anti-pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antipatternReportStatusMessage(String antipatternReportStatusMessage);
    }

    static final class BuilderImpl implements Builder {
        private AnalyzerNameUnion analyzerName;

        private S3Object antiPatternReportS3Object;

        private String antipatternReportStatus;

        private String antipatternReportStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AntipatternReportResult model) {
            analyzerName(model.analyzerName);
            antiPatternReportS3Object(model.antiPatternReportS3Object);
            antipatternReportStatus(model.antipatternReportStatus);
            antipatternReportStatusMessage(model.antipatternReportStatusMessage);
        }

        public final AnalyzerNameUnion.Builder getAnalyzerName() {
            return analyzerName != null ? analyzerName.toBuilder() : null;
        }

        public final void setAnalyzerName(AnalyzerNameUnion.BuilderImpl analyzerName) {
            this.analyzerName = analyzerName != null ? analyzerName.build() : null;
        }

        @Override
        public final Builder analyzerName(AnalyzerNameUnion analyzerName) {
            this.analyzerName = analyzerName;
            return this;
        }

        public final S3Object.Builder getAntiPatternReportS3Object() {
            return antiPatternReportS3Object != null ? antiPatternReportS3Object.toBuilder() : null;
        }

        public final void setAntiPatternReportS3Object(S3Object.BuilderImpl antiPatternReportS3Object) {
            this.antiPatternReportS3Object = antiPatternReportS3Object != null ? antiPatternReportS3Object.build() : null;
        }

        @Override
        public final Builder antiPatternReportS3Object(S3Object antiPatternReportS3Object) {
            this.antiPatternReportS3Object = antiPatternReportS3Object;
            return this;
        }

        public final String getAntipatternReportStatus() {
            return antipatternReportStatus;
        }

        public final void setAntipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
        }

        @Override
        public final Builder antipatternReportStatus(String antipatternReportStatus) {
            this.antipatternReportStatus = antipatternReportStatus;
            return this;
        }

        @Override
        public final Builder antipatternReportStatus(AntipatternReportStatus antipatternReportStatus) {
            this.antipatternReportStatus(antipatternReportStatus == null ? null : antipatternReportStatus.toString());
            return this;
        }

        public final String getAntipatternReportStatusMessage() {
            return antipatternReportStatusMessage;
        }

        public final void setAntipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
        }

        @Override
        public final Builder antipatternReportStatusMessage(String antipatternReportStatusMessage) {
            this.antipatternReportStatusMessage = antipatternReportStatusMessage;
            return this;
        }

        @Override
        public AntipatternReportResult build() {
            return new AntipatternReportResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
