/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error in the analysis of the application unit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppUnitError implements SdkPojo, Serializable, ToCopyableBuilder<AppUnitError.Builder, AppUnitError> {
    private static final SdkField<String> APP_UNIT_ERROR_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appUnitErrorCategory").getter(getter(AppUnitError::appUnitErrorCategoryAsString))
            .setter(setter(Builder::appUnitErrorCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appUnitErrorCategory").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(APP_UNIT_ERROR_CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appUnitErrorCategory;

    private AppUnitError(BuilderImpl builder) {
        this.appUnitErrorCategory = builder.appUnitErrorCategory;
    }

    /**
     * <p>
     * The category of the error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appUnitErrorCategory} will return {@link AppUnitErrorCategory#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appUnitErrorCategoryAsString}.
     * </p>
     * 
     * @return The category of the error.
     * @see AppUnitErrorCategory
     */
    public final AppUnitErrorCategory appUnitErrorCategory() {
        return AppUnitErrorCategory.fromValue(appUnitErrorCategory);
    }

    /**
     * <p>
     * The category of the error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appUnitErrorCategory} will return {@link AppUnitErrorCategory#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appUnitErrorCategoryAsString}.
     * </p>
     * 
     * @return The category of the error.
     * @see AppUnitErrorCategory
     */
    public final String appUnitErrorCategoryAsString() {
        return appUnitErrorCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appUnitErrorCategoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppUnitError)) {
            return false;
        }
        AppUnitError other = (AppUnitError) obj;
        return Objects.equals(appUnitErrorCategoryAsString(), other.appUnitErrorCategoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppUnitError").add("AppUnitErrorCategory", appUnitErrorCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appUnitErrorCategory":
            return Optional.ofNullable(clazz.cast(appUnitErrorCategoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appUnitErrorCategory", APP_UNIT_ERROR_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppUnitError, T> g) {
        return obj -> g.apply((AppUnitError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppUnitError> {
        /**
         * <p>
         * The category of the error.
         * </p>
         * 
         * @param appUnitErrorCategory
         *        The category of the error.
         * @see AppUnitErrorCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppUnitErrorCategory
         */
        Builder appUnitErrorCategory(String appUnitErrorCategory);

        /**
         * <p>
         * The category of the error.
         * </p>
         * 
         * @param appUnitErrorCategory
         *        The category of the error.
         * @see AppUnitErrorCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppUnitErrorCategory
         */
        Builder appUnitErrorCategory(AppUnitErrorCategory appUnitErrorCategory);
    }

    static final class BuilderImpl implements Builder {
        private String appUnitErrorCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(AppUnitError model) {
            appUnitErrorCategory(model.appUnitErrorCategory);
        }

        public final String getAppUnitErrorCategory() {
            return appUnitErrorCategory;
        }

        public final void setAppUnitErrorCategory(String appUnitErrorCategory) {
            this.appUnitErrorCategory = appUnitErrorCategory;
        }

        @Override
        public final Builder appUnitErrorCategory(String appUnitErrorCategory) {
            this.appUnitErrorCategory = appUnitErrorCategory;
            return this;
        }

        @Override
        public final Builder appUnitErrorCategory(AppUnitErrorCategory appUnitErrorCategory) {
            this.appUnitErrorCategory(appUnitErrorCategory == null ? null : appUnitErrorCategory.toString());
            return this;
        }

        @Override
        public AppUnitError build() {
            return new AppUnitError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
