/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the analysis status of the application component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationComponentStatusSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationComponentStatusSummary.Builder, ApplicationComponentStatusSummary> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(ApplicationComponentStatusSummary::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> SRC_CODE_OR_DB_ANALYSIS_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("srcCodeOrDbAnalysisStatus")
            .getter(getter(ApplicationComponentStatusSummary::srcCodeOrDbAnalysisStatusAsString))
            .setter(setter(Builder::srcCodeOrDbAnalysisStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srcCodeOrDbAnalysisStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD,
            SRC_CODE_OR_DB_ANALYSIS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final String srcCodeOrDbAnalysisStatus;

    private ApplicationComponentStatusSummary(BuilderImpl builder) {
        this.count = builder.count;
        this.srcCodeOrDbAnalysisStatus = builder.srcCodeOrDbAnalysisStatus;
    }

    /**
     * <p>
     * The number of application components successfully analyzed, partially successful or failed analysis.
     * </p>
     * 
     * @return The number of application components successfully analyzed, partially successful or failed analysis.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The status of database analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #srcCodeOrDbAnalysisStatus} will return {@link SrcCodeOrDbAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #srcCodeOrDbAnalysisStatusAsString}.
     * </p>
     * 
     * @return The status of database analysis.
     * @see SrcCodeOrDbAnalysisStatus
     */
    public final SrcCodeOrDbAnalysisStatus srcCodeOrDbAnalysisStatus() {
        return SrcCodeOrDbAnalysisStatus.fromValue(srcCodeOrDbAnalysisStatus);
    }

    /**
     * <p>
     * The status of database analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #srcCodeOrDbAnalysisStatus} will return {@link SrcCodeOrDbAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #srcCodeOrDbAnalysisStatusAsString}.
     * </p>
     * 
     * @return The status of database analysis.
     * @see SrcCodeOrDbAnalysisStatus
     */
    public final String srcCodeOrDbAnalysisStatusAsString() {
        return srcCodeOrDbAnalysisStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(srcCodeOrDbAnalysisStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationComponentStatusSummary)) {
            return false;
        }
        ApplicationComponentStatusSummary other = (ApplicationComponentStatusSummary) obj;
        return Objects.equals(count(), other.count())
                && Objects.equals(srcCodeOrDbAnalysisStatusAsString(), other.srcCodeOrDbAnalysisStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationComponentStatusSummary").add("Count", count())
                .add("SrcCodeOrDbAnalysisStatus", srcCodeOrDbAnalysisStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "srcCodeOrDbAnalysisStatus":
            return Optional.ofNullable(clazz.cast(srcCodeOrDbAnalysisStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("count", COUNT_FIELD);
        map.put("srcCodeOrDbAnalysisStatus", SRC_CODE_OR_DB_ANALYSIS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationComponentStatusSummary, T> g) {
        return obj -> g.apply((ApplicationComponentStatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationComponentStatusSummary> {
        /**
         * <p>
         * The number of application components successfully analyzed, partially successful or failed analysis.
         * </p>
         * 
         * @param count
         *        The number of application components successfully analyzed, partially successful or failed analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The status of database analysis.
         * </p>
         * 
         * @param srcCodeOrDbAnalysisStatus
         *        The status of database analysis.
         * @see SrcCodeOrDbAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SrcCodeOrDbAnalysisStatus
         */
        Builder srcCodeOrDbAnalysisStatus(String srcCodeOrDbAnalysisStatus);

        /**
         * <p>
         * The status of database analysis.
         * </p>
         * 
         * @param srcCodeOrDbAnalysisStatus
         *        The status of database analysis.
         * @see SrcCodeOrDbAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SrcCodeOrDbAnalysisStatus
         */
        Builder srcCodeOrDbAnalysisStatus(SrcCodeOrDbAnalysisStatus srcCodeOrDbAnalysisStatus);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private String srcCodeOrDbAnalysisStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationComponentStatusSummary model) {
            count(model.count);
            srcCodeOrDbAnalysisStatus(model.srcCodeOrDbAnalysisStatus);
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getSrcCodeOrDbAnalysisStatus() {
            return srcCodeOrDbAnalysisStatus;
        }

        public final void setSrcCodeOrDbAnalysisStatus(String srcCodeOrDbAnalysisStatus) {
            this.srcCodeOrDbAnalysisStatus = srcCodeOrDbAnalysisStatus;
        }

        @Override
        public final Builder srcCodeOrDbAnalysisStatus(String srcCodeOrDbAnalysisStatus) {
            this.srcCodeOrDbAnalysisStatus = srcCodeOrDbAnalysisStatus;
            return this;
        }

        @Override
        public final Builder srcCodeOrDbAnalysisStatus(SrcCodeOrDbAnalysisStatus srcCodeOrDbAnalysisStatus) {
            this.srcCodeOrDbAnalysisStatus(srcCodeOrDbAnalysisStatus == null ? null : srcCodeOrDbAnalysisStatus.toString());
            return this;
        }

        @Override
        public ApplicationComponentStatusSummary build() {
            return new ApplicationComponentStatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
