/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Process data collector that runs in the environment that you specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Collector implements SdkPojo, Serializable, ToCopyableBuilder<Collector.Builder, Collector> {
    private static final SdkField<String> COLLECTOR_HEALTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collectorHealth").getter(getter(Collector::collectorHealthAsString))
            .setter(setter(Builder::collectorHealth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectorHealth").build()).build();

    private static final SdkField<String> COLLECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collectorId").getter(getter(Collector::collectorId)).setter(setter(Builder::collectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectorId").build()).build();

    private static final SdkField<String> COLLECTOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collectorVersion").getter(getter(Collector::collectorVersion)).setter(setter(Builder::collectorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectorVersion").build()).build();

    private static final SdkField<ConfigurationSummary> CONFIGURATION_SUMMARY_FIELD = SdkField
            .<ConfigurationSummary> builder(MarshallingType.SDK_POJO).memberName("configurationSummary")
            .getter(getter(Collector::configurationSummary)).setter(setter(Builder::configurationSummary))
            .constructor(ConfigurationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationSummary").build())
            .build();

    private static final SdkField<String> HOST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostName").getter(getter(Collector::hostName)).setter(setter(Builder::hostName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostName").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddress").getter(getter(Collector::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()).build();

    private static final SdkField<String> LAST_ACTIVITY_TIME_STAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastActivityTimeStamp").getter(getter(Collector::lastActivityTimeStamp))
            .setter(setter(Builder::lastActivityTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastActivityTimeStamp").build())
            .build();

    private static final SdkField<String> REGISTERED_TIME_STAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registeredTimeStamp").getter(getter(Collector::registeredTimeStamp))
            .setter(setter(Builder::registeredTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredTimeStamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTOR_HEALTH_FIELD,
            COLLECTOR_ID_FIELD, COLLECTOR_VERSION_FIELD, CONFIGURATION_SUMMARY_FIELD, HOST_NAME_FIELD, IP_ADDRESS_FIELD,
            LAST_ACTIVITY_TIME_STAMP_FIELD, REGISTERED_TIME_STAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String collectorHealth;

    private final String collectorId;

    private final String collectorVersion;

    private final ConfigurationSummary configurationSummary;

    private final String hostName;

    private final String ipAddress;

    private final String lastActivityTimeStamp;

    private final String registeredTimeStamp;

    private Collector(BuilderImpl builder) {
        this.collectorHealth = builder.collectorHealth;
        this.collectorId = builder.collectorId;
        this.collectorVersion = builder.collectorVersion;
        this.configurationSummary = builder.configurationSummary;
        this.hostName = builder.hostName;
        this.ipAddress = builder.ipAddress;
        this.lastActivityTimeStamp = builder.lastActivityTimeStamp;
        this.registeredTimeStamp = builder.registeredTimeStamp;
    }

    /**
     * <p>
     * Indicates the health of a collector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #collectorHealth}
     * will return {@link CollectorHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #collectorHealthAsString}.
     * </p>
     * 
     * @return Indicates the health of a collector.
     * @see CollectorHealth
     */
    public final CollectorHealth collectorHealth() {
        return CollectorHealth.fromValue(collectorHealth);
    }

    /**
     * <p>
     * Indicates the health of a collector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #collectorHealth}
     * will return {@link CollectorHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #collectorHealthAsString}.
     * </p>
     * 
     * @return Indicates the health of a collector.
     * @see CollectorHealth
     */
    public final String collectorHealthAsString() {
        return collectorHealth;
    }

    /**
     * <p>
     * The ID of the collector.
     * </p>
     * 
     * @return The ID of the collector.
     */
    public final String collectorId() {
        return collectorId;
    }

    /**
     * <p>
     * Current version of the collector that is running in the environment that you specify.
     * </p>
     * 
     * @return Current version of the collector that is running in the environment that you specify.
     */
    public final String collectorVersion() {
        return collectorVersion;
    }

    /**
     * <p>
     * Summary of the collector configuration.
     * </p>
     * 
     * @return Summary of the collector configuration.
     */
    public final ConfigurationSummary configurationSummary() {
        return configurationSummary;
    }

    /**
     * <p>
     * Hostname of the server that is hosting the collector.
     * </p>
     * 
     * @return Hostname of the server that is hosting the collector.
     */
    public final String hostName() {
        return hostName;
    }

    /**
     * <p>
     * IP address of the server that is hosting the collector.
     * </p>
     * 
     * @return IP address of the server that is hosting the collector.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * Time when the collector last pinged the service.
     * </p>
     * 
     * @return Time when the collector last pinged the service.
     */
    public final String lastActivityTimeStamp() {
        return lastActivityTimeStamp;
    }

    /**
     * <p>
     * Time when the collector registered with the service.
     * </p>
     * 
     * @return Time when the collector registered with the service.
     */
    public final String registeredTimeStamp() {
        return registeredTimeStamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectorHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(collectorId());
        hashCode = 31 * hashCode + Objects.hashCode(collectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hostName());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(lastActivityTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(registeredTimeStamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Collector)) {
            return false;
        }
        Collector other = (Collector) obj;
        return Objects.equals(collectorHealthAsString(), other.collectorHealthAsString())
                && Objects.equals(collectorId(), other.collectorId())
                && Objects.equals(collectorVersion(), other.collectorVersion())
                && Objects.equals(configurationSummary(), other.configurationSummary())
                && Objects.equals(hostName(), other.hostName()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(lastActivityTimeStamp(), other.lastActivityTimeStamp())
                && Objects.equals(registeredTimeStamp(), other.registeredTimeStamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Collector").add("CollectorHealth", collectorHealthAsString()).add("CollectorId", collectorId())
                .add("CollectorVersion", collectorVersion()).add("ConfigurationSummary", configurationSummary())
                .add("HostName", hostName()).add("IpAddress", ipAddress()).add("LastActivityTimeStamp", lastActivityTimeStamp())
                .add("RegisteredTimeStamp", registeredTimeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collectorHealth":
            return Optional.ofNullable(clazz.cast(collectorHealthAsString()));
        case "collectorId":
            return Optional.ofNullable(clazz.cast(collectorId()));
        case "collectorVersion":
            return Optional.ofNullable(clazz.cast(collectorVersion()));
        case "configurationSummary":
            return Optional.ofNullable(clazz.cast(configurationSummary()));
        case "hostName":
            return Optional.ofNullable(clazz.cast(hostName()));
        case "ipAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "lastActivityTimeStamp":
            return Optional.ofNullable(clazz.cast(lastActivityTimeStamp()));
        case "registeredTimeStamp":
            return Optional.ofNullable(clazz.cast(registeredTimeStamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collectorHealth", COLLECTOR_HEALTH_FIELD);
        map.put("collectorId", COLLECTOR_ID_FIELD);
        map.put("collectorVersion", COLLECTOR_VERSION_FIELD);
        map.put("configurationSummary", CONFIGURATION_SUMMARY_FIELD);
        map.put("hostName", HOST_NAME_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("lastActivityTimeStamp", LAST_ACTIVITY_TIME_STAMP_FIELD);
        map.put("registeredTimeStamp", REGISTERED_TIME_STAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Collector, T> g) {
        return obj -> g.apply((Collector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Collector> {
        /**
         * <p>
         * Indicates the health of a collector.
         * </p>
         * 
         * @param collectorHealth
         *        Indicates the health of a collector.
         * @see CollectorHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectorHealth
         */
        Builder collectorHealth(String collectorHealth);

        /**
         * <p>
         * Indicates the health of a collector.
         * </p>
         * 
         * @param collectorHealth
         *        Indicates the health of a collector.
         * @see CollectorHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectorHealth
         */
        Builder collectorHealth(CollectorHealth collectorHealth);

        /**
         * <p>
         * The ID of the collector.
         * </p>
         * 
         * @param collectorId
         *        The ID of the collector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectorId(String collectorId);

        /**
         * <p>
         * Current version of the collector that is running in the environment that you specify.
         * </p>
         * 
         * @param collectorVersion
         *        Current version of the collector that is running in the environment that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectorVersion(String collectorVersion);

        /**
         * <p>
         * Summary of the collector configuration.
         * </p>
         * 
         * @param configurationSummary
         *        Summary of the collector configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSummary(ConfigurationSummary configurationSummary);

        /**
         * <p>
         * Summary of the collector configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationSummary.Builder} avoiding
         * the need to create one manually via {@link ConfigurationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationSummary(ConfigurationSummary)}.
         * 
         * @param configurationSummary
         *        a consumer that will call methods on {@link ConfigurationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationSummary(ConfigurationSummary)
         */
        default Builder configurationSummary(Consumer<ConfigurationSummary.Builder> configurationSummary) {
            return configurationSummary(ConfigurationSummary.builder().applyMutation(configurationSummary).build());
        }

        /**
         * <p>
         * Hostname of the server that is hosting the collector.
         * </p>
         * 
         * @param hostName
         *        Hostname of the server that is hosting the collector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostName(String hostName);

        /**
         * <p>
         * IP address of the server that is hosting the collector.
         * </p>
         * 
         * @param ipAddress
         *        IP address of the server that is hosting the collector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * Time when the collector last pinged the service.
         * </p>
         * 
         * @param lastActivityTimeStamp
         *        Time when the collector last pinged the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastActivityTimeStamp(String lastActivityTimeStamp);

        /**
         * <p>
         * Time when the collector registered with the service.
         * </p>
         * 
         * @param registeredTimeStamp
         *        Time when the collector registered with the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredTimeStamp(String registeredTimeStamp);
    }

    static final class BuilderImpl implements Builder {
        private String collectorHealth;

        private String collectorId;

        private String collectorVersion;

        private ConfigurationSummary configurationSummary;

        private String hostName;

        private String ipAddress;

        private String lastActivityTimeStamp;

        private String registeredTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Collector model) {
            collectorHealth(model.collectorHealth);
            collectorId(model.collectorId);
            collectorVersion(model.collectorVersion);
            configurationSummary(model.configurationSummary);
            hostName(model.hostName);
            ipAddress(model.ipAddress);
            lastActivityTimeStamp(model.lastActivityTimeStamp);
            registeredTimeStamp(model.registeredTimeStamp);
        }

        public final String getCollectorHealth() {
            return collectorHealth;
        }

        public final void setCollectorHealth(String collectorHealth) {
            this.collectorHealth = collectorHealth;
        }

        @Override
        public final Builder collectorHealth(String collectorHealth) {
            this.collectorHealth = collectorHealth;
            return this;
        }

        @Override
        public final Builder collectorHealth(CollectorHealth collectorHealth) {
            this.collectorHealth(collectorHealth == null ? null : collectorHealth.toString());
            return this;
        }

        public final String getCollectorId() {
            return collectorId;
        }

        public final void setCollectorId(String collectorId) {
            this.collectorId = collectorId;
        }

        @Override
        public final Builder collectorId(String collectorId) {
            this.collectorId = collectorId;
            return this;
        }

        public final String getCollectorVersion() {
            return collectorVersion;
        }

        public final void setCollectorVersion(String collectorVersion) {
            this.collectorVersion = collectorVersion;
        }

        @Override
        public final Builder collectorVersion(String collectorVersion) {
            this.collectorVersion = collectorVersion;
            return this;
        }

        public final ConfigurationSummary.Builder getConfigurationSummary() {
            return configurationSummary != null ? configurationSummary.toBuilder() : null;
        }

        public final void setConfigurationSummary(ConfigurationSummary.BuilderImpl configurationSummary) {
            this.configurationSummary = configurationSummary != null ? configurationSummary.build() : null;
        }

        @Override
        public final Builder configurationSummary(ConfigurationSummary configurationSummary) {
            this.configurationSummary = configurationSummary;
            return this;
        }

        public final String getHostName() {
            return hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getLastActivityTimeStamp() {
            return lastActivityTimeStamp;
        }

        public final void setLastActivityTimeStamp(String lastActivityTimeStamp) {
            this.lastActivityTimeStamp = lastActivityTimeStamp;
        }

        @Override
        public final Builder lastActivityTimeStamp(String lastActivityTimeStamp) {
            this.lastActivityTimeStamp = lastActivityTimeStamp;
            return this;
        }

        public final String getRegisteredTimeStamp() {
            return registeredTimeStamp;
        }

        public final void setRegisteredTimeStamp(String registeredTimeStamp) {
            this.registeredTimeStamp = registeredTimeStamp;
        }

        @Override
        public final Builder registeredTimeStamp(String registeredTimeStamp) {
            this.registeredTimeStamp = registeredTimeStamp;
            return this;
        }

        @Override
        public Collector build() {
            return new Collector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
