/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationComponentStrategiesRequest extends MigrationHubStrategyRequest implements
        ToCopyableBuilder<GetApplicationComponentStrategiesRequest.Builder, GetApplicationComponentStrategiesRequest> {
    private static final SdkField<String> APPLICATION_COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationComponentId")
            .getter(getter(GetApplicationComponentStrategiesRequest::applicationComponentId))
            .setter(setter(Builder::applicationComponentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationComponentId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_COMPONENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationComponentId;

    private GetApplicationComponentStrategiesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationComponentId = builder.applicationComponentId;
    }

    /**
     * <p>
     * The ID of the application component. The ID is unique within an AWS account.
     * </p>
     * 
     * @return The ID of the application component. The ID is unique within an AWS account.
     */
    public final String applicationComponentId() {
        return applicationComponentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationComponentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationComponentStrategiesRequest)) {
            return false;
        }
        GetApplicationComponentStrategiesRequest other = (GetApplicationComponentStrategiesRequest) obj;
        return Objects.equals(applicationComponentId(), other.applicationComponentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationComponentStrategiesRequest")
                .add("ApplicationComponentId", applicationComponentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationComponentId":
            return Optional.ofNullable(clazz.cast(applicationComponentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationComponentId", APPLICATION_COMPONENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationComponentStrategiesRequest, T> g) {
        return obj -> g.apply((GetApplicationComponentStrategiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationComponentStrategiesRequest> {
        /**
         * <p>
         * The ID of the application component. The ID is unique within an AWS account.
         * </p>
         * 
         * @param applicationComponentId
         *        The ID of the application component. The ID is unique within an AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponentId(String applicationComponentId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubStrategyRequest.BuilderImpl implements Builder {
        private String applicationComponentId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationComponentStrategiesRequest model) {
            super(model);
            applicationComponentId(model.applicationComponentId);
        }

        public final String getApplicationComponentId() {
            return applicationComponentId;
        }

        public final void setApplicationComponentId(String applicationComponentId) {
            this.applicationComponentId = applicationComponentId;
        }

        @Override
        public final Builder applicationComponentId(String applicationComponentId) {
            this.applicationComponentId = applicationComponentId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApplicationComponentStrategiesRequest build() {
            return new GetApplicationComponentStrategiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
