/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServerDetailsResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<GetServerDetailsResponse.Builder, GetServerDetailsResponse> {
    private static final SdkField<List<AssociatedApplication>> ASSOCIATED_APPLICATIONS_FIELD = SdkField
            .<List<AssociatedApplication>> builder(MarshallingType.LIST)
            .memberName("associatedApplications")
            .getter(getter(GetServerDetailsResponse::associatedApplications))
            .setter(setter(Builder::associatedApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociatedApplication> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedApplication::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetServerDetailsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<ServerDetail> SERVER_DETAIL_FIELD = SdkField.<ServerDetail> builder(MarshallingType.SDK_POJO)
            .memberName("serverDetail").getter(getter(GetServerDetailsResponse::serverDetail))
            .setter(setter(Builder::serverDetail)).constructor(ServerDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_APPLICATIONS_FIELD,
            NEXT_TOKEN_FIELD, SERVER_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AssociatedApplication> associatedApplications;

    private final String nextToken;

    private final ServerDetail serverDetail;

    private GetServerDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.associatedApplications = builder.associatedApplications;
        this.nextToken = builder.nextToken;
        this.serverDetail = builder.serverDetail;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedApplications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociatedApplications() {
        return associatedApplications != null && !(associatedApplications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The associated application group the server belongs to, as defined in AWS Application Discovery Service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedApplications} method.
     * </p>
     * 
     * @return The associated application group the server belongs to, as defined in AWS Application Discovery Service.
     */
    public final List<AssociatedApplication> associatedApplications() {
        return associatedApplications;
    }

    /**
     * <p>
     * The token you use to retrieve the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token you use to retrieve the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Detailed information about the server.
     * </p>
     * 
     * @return Detailed information about the server.
     */
    public final ServerDetail serverDetail() {
        return serverDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedApplications() ? associatedApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(serverDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServerDetailsResponse)) {
            return false;
        }
        GetServerDetailsResponse other = (GetServerDetailsResponse) obj;
        return hasAssociatedApplications() == other.hasAssociatedApplications()
                && Objects.equals(associatedApplications(), other.associatedApplications())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(serverDetail(), other.serverDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServerDetailsResponse")
                .add("AssociatedApplications", hasAssociatedApplications() ? associatedApplications() : null)
                .add("NextToken", nextToken()).add("ServerDetail", serverDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatedApplications":
            return Optional.ofNullable(clazz.cast(associatedApplications()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "serverDetail":
            return Optional.ofNullable(clazz.cast(serverDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associatedApplications", ASSOCIATED_APPLICATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("serverDetail", SERVER_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServerDetailsResponse, T> g) {
        return obj -> g.apply((GetServerDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServerDetailsResponse> {
        /**
         * <p>
         * The associated application group the server belongs to, as defined in AWS Application Discovery Service.
         * </p>
         * 
         * @param associatedApplications
         *        The associated application group the server belongs to, as defined in AWS Application Discovery
         *        Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedApplications(Collection<AssociatedApplication> associatedApplications);

        /**
         * <p>
         * The associated application group the server belongs to, as defined in AWS Application Discovery Service.
         * </p>
         * 
         * @param associatedApplications
         *        The associated application group the server belongs to, as defined in AWS Application Discovery
         *        Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedApplications(AssociatedApplication... associatedApplications);

        /**
         * <p>
         * The associated application group the server belongs to, as defined in AWS Application Discovery Service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedApplication.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedApplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedApplication.Builder#build()} is
         * called immediately and its result is passed to {@link #associatedApplications(List<AssociatedApplication>)}.
         * 
         * @param associatedApplications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedApplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedApplications(java.util.Collection<AssociatedApplication>)
         */
        Builder associatedApplications(Consumer<AssociatedApplication.Builder>... associatedApplications);

        /**
         * <p>
         * The token you use to retrieve the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token you use to retrieve the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Detailed information about the server.
         * </p>
         * 
         * @param serverDetail
         *        Detailed information about the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverDetail(ServerDetail serverDetail);

        /**
         * <p>
         * Detailed information about the server.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerDetail.Builder} avoiding the need
         * to create one manually via {@link ServerDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #serverDetail(ServerDetail)}.
         * 
         * @param serverDetail
         *        a consumer that will call methods on {@link ServerDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverDetail(ServerDetail)
         */
        default Builder serverDetail(Consumer<ServerDetail.Builder> serverDetail) {
            return serverDetail(ServerDetail.builder().applyMutation(serverDetail).build());
        }
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private List<AssociatedApplication> associatedApplications = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private ServerDetail serverDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServerDetailsResponse model) {
            super(model);
            associatedApplications(model.associatedApplications);
            nextToken(model.nextToken);
            serverDetail(model.serverDetail);
        }

        public final List<AssociatedApplication.Builder> getAssociatedApplications() {
            List<AssociatedApplication.Builder> result = AssociatedApplicationsCopier.copyToBuilder(this.associatedApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedApplications(Collection<AssociatedApplication.BuilderImpl> associatedApplications) {
            this.associatedApplications = AssociatedApplicationsCopier.copyFromBuilder(associatedApplications);
        }

        @Override
        public final Builder associatedApplications(Collection<AssociatedApplication> associatedApplications) {
            this.associatedApplications = AssociatedApplicationsCopier.copy(associatedApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedApplications(AssociatedApplication... associatedApplications) {
            associatedApplications(Arrays.asList(associatedApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedApplications(Consumer<AssociatedApplication.Builder>... associatedApplications) {
            associatedApplications(Stream.of(associatedApplications)
                    .map(c -> AssociatedApplication.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ServerDetail.Builder getServerDetail() {
            return serverDetail != null ? serverDetail.toBuilder() : null;
        }

        public final void setServerDetail(ServerDetail.BuilderImpl serverDetail) {
            this.serverDetail = serverDetail != null ? serverDetail.build() : null;
        }

        @Override
        public final Builder serverDetail(ServerDetail serverDetail) {
            this.serverDetail = serverDetail;
            return this;
        }

        @Override
        public GetServerDetailsResponse build() {
            return new GetServerDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
