/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * IP address based configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IPAddressBasedRemoteInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<IPAddressBasedRemoteInfo.Builder, IPAddressBasedRemoteInfo> {
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(IPAddressBasedRemoteInfo::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<String> IP_ADDRESS_CONFIGURATION_TIME_STAMP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ipAddressConfigurationTimeStamp")
            .getter(getter(IPAddressBasedRemoteInfo::ipAddressConfigurationTimeStamp))
            .setter(setter(Builder::ipAddressConfigurationTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressConfigurationTimeStamp")
                    .build()).build();

    private static final SdkField<String> OS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("osType")
            .getter(getter(IPAddressBasedRemoteInfo::osTypeAsString)).setter(setter(Builder::osType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_TYPE_FIELD,
            IP_ADDRESS_CONFIGURATION_TIME_STAMP_FIELD, OS_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authType;

    private final String ipAddressConfigurationTimeStamp;

    private final String osType;

    private IPAddressBasedRemoteInfo(BuilderImpl builder) {
        this.authType = builder.authType;
        this.ipAddressConfigurationTimeStamp = builder.ipAddressConfigurationTimeStamp;
        this.osType = builder.osType;
    }

    /**
     * <p>
     * The type of authorization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authorization.
     * @see AuthType
     */
    public final AuthType authType() {
        return AuthType.fromValue(authType);
    }

    /**
     * <p>
     * The type of authorization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authorization.
     * @see AuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The time stamp of the configuration.
     * </p>
     * 
     * @return The time stamp of the configuration.
     */
    public final String ipAddressConfigurationTimeStamp() {
        return ipAddressConfigurationTimeStamp;
    }

    /**
     * <p>
     * The type of the operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osType} will
     * return {@link OSType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osTypeAsString}.
     * </p>
     * 
     * @return The type of the operating system.
     * @see OSType
     */
    public final OSType osType() {
        return OSType.fromValue(osType);
    }

    /**
     * <p>
     * The type of the operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osType} will
     * return {@link OSType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osTypeAsString}.
     * </p>
     * 
     * @return The type of the operating system.
     * @see OSType
     */
    public final String osTypeAsString() {
        return osType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressConfigurationTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(osTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPAddressBasedRemoteInfo)) {
            return false;
        }
        IPAddressBasedRemoteInfo other = (IPAddressBasedRemoteInfo) obj;
        return Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(ipAddressConfigurationTimeStamp(), other.ipAddressConfigurationTimeStamp())
                && Objects.equals(osTypeAsString(), other.osTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IPAddressBasedRemoteInfo").add("AuthType", authTypeAsString())
                .add("IpAddressConfigurationTimeStamp", ipAddressConfigurationTimeStamp()).add("OsType", osTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "ipAddressConfigurationTimeStamp":
            return Optional.ofNullable(clazz.cast(ipAddressConfigurationTimeStamp()));
        case "osType":
            return Optional.ofNullable(clazz.cast(osTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("ipAddressConfigurationTimeStamp", IP_ADDRESS_CONFIGURATION_TIME_STAMP_FIELD);
        map.put("osType", OS_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IPAddressBasedRemoteInfo, T> g) {
        return obj -> g.apply((IPAddressBasedRemoteInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IPAddressBasedRemoteInfo> {
        /**
         * <p>
         * The type of authorization.
         * </p>
         * 
         * @param authType
         *        The type of authorization.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The type of authorization.
         * </p>
         * 
         * @param authType
         *        The type of authorization.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(AuthType authType);

        /**
         * <p>
         * The time stamp of the configuration.
         * </p>
         * 
         * @param ipAddressConfigurationTimeStamp
         *        The time stamp of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressConfigurationTimeStamp(String ipAddressConfigurationTimeStamp);

        /**
         * <p>
         * The type of the operating system.
         * </p>
         * 
         * @param osType
         *        The type of the operating system.
         * @see OSType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OSType
         */
        Builder osType(String osType);

        /**
         * <p>
         * The type of the operating system.
         * </p>
         * 
         * @param osType
         *        The type of the operating system.
         * @see OSType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OSType
         */
        Builder osType(OSType osType);
    }

    static final class BuilderImpl implements Builder {
        private String authType;

        private String ipAddressConfigurationTimeStamp;

        private String osType;

        private BuilderImpl() {
        }

        private BuilderImpl(IPAddressBasedRemoteInfo model) {
            authType(model.authType);
            ipAddressConfigurationTimeStamp(model.ipAddressConfigurationTimeStamp);
            osType(model.osType);
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getIpAddressConfigurationTimeStamp() {
            return ipAddressConfigurationTimeStamp;
        }

        public final void setIpAddressConfigurationTimeStamp(String ipAddressConfigurationTimeStamp) {
            this.ipAddressConfigurationTimeStamp = ipAddressConfigurationTimeStamp;
        }

        @Override
        public final Builder ipAddressConfigurationTimeStamp(String ipAddressConfigurationTimeStamp) {
            this.ipAddressConfigurationTimeStamp = ipAddressConfigurationTimeStamp;
            return this;
        }

        public final String getOsType() {
            return osType;
        }

        public final void setOsType(String osType) {
            this.osType = osType;
        }

        @Override
        public final Builder osType(String osType) {
            this.osType = osType;
            return this;
        }

        @Override
        public final Builder osType(OSType osType) {
            this.osType(osType == null ? null : osType.toString());
            return this;
        }

        @Override
        public IPAddressBasedRemoteInfo build() {
            return new IPAddressBasedRemoteInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
