/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the import file tasks you request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportFileTaskInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportFileTaskInformation.Builder, ImportFileTaskInformation> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completionTime").getter(getter(ImportFileTaskInformation::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ImportFileTaskInformation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> IMPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importName").getter(getter(ImportFileTaskInformation::importName)).setter(setter(Builder::importName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importName").build()).build();

    private static final SdkField<String> INPUT_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputS3Bucket").getter(getter(ImportFileTaskInformation::inputS3Bucket))
            .setter(setter(Builder::inputS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputS3Bucket").build()).build();

    private static final SdkField<String> INPUT_S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputS3Key").getter(getter(ImportFileTaskInformation::inputS3Key)).setter(setter(Builder::inputS3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputS3Key").build()).build();

    private static final SdkField<Integer> NUMBER_OF_RECORDS_FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfRecordsFailed").getter(getter(ImportFileTaskInformation::numberOfRecordsFailed))
            .setter(setter(Builder::numberOfRecordsFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecordsFailed").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_RECORDS_SUCCESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfRecordsSuccess").getter(getter(ImportFileTaskInformation::numberOfRecordsSuccess))
            .setter(setter(Builder::numberOfRecordsSuccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecordsSuccess").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ImportFileTaskInformation::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ImportFileTaskInformation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REPORT_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReportS3Bucket").getter(getter(ImportFileTaskInformation::statusReportS3Bucket))
            .setter(setter(Builder::statusReportS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReportS3Bucket").build())
            .build();

    private static final SdkField<String> STATUS_REPORT_S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReportS3Key").getter(getter(ImportFileTaskInformation::statusReportS3Key))
            .setter(setter(Builder::statusReportS3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReportS3Key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD,
            ID_FIELD, IMPORT_NAME_FIELD, INPUT_S3_BUCKET_FIELD, INPUT_S3_KEY_FIELD, NUMBER_OF_RECORDS_FAILED_FIELD,
            NUMBER_OF_RECORDS_SUCCESS_FIELD, START_TIME_FIELD, STATUS_FIELD, STATUS_REPORT_S3_BUCKET_FIELD,
            STATUS_REPORT_S3_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant completionTime;

    private final String id;

    private final String importName;

    private final String inputS3Bucket;

    private final String inputS3Key;

    private final Integer numberOfRecordsFailed;

    private final Integer numberOfRecordsSuccess;

    private final Instant startTime;

    private final String status;

    private final String statusReportS3Bucket;

    private final String statusReportS3Key;

    private ImportFileTaskInformation(BuilderImpl builder) {
        this.completionTime = builder.completionTime;
        this.id = builder.id;
        this.importName = builder.importName;
        this.inputS3Bucket = builder.inputS3Bucket;
        this.inputS3Key = builder.inputS3Key;
        this.numberOfRecordsFailed = builder.numberOfRecordsFailed;
        this.numberOfRecordsSuccess = builder.numberOfRecordsSuccess;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.statusReportS3Bucket = builder.statusReportS3Bucket;
        this.statusReportS3Key = builder.statusReportS3Key;
    }

    /**
     * <p>
     * The time that the import task completes.
     * </p>
     * 
     * @return The time that the import task completes.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The ID of the import file task.
     * </p>
     * 
     * @return The ID of the import file task.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the import task given in <code>StartImportFileTask</code>.
     * </p>
     * 
     * @return The name of the import task given in <code>StartImportFileTask</code>.
     */
    public final String importName() {
        return importName;
    }

    /**
     * <p>
     * The S3 bucket where the import file is located.
     * </p>
     * 
     * @return The S3 bucket where the import file is located.
     */
    public final String inputS3Bucket() {
        return inputS3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 key name of the import file.
     * </p>
     * 
     * @return The Amazon S3 key name of the import file.
     */
    public final String inputS3Key() {
        return inputS3Key;
    }

    /**
     * <p>
     * The number of records that failed to be imported.
     * </p>
     * 
     * @return The number of records that failed to be imported.
     */
    public final Integer numberOfRecordsFailed() {
        return numberOfRecordsFailed;
    }

    /**
     * <p>
     * The number of records successfully imported.
     * </p>
     * 
     * @return The number of records successfully imported.
     */
    public final Integer numberOfRecordsSuccess() {
        return numberOfRecordsSuccess;
    }

    /**
     * <p>
     * Start time of the import task.
     * </p>
     * 
     * @return Start time of the import task.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Status of import file task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportFileTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of import file task.
     * @see ImportFileTaskStatus
     */
    public final ImportFileTaskStatus status() {
        return ImportFileTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of import file task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportFileTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of import file task.
     * @see ImportFileTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The S3 bucket name for status report of import task.
     * </p>
     * 
     * @return The S3 bucket name for status report of import task.
     */
    public final String statusReportS3Bucket() {
        return statusReportS3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 key name for status report of import task. The report contains details about whether each record
     * imported successfully or why it did not.
     * </p>
     * 
     * @return The Amazon S3 key name for status report of import task. The report contains details about whether each
     *         record imported successfully or why it did not.
     */
    public final String statusReportS3Key() {
        return statusReportS3Key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(importName());
        hashCode = 31 * hashCode + Objects.hashCode(inputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(inputS3Key());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRecordsFailed());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRecordsSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReportS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(statusReportS3Key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportFileTaskInformation)) {
            return false;
        }
        ImportFileTaskInformation other = (ImportFileTaskInformation) obj;
        return Objects.equals(completionTime(), other.completionTime()) && Objects.equals(id(), other.id())
                && Objects.equals(importName(), other.importName()) && Objects.equals(inputS3Bucket(), other.inputS3Bucket())
                && Objects.equals(inputS3Key(), other.inputS3Key())
                && Objects.equals(numberOfRecordsFailed(), other.numberOfRecordsFailed())
                && Objects.equals(numberOfRecordsSuccess(), other.numberOfRecordsSuccess())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReportS3Bucket(), other.statusReportS3Bucket())
                && Objects.equals(statusReportS3Key(), other.statusReportS3Key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportFileTaskInformation").add("CompletionTime", completionTime()).add("Id", id())
                .add("ImportName", importName()).add("InputS3Bucket", inputS3Bucket()).add("InputS3Key", inputS3Key())
                .add("NumberOfRecordsFailed", numberOfRecordsFailed()).add("NumberOfRecordsSuccess", numberOfRecordsSuccess())
                .add("StartTime", startTime()).add("Status", statusAsString())
                .add("StatusReportS3Bucket", statusReportS3Bucket()).add("StatusReportS3Key", statusReportS3Key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "completionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "importName":
            return Optional.ofNullable(clazz.cast(importName()));
        case "inputS3Bucket":
            return Optional.ofNullable(clazz.cast(inputS3Bucket()));
        case "inputS3Key":
            return Optional.ofNullable(clazz.cast(inputS3Key()));
        case "numberOfRecordsFailed":
            return Optional.ofNullable(clazz.cast(numberOfRecordsFailed()));
        case "numberOfRecordsSuccess":
            return Optional.ofNullable(clazz.cast(numberOfRecordsSuccess()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReportS3Bucket":
            return Optional.ofNullable(clazz.cast(statusReportS3Bucket()));
        case "statusReportS3Key":
            return Optional.ofNullable(clazz.cast(statusReportS3Key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("completionTime", COMPLETION_TIME_FIELD);
        map.put("id", ID_FIELD);
        map.put("importName", IMPORT_NAME_FIELD);
        map.put("inputS3Bucket", INPUT_S3_BUCKET_FIELD);
        map.put("inputS3Key", INPUT_S3_KEY_FIELD);
        map.put("numberOfRecordsFailed", NUMBER_OF_RECORDS_FAILED_FIELD);
        map.put("numberOfRecordsSuccess", NUMBER_OF_RECORDS_SUCCESS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReportS3Bucket", STATUS_REPORT_S3_BUCKET_FIELD);
        map.put("statusReportS3Key", STATUS_REPORT_S3_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportFileTaskInformation, T> g) {
        return obj -> g.apply((ImportFileTaskInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportFileTaskInformation> {
        /**
         * <p>
         * The time that the import task completes.
         * </p>
         * 
         * @param completionTime
         *        The time that the import task completes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The ID of the import file task.
         * </p>
         * 
         * @param id
         *        The ID of the import file task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the import task given in <code>StartImportFileTask</code>.
         * </p>
         * 
         * @param importName
         *        The name of the import task given in <code>StartImportFileTask</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importName(String importName);

        /**
         * <p>
         * The S3 bucket where the import file is located.
         * </p>
         * 
         * @param inputS3Bucket
         *        The S3 bucket where the import file is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputS3Bucket(String inputS3Bucket);

        /**
         * <p>
         * The Amazon S3 key name of the import file.
         * </p>
         * 
         * @param inputS3Key
         *        The Amazon S3 key name of the import file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputS3Key(String inputS3Key);

        /**
         * <p>
         * The number of records that failed to be imported.
         * </p>
         * 
         * @param numberOfRecordsFailed
         *        The number of records that failed to be imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRecordsFailed(Integer numberOfRecordsFailed);

        /**
         * <p>
         * The number of records successfully imported.
         * </p>
         * 
         * @param numberOfRecordsSuccess
         *        The number of records successfully imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRecordsSuccess(Integer numberOfRecordsSuccess);

        /**
         * <p>
         * Start time of the import task.
         * </p>
         * 
         * @param startTime
         *        Start time of the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Status of import file task.
         * </p>
         * 
         * @param status
         *        Status of import file task.
         * @see ImportFileTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportFileTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of import file task.
         * </p>
         * 
         * @param status
         *        Status of import file task.
         * @see ImportFileTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportFileTaskStatus
         */
        Builder status(ImportFileTaskStatus status);

        /**
         * <p>
         * The S3 bucket name for status report of import task.
         * </p>
         * 
         * @param statusReportS3Bucket
         *        The S3 bucket name for status report of import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReportS3Bucket(String statusReportS3Bucket);

        /**
         * <p>
         * The Amazon S3 key name for status report of import task. The report contains details about whether each
         * record imported successfully or why it did not.
         * </p>
         * 
         * @param statusReportS3Key
         *        The Amazon S3 key name for status report of import task. The report contains details about whether
         *        each record imported successfully or why it did not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReportS3Key(String statusReportS3Key);
    }

    static final class BuilderImpl implements Builder {
        private Instant completionTime;

        private String id;

        private String importName;

        private String inputS3Bucket;

        private String inputS3Key;

        private Integer numberOfRecordsFailed;

        private Integer numberOfRecordsSuccess;

        private Instant startTime;

        private String status;

        private String statusReportS3Bucket;

        private String statusReportS3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportFileTaskInformation model) {
            completionTime(model.completionTime);
            id(model.id);
            importName(model.importName);
            inputS3Bucket(model.inputS3Bucket);
            inputS3Key(model.inputS3Key);
            numberOfRecordsFailed(model.numberOfRecordsFailed);
            numberOfRecordsSuccess(model.numberOfRecordsSuccess);
            startTime(model.startTime);
            status(model.status);
            statusReportS3Bucket(model.statusReportS3Bucket);
            statusReportS3Key(model.statusReportS3Key);
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getImportName() {
            return importName;
        }

        public final void setImportName(String importName) {
            this.importName = importName;
        }

        @Override
        public final Builder importName(String importName) {
            this.importName = importName;
            return this;
        }

        public final String getInputS3Bucket() {
            return inputS3Bucket;
        }

        public final void setInputS3Bucket(String inputS3Bucket) {
            this.inputS3Bucket = inputS3Bucket;
        }

        @Override
        public final Builder inputS3Bucket(String inputS3Bucket) {
            this.inputS3Bucket = inputS3Bucket;
            return this;
        }

        public final String getInputS3Key() {
            return inputS3Key;
        }

        public final void setInputS3Key(String inputS3Key) {
            this.inputS3Key = inputS3Key;
        }

        @Override
        public final Builder inputS3Key(String inputS3Key) {
            this.inputS3Key = inputS3Key;
            return this;
        }

        public final Integer getNumberOfRecordsFailed() {
            return numberOfRecordsFailed;
        }

        public final void setNumberOfRecordsFailed(Integer numberOfRecordsFailed) {
            this.numberOfRecordsFailed = numberOfRecordsFailed;
        }

        @Override
        public final Builder numberOfRecordsFailed(Integer numberOfRecordsFailed) {
            this.numberOfRecordsFailed = numberOfRecordsFailed;
            return this;
        }

        public final Integer getNumberOfRecordsSuccess() {
            return numberOfRecordsSuccess;
        }

        public final void setNumberOfRecordsSuccess(Integer numberOfRecordsSuccess) {
            this.numberOfRecordsSuccess = numberOfRecordsSuccess;
        }

        @Override
        public final Builder numberOfRecordsSuccess(Integer numberOfRecordsSuccess) {
            this.numberOfRecordsSuccess = numberOfRecordsSuccess;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportFileTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReportS3Bucket() {
            return statusReportS3Bucket;
        }

        public final void setStatusReportS3Bucket(String statusReportS3Bucket) {
            this.statusReportS3Bucket = statusReportS3Bucket;
        }

        @Override
        public final Builder statusReportS3Bucket(String statusReportS3Bucket) {
            this.statusReportS3Bucket = statusReportS3Bucket;
            return this;
        }

        public final String getStatusReportS3Key() {
            return statusReportS3Key;
        }

        public final void setStatusReportS3Key(String statusReportS3Key) {
            this.statusReportS3Key = statusReportS3Key;
        }

        @Override
        public final Builder statusReportS3Key(String statusReportS3Key) {
            this.statusReportS3Key = statusReportS3Key;
            return this;
        }

        @Override
        public ImportFileTaskInformation build() {
            return new ImportFileTaskInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
