/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents output for ListAnalyzableServers operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnalyzableServersResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<ListAnalyzableServersResponse.Builder, ListAnalyzableServersResponse> {
    private static final SdkField<List<AnalyzableServerSummary>> ANALYZABLE_SERVERS_FIELD = SdkField
            .<List<AnalyzableServerSummary>> builder(MarshallingType.LIST)
            .memberName("analyzableServers")
            .getter(getter(ListAnalyzableServersResponse::analyzableServers))
            .setter(setter(Builder::analyzableServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzableServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyzableServerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyzableServerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAnalyzableServersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZABLE_SERVERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AnalyzableServerSummary> analyzableServers;

    private final String nextToken;

    private ListAnalyzableServersResponse(BuilderImpl builder) {
        super(builder);
        this.analyzableServers = builder.analyzableServers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalyzableServers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalyzableServers() {
        return analyzableServers != null && !(analyzableServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of analyzable servers with summary information about each server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalyzableServers} method.
     * </p>
     * 
     * @return The list of analyzable servers with summary information about each server.
     */
    public final List<AnalyzableServerSummary> analyzableServers() {
        return analyzableServers;
    }

    /**
     * <p>
     * The token you use to retrieve the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token you use to retrieve the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalyzableServers() ? analyzableServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalyzableServersResponse)) {
            return false;
        }
        ListAnalyzableServersResponse other = (ListAnalyzableServersResponse) obj;
        return hasAnalyzableServers() == other.hasAnalyzableServers()
                && Objects.equals(analyzableServers(), other.analyzableServers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnalyzableServersResponse")
                .add("AnalyzableServers", hasAnalyzableServers() ? analyzableServers() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzableServers":
            return Optional.ofNullable(clazz.cast(analyzableServers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analyzableServers", ANALYZABLE_SERVERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnalyzableServersResponse, T> g) {
        return obj -> g.apply((ListAnalyzableServersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnalyzableServersResponse> {
        /**
         * <p>
         * The list of analyzable servers with summary information about each server.
         * </p>
         * 
         * @param analyzableServers
         *        The list of analyzable servers with summary information about each server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzableServers(Collection<AnalyzableServerSummary> analyzableServers);

        /**
         * <p>
         * The list of analyzable servers with summary information about each server.
         * </p>
         * 
         * @param analyzableServers
         *        The list of analyzable servers with summary information about each server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzableServers(AnalyzableServerSummary... analyzableServers);

        /**
         * <p>
         * The list of analyzable servers with summary information about each server.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AnalyzableServerSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AnalyzableServerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AnalyzableServerSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #analyzableServers(List<AnalyzableServerSummary>)}.
         * 
         * @param analyzableServers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.AnalyzableServerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyzableServers(java.util.Collection<AnalyzableServerSummary>)
         */
        Builder analyzableServers(Consumer<AnalyzableServerSummary.Builder>... analyzableServers);

        /**
         * <p>
         * The token you use to retrieve the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token you use to retrieve the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private List<AnalyzableServerSummary> analyzableServers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnalyzableServersResponse model) {
            super(model);
            analyzableServers(model.analyzableServers);
            nextToken(model.nextToken);
        }

        public final List<AnalyzableServerSummary.Builder> getAnalyzableServers() {
            List<AnalyzableServerSummary.Builder> result = AnalyzableServerSummaryListCopier
                    .copyToBuilder(this.analyzableServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalyzableServers(Collection<AnalyzableServerSummary.BuilderImpl> analyzableServers) {
            this.analyzableServers = AnalyzableServerSummaryListCopier.copyFromBuilder(analyzableServers);
        }

        @Override
        public final Builder analyzableServers(Collection<AnalyzableServerSummary> analyzableServers) {
            this.analyzableServers = AnalyzableServerSummaryListCopier.copy(analyzableServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzableServers(AnalyzableServerSummary... analyzableServers) {
            analyzableServers(Arrays.asList(analyzableServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzableServers(Consumer<AnalyzableServerSummary.Builder>... analyzableServers) {
            analyzableServers(Stream.of(analyzableServers).map(c -> AnalyzableServerSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnalyzableServersResponse build() {
            return new ListAnalyzableServersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
