/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationComponentsResponse extends MigrationHubStrategyResponse implements
        ToCopyableBuilder<ListApplicationComponentsResponse.Builder, ListApplicationComponentsResponse> {
    private static final SdkField<List<ApplicationComponentDetail>> APPLICATION_COMPONENT_INFOS_FIELD = SdkField
            .<List<ApplicationComponentDetail>> builder(MarshallingType.LIST)
            .memberName("applicationComponentInfos")
            .getter(getter(ListApplicationComponentsResponse::applicationComponentInfos))
            .setter(setter(Builder::applicationComponentInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationComponentInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationComponentDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationComponentDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListApplicationComponentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_COMPONENT_INFOS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ApplicationComponentDetail> applicationComponentInfos;

    private final String nextToken;

    private ListApplicationComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationComponentInfos = builder.applicationComponentInfos;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationComponentInfos property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApplicationComponentInfos() {
        return applicationComponentInfos != null && !(applicationComponentInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of application components with detailed information about each component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationComponentInfos} method.
     * </p>
     * 
     * @return The list of application components with detailed information about each component.
     */
    public final List<ApplicationComponentDetail> applicationComponentInfos() {
        return applicationComponentInfos;
    }

    /**
     * <p>
     * The token you use to retrieve the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token you use to retrieve the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationComponentInfos() ? applicationComponentInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationComponentsResponse)) {
            return false;
        }
        ListApplicationComponentsResponse other = (ListApplicationComponentsResponse) obj;
        return hasApplicationComponentInfos() == other.hasApplicationComponentInfos()
                && Objects.equals(applicationComponentInfos(), other.applicationComponentInfos())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationComponentsResponse")
                .add("ApplicationComponentInfos", hasApplicationComponentInfos() ? applicationComponentInfos() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationComponentInfos":
            return Optional.ofNullable(clazz.cast(applicationComponentInfos()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationComponentInfos", APPLICATION_COMPONENT_INFOS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationComponentsResponse, T> g) {
        return obj -> g.apply((ListApplicationComponentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationComponentsResponse> {
        /**
         * <p>
         * The list of application components with detailed information about each component.
         * </p>
         * 
         * @param applicationComponentInfos
         *        The list of application components with detailed information about each component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponentInfos(Collection<ApplicationComponentDetail> applicationComponentInfos);

        /**
         * <p>
         * The list of application components with detailed information about each component.
         * </p>
         * 
         * @param applicationComponentInfos
         *        The list of application components with detailed information about each component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponentInfos(ApplicationComponentDetail... applicationComponentInfos);

        /**
         * <p>
         * The list of application components with detailed information about each component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentDetail.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentDetail.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #applicationComponentInfos(List<ApplicationComponentDetail>)}.
         * 
         * @param applicationComponentInfos
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationComponentInfos(java.util.Collection<ApplicationComponentDetail>)
         */
        Builder applicationComponentInfos(Consumer<ApplicationComponentDetail.Builder>... applicationComponentInfos);

        /**
         * <p>
         * The token you use to retrieve the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token you use to retrieve the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MigrationHubStrategyResponse.BuilderImpl implements Builder {
        private List<ApplicationComponentDetail> applicationComponentInfos = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationComponentsResponse model) {
            super(model);
            applicationComponentInfos(model.applicationComponentInfos);
            nextToken(model.nextToken);
        }

        public final List<ApplicationComponentDetail.Builder> getApplicationComponentInfos() {
            List<ApplicationComponentDetail.Builder> result = ApplicationComponentDetailsCopier
                    .copyToBuilder(this.applicationComponentInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationComponentInfos(
                Collection<ApplicationComponentDetail.BuilderImpl> applicationComponentInfos) {
            this.applicationComponentInfos = ApplicationComponentDetailsCopier.copyFromBuilder(applicationComponentInfos);
        }

        @Override
        public final Builder applicationComponentInfos(Collection<ApplicationComponentDetail> applicationComponentInfos) {
            this.applicationComponentInfos = ApplicationComponentDetailsCopier.copy(applicationComponentInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationComponentInfos(ApplicationComponentDetail... applicationComponentInfos) {
            applicationComponentInfos(Arrays.asList(applicationComponentInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationComponentInfos(Consumer<ApplicationComponentDetail.Builder>... applicationComponentInfos) {
            applicationComponentInfos(Stream.of(applicationComponentInfos)
                    .map(c -> ApplicationComponentDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationComponentsResponse build() {
            return new ListApplicationComponentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
