/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the server's network for which the assessment was run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInfo implements SdkPojo, Serializable, ToCopyableBuilder<NetworkInfo.Builder, NetworkInfo> {
    private static final SdkField<String> INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interfaceName").getter(getter(NetworkInfo::interfaceName)).setter(setter(Builder::interfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceName").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddress").getter(getter(NetworkInfo::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("macAddress").getter(getter(NetworkInfo::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()).build();

    private static final SdkField<String> NET_MASK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("netMask").getter(getter(NetworkInfo::netMask)).setter(setter(Builder::netMask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("netMask").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERFACE_NAME_FIELD,
            IP_ADDRESS_FIELD, MAC_ADDRESS_FIELD, NET_MASK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String interfaceName;

    private final String ipAddress;

    private final String macAddress;

    private final String netMask;

    private NetworkInfo(BuilderImpl builder) {
        this.interfaceName = builder.interfaceName;
        this.ipAddress = builder.ipAddress;
        this.macAddress = builder.macAddress;
        this.netMask = builder.netMask;
    }

    /**
     * <p>
     * Information about the name of the interface of the server for which the assessment was run.
     * </p>
     * 
     * @return Information about the name of the interface of the server for which the assessment was run.
     */
    public final String interfaceName() {
        return interfaceName;
    }

    /**
     * <p>
     * Information about the IP address of the server for which the assessment was run.
     * </p>
     * 
     * @return Information about the IP address of the server for which the assessment was run.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * Information about the MAC address of the server for which the assessment was run.
     * </p>
     * 
     * @return Information about the MAC address of the server for which the assessment was run.
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * Information about the subnet mask of the server for which the assessment was run.
     * </p>
     * 
     * @return Information about the subnet mask of the server for which the assessment was run.
     */
    public final String netMask() {
        return netMask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(netMask());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInfo)) {
            return false;
        }
        NetworkInfo other = (NetworkInfo) obj;
        return Objects.equals(interfaceName(), other.interfaceName()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(macAddress(), other.macAddress()) && Objects.equals(netMask(), other.netMask());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInfo").add("InterfaceName", interfaceName()).add("IpAddress", ipAddress())
                .add("MacAddress", macAddress()).add("NetMask", netMask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "interfaceName":
            return Optional.ofNullable(clazz.cast(interfaceName()));
        case "ipAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "macAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "netMask":
            return Optional.ofNullable(clazz.cast(netMask()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("interfaceName", INTERFACE_NAME_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("macAddress", MAC_ADDRESS_FIELD);
        map.put("netMask", NET_MASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkInfo, T> g) {
        return obj -> g.apply((NetworkInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInfo> {
        /**
         * <p>
         * Information about the name of the interface of the server for which the assessment was run.
         * </p>
         * 
         * @param interfaceName
         *        Information about the name of the interface of the server for which the assessment was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceName(String interfaceName);

        /**
         * <p>
         * Information about the IP address of the server for which the assessment was run.
         * </p>
         * 
         * @param ipAddress
         *        Information about the IP address of the server for which the assessment was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * Information about the MAC address of the server for which the assessment was run.
         * </p>
         * 
         * @param macAddress
         *        Information about the MAC address of the server for which the assessment was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * Information about the subnet mask of the server for which the assessment was run.
         * </p>
         * 
         * @param netMask
         *        Information about the subnet mask of the server for which the assessment was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netMask(String netMask);
    }

    static final class BuilderImpl implements Builder {
        private String interfaceName;

        private String ipAddress;

        private String macAddress;

        private String netMask;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInfo model) {
            interfaceName(model.interfaceName);
            ipAddress(model.ipAddress);
            macAddress(model.macAddress);
            netMask(model.netMask);
        }

        public final String getInterfaceName() {
            return interfaceName;
        }

        public final void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        @Override
        public final Builder interfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getNetMask() {
            return netMask;
        }

        public final void setNetMask(String netMask) {
            this.netMask = netMask;
        }

        @Override
        public final Builder netMask(String netMask) {
            this.netMask = netMask;
            return this;
        }

        @Override
        public NetworkInfo build() {
            return new NetworkInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
