/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Rank of business goals based on priority.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrioritizeBusinessGoals implements SdkPojo, Serializable,
        ToCopyableBuilder<PrioritizeBusinessGoals.Builder, PrioritizeBusinessGoals> {
    private static final SdkField<BusinessGoals> BUSINESS_GOALS_FIELD = SdkField
            .<BusinessGoals> builder(MarshallingType.SDK_POJO).memberName("businessGoals")
            .getter(getter(PrioritizeBusinessGoals::businessGoals)).setter(setter(Builder::businessGoals))
            .constructor(BusinessGoals::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessGoals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_GOALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BusinessGoals businessGoals;

    private PrioritizeBusinessGoals(BuilderImpl builder) {
        this.businessGoals = builder.businessGoals;
    }

    /**
     * <p>
     * Rank of business goals based on priority.
     * </p>
     * 
     * @return Rank of business goals based on priority.
     */
    public final BusinessGoals businessGoals() {
        return businessGoals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(businessGoals());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrioritizeBusinessGoals)) {
            return false;
        }
        PrioritizeBusinessGoals other = (PrioritizeBusinessGoals) obj;
        return Objects.equals(businessGoals(), other.businessGoals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrioritizeBusinessGoals").add("BusinessGoals", businessGoals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "businessGoals":
            return Optional.ofNullable(clazz.cast(businessGoals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("businessGoals", BUSINESS_GOALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrioritizeBusinessGoals, T> g) {
        return obj -> g.apply((PrioritizeBusinessGoals) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrioritizeBusinessGoals> {
        /**
         * <p>
         * Rank of business goals based on priority.
         * </p>
         * 
         * @param businessGoals
         *        Rank of business goals based on priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessGoals(BusinessGoals businessGoals);

        /**
         * <p>
         * Rank of business goals based on priority.
         * </p>
         * This is a convenience method that creates an instance of the {@link BusinessGoals.Builder} avoiding the need
         * to create one manually via {@link BusinessGoals#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BusinessGoals.Builder#build()} is called immediately and its
         * result is passed to {@link #businessGoals(BusinessGoals)}.
         * 
         * @param businessGoals
         *        a consumer that will call methods on {@link BusinessGoals.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #businessGoals(BusinessGoals)
         */
        default Builder businessGoals(Consumer<BusinessGoals.Builder> businessGoals) {
            return businessGoals(BusinessGoals.builder().applyMutation(businessGoals).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BusinessGoals businessGoals;

        private BuilderImpl() {
        }

        private BuilderImpl(PrioritizeBusinessGoals model) {
            businessGoals(model.businessGoals);
        }

        public final BusinessGoals.Builder getBusinessGoals() {
            return businessGoals != null ? businessGoals.toBuilder() : null;
        }

        public final void setBusinessGoals(BusinessGoals.BuilderImpl businessGoals) {
            this.businessGoals = businessGoals != null ? businessGoals.build() : null;
        }

        @Override
        public final Builder businessGoals(BusinessGoals businessGoals) {
            this.businessGoals = businessGoals;
            return this;
        }

        @Override
        public PrioritizeBusinessGoals build() {
            return new PrioritizeBusinessGoals(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
