/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPortfolioPreferencesRequest extends MigrationHubStrategyRequest implements
        ToCopyableBuilder<PutPortfolioPreferencesRequest.Builder, PutPortfolioPreferencesRequest> {
    private static final SdkField<String> APPLICATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationMode").getter(getter(PutPortfolioPreferencesRequest::applicationModeAsString))
            .setter(setter(Builder::applicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationMode").build()).build();

    private static final SdkField<ApplicationPreferences> APPLICATION_PREFERENCES_FIELD = SdkField
            .<ApplicationPreferences> builder(MarshallingType.SDK_POJO).memberName("applicationPreferences")
            .getter(getter(PutPortfolioPreferencesRequest::applicationPreferences))
            .setter(setter(Builder::applicationPreferences)).constructor(ApplicationPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationPreferences").build())
            .build();

    private static final SdkField<DatabasePreferences> DATABASE_PREFERENCES_FIELD = SdkField
            .<DatabasePreferences> builder(MarshallingType.SDK_POJO).memberName("databasePreferences")
            .getter(getter(PutPortfolioPreferencesRequest::databasePreferences)).setter(setter(Builder::databasePreferences))
            .constructor(DatabasePreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databasePreferences").build())
            .build();

    private static final SdkField<PrioritizeBusinessGoals> PRIORITIZE_BUSINESS_GOALS_FIELD = SdkField
            .<PrioritizeBusinessGoals> builder(MarshallingType.SDK_POJO).memberName("prioritizeBusinessGoals")
            .getter(getter(PutPortfolioPreferencesRequest::prioritizeBusinessGoals))
            .setter(setter(Builder::prioritizeBusinessGoals)).constructor(PrioritizeBusinessGoals::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prioritizeBusinessGoals").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_MODE_FIELD,
            APPLICATION_PREFERENCES_FIELD, DATABASE_PREFERENCES_FIELD, PRIORITIZE_BUSINESS_GOALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationMode;

    private final ApplicationPreferences applicationPreferences;

    private final DatabasePreferences databasePreferences;

    private final PrioritizeBusinessGoals prioritizeBusinessGoals;

    private PutPortfolioPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationMode = builder.applicationMode;
        this.applicationPreferences = builder.applicationPreferences;
        this.databasePreferences = builder.databasePreferences;
        this.prioritizeBusinessGoals = builder.prioritizeBusinessGoals;
    }

    /**
     * <p>
     * The classification for application component types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationMode}
     * will return {@link ApplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationModeAsString}.
     * </p>
     * 
     * @return The classification for application component types.
     * @see ApplicationMode
     */
    public final ApplicationMode applicationMode() {
        return ApplicationMode.fromValue(applicationMode);
    }

    /**
     * <p>
     * The classification for application component types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationMode}
     * will return {@link ApplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationModeAsString}.
     * </p>
     * 
     * @return The classification for application component types.
     * @see ApplicationMode
     */
    public final String applicationModeAsString() {
        return applicationMode;
    }

    /**
     * <p>
     * The transformation preferences for non-database applications.
     * </p>
     * 
     * @return The transformation preferences for non-database applications.
     */
    public final ApplicationPreferences applicationPreferences() {
        return applicationPreferences;
    }

    /**
     * <p>
     * The transformation preferences for database applications.
     * </p>
     * 
     * @return The transformation preferences for database applications.
     */
    public final DatabasePreferences databasePreferences() {
        return databasePreferences;
    }

    /**
     * <p>
     * The rank of the business goals based on priority.
     * </p>
     * 
     * @return The rank of the business goals based on priority.
     */
    public final PrioritizeBusinessGoals prioritizeBusinessGoals() {
        return prioritizeBusinessGoals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(databasePreferences());
        hashCode = 31 * hashCode + Objects.hashCode(prioritizeBusinessGoals());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPortfolioPreferencesRequest)) {
            return false;
        }
        PutPortfolioPreferencesRequest other = (PutPortfolioPreferencesRequest) obj;
        return Objects.equals(applicationModeAsString(), other.applicationModeAsString())
                && Objects.equals(applicationPreferences(), other.applicationPreferences())
                && Objects.equals(databasePreferences(), other.databasePreferences())
                && Objects.equals(prioritizeBusinessGoals(), other.prioritizeBusinessGoals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutPortfolioPreferencesRequest").add("ApplicationMode", applicationModeAsString())
                .add("ApplicationPreferences", applicationPreferences()).add("DatabasePreferences", databasePreferences())
                .add("PrioritizeBusinessGoals", prioritizeBusinessGoals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationMode":
            return Optional.ofNullable(clazz.cast(applicationModeAsString()));
        case "applicationPreferences":
            return Optional.ofNullable(clazz.cast(applicationPreferences()));
        case "databasePreferences":
            return Optional.ofNullable(clazz.cast(databasePreferences()));
        case "prioritizeBusinessGoals":
            return Optional.ofNullable(clazz.cast(prioritizeBusinessGoals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationMode", APPLICATION_MODE_FIELD);
        map.put("applicationPreferences", APPLICATION_PREFERENCES_FIELD);
        map.put("databasePreferences", DATABASE_PREFERENCES_FIELD);
        map.put("prioritizeBusinessGoals", PRIORITIZE_BUSINESS_GOALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutPortfolioPreferencesRequest, T> g) {
        return obj -> g.apply((PutPortfolioPreferencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutPortfolioPreferencesRequest> {
        /**
         * <p>
         * The classification for application component types.
         * </p>
         * 
         * @param applicationMode
         *        The classification for application component types.
         * @see ApplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationMode
         */
        Builder applicationMode(String applicationMode);

        /**
         * <p>
         * The classification for application component types.
         * </p>
         * 
         * @param applicationMode
         *        The classification for application component types.
         * @see ApplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationMode
         */
        Builder applicationMode(ApplicationMode applicationMode);

        /**
         * <p>
         * The transformation preferences for non-database applications.
         * </p>
         * 
         * @param applicationPreferences
         *        The transformation preferences for non-database applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationPreferences(ApplicationPreferences applicationPreferences);

        /**
         * <p>
         * The transformation preferences for non-database applications.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationPreferences.Builder} avoiding
         * the need to create one manually via {@link ApplicationPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationPreferences.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationPreferences(ApplicationPreferences)}.
         * 
         * @param applicationPreferences
         *        a consumer that will call methods on {@link ApplicationPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationPreferences(ApplicationPreferences)
         */
        default Builder applicationPreferences(Consumer<ApplicationPreferences.Builder> applicationPreferences) {
            return applicationPreferences(ApplicationPreferences.builder().applyMutation(applicationPreferences).build());
        }

        /**
         * <p>
         * The transformation preferences for database applications.
         * </p>
         * 
         * @param databasePreferences
         *        The transformation preferences for database applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databasePreferences(DatabasePreferences databasePreferences);

        /**
         * <p>
         * The transformation preferences for database applications.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatabasePreferences.Builder} avoiding the
         * need to create one manually via {@link DatabasePreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabasePreferences.Builder#build()} is called immediately and
         * its result is passed to {@link #databasePreferences(DatabasePreferences)}.
         * 
         * @param databasePreferences
         *        a consumer that will call methods on {@link DatabasePreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databasePreferences(DatabasePreferences)
         */
        default Builder databasePreferences(Consumer<DatabasePreferences.Builder> databasePreferences) {
            return databasePreferences(DatabasePreferences.builder().applyMutation(databasePreferences).build());
        }

        /**
         * <p>
         * The rank of the business goals based on priority.
         * </p>
         * 
         * @param prioritizeBusinessGoals
         *        The rank of the business goals based on priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prioritizeBusinessGoals(PrioritizeBusinessGoals prioritizeBusinessGoals);

        /**
         * <p>
         * The rank of the business goals based on priority.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrioritizeBusinessGoals.Builder} avoiding
         * the need to create one manually via {@link PrioritizeBusinessGoals#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrioritizeBusinessGoals.Builder#build()} is called immediately
         * and its result is passed to {@link #prioritizeBusinessGoals(PrioritizeBusinessGoals)}.
         * 
         * @param prioritizeBusinessGoals
         *        a consumer that will call methods on {@link PrioritizeBusinessGoals.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prioritizeBusinessGoals(PrioritizeBusinessGoals)
         */
        default Builder prioritizeBusinessGoals(Consumer<PrioritizeBusinessGoals.Builder> prioritizeBusinessGoals) {
            return prioritizeBusinessGoals(PrioritizeBusinessGoals.builder().applyMutation(prioritizeBusinessGoals).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubStrategyRequest.BuilderImpl implements Builder {
        private String applicationMode;

        private ApplicationPreferences applicationPreferences;

        private DatabasePreferences databasePreferences;

        private PrioritizeBusinessGoals prioritizeBusinessGoals;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPortfolioPreferencesRequest model) {
            super(model);
            applicationMode(model.applicationMode);
            applicationPreferences(model.applicationPreferences);
            databasePreferences(model.databasePreferences);
            prioritizeBusinessGoals(model.prioritizeBusinessGoals);
        }

        public final String getApplicationMode() {
            return applicationMode;
        }

        public final void setApplicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
        }

        @Override
        public final Builder applicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
            return this;
        }

        @Override
        public final Builder applicationMode(ApplicationMode applicationMode) {
            this.applicationMode(applicationMode == null ? null : applicationMode.toString());
            return this;
        }

        public final ApplicationPreferences.Builder getApplicationPreferences() {
            return applicationPreferences != null ? applicationPreferences.toBuilder() : null;
        }

        public final void setApplicationPreferences(ApplicationPreferences.BuilderImpl applicationPreferences) {
            this.applicationPreferences = applicationPreferences != null ? applicationPreferences.build() : null;
        }

        @Override
        public final Builder applicationPreferences(ApplicationPreferences applicationPreferences) {
            this.applicationPreferences = applicationPreferences;
            return this;
        }

        public final DatabasePreferences.Builder getDatabasePreferences() {
            return databasePreferences != null ? databasePreferences.toBuilder() : null;
        }

        public final void setDatabasePreferences(DatabasePreferences.BuilderImpl databasePreferences) {
            this.databasePreferences = databasePreferences != null ? databasePreferences.build() : null;
        }

        @Override
        public final Builder databasePreferences(DatabasePreferences databasePreferences) {
            this.databasePreferences = databasePreferences;
            return this;
        }

        public final PrioritizeBusinessGoals.Builder getPrioritizeBusinessGoals() {
            return prioritizeBusinessGoals != null ? prioritizeBusinessGoals.toBuilder() : null;
        }

        public final void setPrioritizeBusinessGoals(PrioritizeBusinessGoals.BuilderImpl prioritizeBusinessGoals) {
            this.prioritizeBusinessGoals = prioritizeBusinessGoals != null ? prioritizeBusinessGoals.build() : null;
        }

        @Override
        public final Builder prioritizeBusinessGoals(PrioritizeBusinessGoals prioritizeBusinessGoals) {
            this.prioritizeBusinessGoals = prioritizeBusinessGoals;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPortfolioPreferencesRequest build() {
            return new PutPortfolioPreferencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
