/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error in server analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Result implements SdkPojo, Serializable, ToCopyableBuilder<Result.Builder, Result> {
    private static final SdkField<AnalysisStatusUnion> ANALYSIS_STATUS_FIELD = SdkField
            .<AnalysisStatusUnion> builder(MarshallingType.SDK_POJO).memberName("analysisStatus")
            .getter(getter(Result::analysisStatus)).setter(setter(Builder::analysisStatus))
            .constructor(AnalysisStatusUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisStatus").build()).build();

    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisType").getter(getter(Result::analysisTypeAsString)).setter(setter(Builder::analysisType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisType").build()).build();

    private static final SdkField<List<AntipatternReportResult>> ANTIPATTERN_REPORT_RESULT_LIST_FIELD = SdkField
            .<List<AntipatternReportResult>> builder(MarshallingType.LIST)
            .memberName("antipatternReportResultList")
            .getter(getter(Result::antipatternReportResultList))
            .setter(setter(Builder::antipatternReportResultList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportResultList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AntipatternReportResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(AntipatternReportResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(Result::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_STATUS_FIELD,
            ANALYSIS_TYPE_FIELD, ANTIPATTERN_REPORT_RESULT_LIST_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AnalysisStatusUnion analysisStatus;

    private final String analysisType;

    private final List<AntipatternReportResult> antipatternReportResultList;

    private final String statusMessage;

    private Result(BuilderImpl builder) {
        this.analysisStatus = builder.analysisStatus;
        this.analysisType = builder.analysisType;
        this.antipatternReportResultList = builder.antipatternReportResultList;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The error in server analysis.
     * </p>
     * 
     * @return The error in server analysis.
     */
    public final AnalysisStatusUnion analysisStatus() {
        return analysisStatus;
    }

    /**
     * <p>
     * The error in server analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The error in server analysis.
     * @see AnalysisType
     */
    public final AnalysisType analysisType() {
        return AnalysisType.fromValue(analysisType);
    }

    /**
     * <p>
     * The error in server analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The error in server analysis.
     * @see AnalysisType
     */
    public final String analysisTypeAsString() {
        return analysisType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AntipatternReportResultList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAntipatternReportResultList() {
        return antipatternReportResultList != null && !(antipatternReportResultList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The error in server analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAntipatternReportResultList} method.
     * </p>
     * 
     * @return The error in server analysis.
     */
    public final List<AntipatternReportResult> antipatternReportResultList() {
        return antipatternReportResultList;
    }

    /**
     * <p>
     * The error in server analysis.
     * </p>
     * 
     * @return The error in server analysis.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analysisStatus());
        hashCode = 31 * hashCode + Objects.hashCode(analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAntipatternReportResultList() ? antipatternReportResultList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Result)) {
            return false;
        }
        Result other = (Result) obj;
        return Objects.equals(analysisStatus(), other.analysisStatus())
                && Objects.equals(analysisTypeAsString(), other.analysisTypeAsString())
                && hasAntipatternReportResultList() == other.hasAntipatternReportResultList()
                && Objects.equals(antipatternReportResultList(), other.antipatternReportResultList())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Result").add("AnalysisStatus", analysisStatus()).add("AnalysisType", analysisTypeAsString())
                .add("AntipatternReportResultList", hasAntipatternReportResultList() ? antipatternReportResultList() : null)
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analysisStatus":
            return Optional.ofNullable(clazz.cast(analysisStatus()));
        case "analysisType":
            return Optional.ofNullable(clazz.cast(analysisTypeAsString()));
        case "antipatternReportResultList":
            return Optional.ofNullable(clazz.cast(antipatternReportResultList()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analysisStatus", ANALYSIS_STATUS_FIELD);
        map.put("analysisType", ANALYSIS_TYPE_FIELD);
        map.put("antipatternReportResultList", ANTIPATTERN_REPORT_RESULT_LIST_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Result, T> g) {
        return obj -> g.apply((Result) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Result> {
        /**
         * <p>
         * The error in server analysis.
         * </p>
         * 
         * @param analysisStatus
         *        The error in server analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisStatus(AnalysisStatusUnion analysisStatus);

        /**
         * <p>
         * The error in server analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisStatusUnion.Builder} avoiding the
         * need to create one manually via {@link AnalysisStatusUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisStatusUnion.Builder#build()} is called immediately and
         * its result is passed to {@link #analysisStatus(AnalysisStatusUnion)}.
         * 
         * @param analysisStatus
         *        a consumer that will call methods on {@link AnalysisStatusUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisStatus(AnalysisStatusUnion)
         */
        default Builder analysisStatus(Consumer<AnalysisStatusUnion.Builder> analysisStatus) {
            return analysisStatus(AnalysisStatusUnion.builder().applyMutation(analysisStatus).build());
        }

        /**
         * <p>
         * The error in server analysis.
         * </p>
         * 
         * @param analysisType
         *        The error in server analysis.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(String analysisType);

        /**
         * <p>
         * The error in server analysis.
         * </p>
         * 
         * @param analysisType
         *        The error in server analysis.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(AnalysisType analysisType);

        /**
         * <p>
         * The error in server analysis.
         * </p>
         * 
         * @param antipatternReportResultList
         *        The error in server analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antipatternReportResultList(Collection<AntipatternReportResult> antipatternReportResultList);

        /**
         * <p>
         * The error in server analysis.
         * </p>
         * 
         * @param antipatternReportResultList
         *        The error in server analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antipatternReportResultList(AntipatternReportResult... antipatternReportResultList);

        /**
         * <p>
         * The error in server analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternReportResult.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternReportResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternReportResult.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #antipatternReportResultList(List<AntipatternReportResult>)}.
         * 
         * @param antipatternReportResultList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternReportResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #antipatternReportResultList(java.util.Collection<AntipatternReportResult>)
         */
        Builder antipatternReportResultList(Consumer<AntipatternReportResult.Builder>... antipatternReportResultList);

        /**
         * <p>
         * The error in server analysis.
         * </p>
         * 
         * @param statusMessage
         *        The error in server analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private AnalysisStatusUnion analysisStatus;

        private String analysisType;

        private List<AntipatternReportResult> antipatternReportResultList = DefaultSdkAutoConstructList.getInstance();

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Result model) {
            analysisStatus(model.analysisStatus);
            analysisType(model.analysisType);
            antipatternReportResultList(model.antipatternReportResultList);
            statusMessage(model.statusMessage);
        }

        public final AnalysisStatusUnion.Builder getAnalysisStatus() {
            return analysisStatus != null ? analysisStatus.toBuilder() : null;
        }

        public final void setAnalysisStatus(AnalysisStatusUnion.BuilderImpl analysisStatus) {
            this.analysisStatus = analysisStatus != null ? analysisStatus.build() : null;
        }

        @Override
        public final Builder analysisStatus(AnalysisStatusUnion analysisStatus) {
            this.analysisStatus = analysisStatus;
            return this;
        }

        public final String getAnalysisType() {
            return analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(AnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final List<AntipatternReportResult.Builder> getAntipatternReportResultList() {
            List<AntipatternReportResult.Builder> result = AntipatternReportResultListCopier
                    .copyToBuilder(this.antipatternReportResultList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAntipatternReportResultList(
                Collection<AntipatternReportResult.BuilderImpl> antipatternReportResultList) {
            this.antipatternReportResultList = AntipatternReportResultListCopier.copyFromBuilder(antipatternReportResultList);
        }

        @Override
        public final Builder antipatternReportResultList(Collection<AntipatternReportResult> antipatternReportResultList) {
            this.antipatternReportResultList = AntipatternReportResultListCopier.copy(antipatternReportResultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder antipatternReportResultList(AntipatternReportResult... antipatternReportResultList) {
            antipatternReportResultList(Arrays.asList(antipatternReportResultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder antipatternReportResultList(Consumer<AntipatternReportResult.Builder>... antipatternReportResultList) {
            antipatternReportResultList(Stream.of(antipatternReportResultList)
                    .map(c -> AntipatternReportResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public Result build() {
            return new Result(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
