/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error in server analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerError implements SdkPojo, Serializable, ToCopyableBuilder<ServerError.Builder, ServerError> {
    private static final SdkField<String> SERVER_ERROR_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverErrorCategory").getter(getter(ServerError::serverErrorCategoryAsString))
            .setter(setter(Builder::serverErrorCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverErrorCategory").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ERROR_CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serverErrorCategory;

    private ServerError(BuilderImpl builder) {
        this.serverErrorCategory = builder.serverErrorCategory;
    }

    /**
     * <p>
     * The error category of server analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverErrorCategory} will return {@link ServerErrorCategory#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serverErrorCategoryAsString}.
     * </p>
     * 
     * @return The error category of server analysis.
     * @see ServerErrorCategory
     */
    public final ServerErrorCategory serverErrorCategory() {
        return ServerErrorCategory.fromValue(serverErrorCategory);
    }

    /**
     * <p>
     * The error category of server analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverErrorCategory} will return {@link ServerErrorCategory#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serverErrorCategoryAsString}.
     * </p>
     * 
     * @return The error category of server analysis.
     * @see ServerErrorCategory
     */
    public final String serverErrorCategoryAsString() {
        return serverErrorCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverErrorCategoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerError)) {
            return false;
        }
        ServerError other = (ServerError) obj;
        return Objects.equals(serverErrorCategoryAsString(), other.serverErrorCategoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerError").add("ServerErrorCategory", serverErrorCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverErrorCategory":
            return Optional.ofNullable(clazz.cast(serverErrorCategoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serverErrorCategory", SERVER_ERROR_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerError, T> g) {
        return obj -> g.apply((ServerError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerError> {
        /**
         * <p>
         * The error category of server analysis.
         * </p>
         * 
         * @param serverErrorCategory
         *        The error category of server analysis.
         * @see ServerErrorCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerErrorCategory
         */
        Builder serverErrorCategory(String serverErrorCategory);

        /**
         * <p>
         * The error category of server analysis.
         * </p>
         * 
         * @param serverErrorCategory
         *        The error category of server analysis.
         * @see ServerErrorCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerErrorCategory
         */
        Builder serverErrorCategory(ServerErrorCategory serverErrorCategory);
    }

    static final class BuilderImpl implements Builder {
        private String serverErrorCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerError model) {
            serverErrorCategory(model.serverErrorCategory);
        }

        public final String getServerErrorCategory() {
            return serverErrorCategory;
        }

        public final void setServerErrorCategory(String serverErrorCategory) {
            this.serverErrorCategory = serverErrorCategory;
        }

        @Override
        public final Builder serverErrorCategory(String serverErrorCategory) {
            this.serverErrorCategory = serverErrorCategory;
            return this;
        }

        @Override
        public final Builder serverErrorCategory(ServerErrorCategory serverErrorCategory) {
            this.serverErrorCategory(serverErrorCategory == null ? null : serverErrorCategory.toString());
            return this;
        }

        @Override
        public ServerError build() {
            return new ServerError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
