/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing source code information that is linked to an application component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceCode implements SdkPojo, Serializable, ToCopyableBuilder<SourceCode.Builder, SourceCode> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(SourceCode::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(SourceCode::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVersion").getter(getter(SourceCode::sourceVersion)).setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final SdkField<String> VERSION_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionControl").getter(getter(SourceCode::versionControlAsString))
            .setter(setter(Builder::versionControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionControl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD,
            PROJECT_NAME_FIELD, SOURCE_VERSION_FIELD, VERSION_CONTROL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String location;

    private final String projectName;

    private final String sourceVersion;

    private final String versionControl;

    private SourceCode(BuilderImpl builder) {
        this.location = builder.location;
        this.projectName = builder.projectName;
        this.sourceVersion = builder.sourceVersion;
        this.versionControl = builder.versionControl;
    }

    /**
     * <p>
     * The repository name for the source code.
     * </p>
     * 
     * @return The repository name for the source code.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The name of the project.
     * </p>
     * 
     * @return The name of the project.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The branch of the source code.
     * </p>
     * 
     * @return The branch of the source code.
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    /**
     * <p>
     * The type of repository to use for the source code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionControl}
     * will return {@link VersionControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #versionControlAsString}.
     * </p>
     * 
     * @return The type of repository to use for the source code.
     * @see VersionControl
     */
    public final VersionControl versionControl() {
        return VersionControl.fromValue(versionControl);
    }

    /**
     * <p>
     * The type of repository to use for the source code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionControl}
     * will return {@link VersionControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #versionControlAsString}.
     * </p>
     * 
     * @return The type of repository to use for the source code.
     * @see VersionControl
     */
    public final String versionControlAsString() {
        return versionControl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(versionControlAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCode)) {
            return false;
        }
        SourceCode other = (SourceCode) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(projectName(), other.projectName())
                && Objects.equals(sourceVersion(), other.sourceVersion())
                && Objects.equals(versionControlAsString(), other.versionControlAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceCode").add("Location", location()).add("ProjectName", projectName())
                .add("SourceVersion", sourceVersion()).add("VersionControl", versionControlAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "sourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        case "versionControl":
            return Optional.ofNullable(clazz.cast(versionControlAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("location", LOCATION_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        map.put("versionControl", VERSION_CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceCode, T> g) {
        return obj -> g.apply((SourceCode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceCode> {
        /**
         * <p>
         * The repository name for the source code.
         * </p>
         * 
         * @param location
         *        The repository name for the source code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The name of the project.
         * </p>
         * 
         * @param projectName
         *        The name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The branch of the source code.
         * </p>
         * 
         * @param sourceVersion
         *        The branch of the source code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        /**
         * <p>
         * The type of repository to use for the source code.
         * </p>
         * 
         * @param versionControl
         *        The type of repository to use for the source code.
         * @see VersionControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionControl
         */
        Builder versionControl(String versionControl);

        /**
         * <p>
         * The type of repository to use for the source code.
         * </p>
         * 
         * @param versionControl
         *        The type of repository to use for the source code.
         * @see VersionControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionControl
         */
        Builder versionControl(VersionControl versionControl);
    }

    static final class BuilderImpl implements Builder {
        private String location;

        private String projectName;

        private String sourceVersion;

        private String versionControl;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCode model) {
            location(model.location);
            projectName(model.projectName);
            sourceVersion(model.sourceVersion);
            versionControl(model.versionControl);
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final String getVersionControl() {
            return versionControl;
        }

        public final void setVersionControl(String versionControl) {
            this.versionControl = versionControl;
        }

        @Override
        public final Builder versionControl(String versionControl) {
            this.versionControl = versionControl;
            return this;
        }

        @Override
        public final Builder versionControl(VersionControl versionControl) {
            this.versionControl(versionControl == null ? null : versionControl.toString());
            return this;
        }

        @Override
        public SourceCode build() {
            return new SourceCode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
