/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportFileTaskRequest extends MigrationHubStrategyRequest implements
        ToCopyableBuilder<StartImportFileTaskRequest.Builder, StartImportFileTaskRequest> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(StartImportFileTaskRequest::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceType").getter(getter(StartImportFileTaskRequest::dataSourceTypeAsString))
            .setter(setter(Builder::dataSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceType").build()).build();

    private static final SdkField<List<Group>> GROUP_ID_FIELD = SdkField
            .<List<Group>> builder(MarshallingType.LIST)
            .memberName("groupId")
            .getter(getter(StartImportFileTaskRequest::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Group> builder(MarshallingType.SDK_POJO)
                                            .constructor(Group::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartImportFileTaskRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> S3_BUCKET_FOR_REPORT_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3bucketForReportData").getter(getter(StartImportFileTaskRequest::s3bucketForReportData))
            .setter(setter(Builder::s3bucketForReportData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3bucketForReportData").build())
            .build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3key")
            .getter(getter(StartImportFileTaskRequest::s3key)).setter(setter(Builder::s3key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD,
            DATA_SOURCE_TYPE_FIELD, GROUP_ID_FIELD, NAME_FIELD, S3_BUCKET_FOR_REPORT_DATA_FIELD, S3_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String s3Bucket;

    private final String dataSourceType;

    private final List<Group> groupId;

    private final String name;

    private final String s3bucketForReportData;

    private final String s3key;

    private StartImportFileTaskRequest(BuilderImpl builder) {
        super(builder);
        this.s3Bucket = builder.s3Bucket;
        this.dataSourceType = builder.dataSourceType;
        this.groupId = builder.groupId;
        this.name = builder.name;
        this.s3bucketForReportData = builder.s3bucketForReportData;
        this.s3key = builder.s3key;
    }

    /**
     * <p>
     * The S3 bucket where the import file is located. The bucket name is required to begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @return The S3 bucket where the import file is located. The bucket name is required to begin with
     *         <code>migrationhub-strategy-</code>.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that the
     * servers specified in the import file are available in AWS Application Discovery Service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSourceType}
     * will return {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataSourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that
     *         the servers specified in the import file are available in AWS Application Discovery Service.
     * @see DataSourceType
     */
    public final DataSourceType dataSourceType() {
        return DataSourceType.fromValue(dataSourceType);
    }

    /**
     * <p>
     * Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that the
     * servers specified in the import file are available in AWS Application Discovery Service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSourceType}
     * will return {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataSourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that
     *         the servers specified in the import file are available in AWS Application Discovery Service.
     * @see DataSourceType
     */
    public final String dataSourceTypeAsString() {
        return dataSourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupId property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupId() {
        return groupId != null && !(groupId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Groups the resources in the import file together with a unique name. This ID can be as filter in
     * <code>ListApplicationComponents</code> and <code>ListServers</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupId} method.
     * </p>
     * 
     * @return Groups the resources in the import file together with a unique name. This ID can be as filter in
     *         <code>ListApplicationComponents</code> and <code>ListServers</code>.
     */
    public final List<Group> groupId() {
        return groupId;
    }

    /**
     * <p>
     * A descriptive name for the request.
     * </p>
     * 
     * @return A descriptive name for the request.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to begin with
     * migrationhub-strategy-.
     * </p>
     * 
     * @return The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to begin
     *         with migrationhub-strategy-.
     */
    public final String s3bucketForReportData() {
        return s3bucketForReportData;
    }

    /**
     * <p>
     * The Amazon S3 key name of the import file.
     * </p>
     * 
     * @return The Amazon S3 key name of the import file.
     */
    public final String s3key() {
        return s3key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupId() ? groupId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3bucketForReportData());
        hashCode = 31 * hashCode + Objects.hashCode(s3key());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportFileTaskRequest)) {
            return false;
        }
        StartImportFileTaskRequest other = (StartImportFileTaskRequest) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(dataSourceTypeAsString(), other.dataSourceTypeAsString()) && hasGroupId() == other.hasGroupId()
                && Objects.equals(groupId(), other.groupId()) && Objects.equals(name(), other.name())
                && Objects.equals(s3bucketForReportData(), other.s3bucketForReportData())
                && Objects.equals(s3key(), other.s3key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImportFileTaskRequest").add("S3Bucket", s3Bucket())
                .add("DataSourceType", dataSourceTypeAsString()).add("GroupId", hasGroupId() ? groupId() : null)
                .add("Name", name()).add("S3bucketForReportData", s3bucketForReportData()).add("S3key", s3key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "dataSourceType":
            return Optional.ofNullable(clazz.cast(dataSourceTypeAsString()));
        case "groupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "s3bucketForReportData":
            return Optional.ofNullable(clazz.cast(s3bucketForReportData()));
        case "s3key":
            return Optional.ofNullable(clazz.cast(s3key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("dataSourceType", DATA_SOURCE_TYPE_FIELD);
        map.put("groupId", GROUP_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("s3bucketForReportData", S3_BUCKET_FOR_REPORT_DATA_FIELD);
        map.put("s3key", S3_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartImportFileTaskRequest, T> g) {
        return obj -> g.apply((StartImportFileTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartImportFileTaskRequest> {
        /**
         * <p>
         * The S3 bucket where the import file is located. The bucket name is required to begin with
         * <code>migrationhub-strategy-</code>.
         * </p>
         * 
         * @param s3Bucket
         *        The S3 bucket where the import file is located. The bucket name is required to begin with
         *        <code>migrationhub-strategy-</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that the
         * servers specified in the import file are available in AWS Application Discovery Service.
         * </p>
         * 
         * @param dataSourceType
         *        Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes
         *        that the servers specified in the import file are available in AWS Application Discovery Service.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder dataSourceType(String dataSourceType);

        /**
         * <p>
         * Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that the
         * servers specified in the import file are available in AWS Application Discovery Service.
         * </p>
         * 
         * @param dataSourceType
         *        Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes
         *        that the servers specified in the import file are available in AWS Application Discovery Service.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder dataSourceType(DataSourceType dataSourceType);

        /**
         * <p>
         * Groups the resources in the import file together with a unique name. This ID can be as filter in
         * <code>ListApplicationComponents</code> and <code>ListServers</code>.
         * </p>
         * 
         * @param groupId
         *        Groups the resources in the import file together with a unique name. This ID can be as filter in
         *        <code>ListApplicationComponents</code> and <code>ListServers</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(Collection<Group> groupId);

        /**
         * <p>
         * Groups the resources in the import file together with a unique name. This ID can be as filter in
         * <code>ListApplicationComponents</code> and <code>ListServers</code>.
         * </p>
         * 
         * @param groupId
         *        Groups the resources in the import file together with a unique name. This ID can be as filter in
         *        <code>ListApplicationComponents</code> and <code>ListServers</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(Group... groupId);

        /**
         * <p>
         * Groups the resources in the import file together with a unique name. This ID can be as filter in
         * <code>ListApplicationComponents</code> and <code>ListServers</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.Group.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.migrationhubstrategy.model.Group#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.Group.Builder#build()} is called
         * immediately and its result is passed to {@link #groupId(List<Group>)}.
         * 
         * @param groupId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.Group.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupId(java.util.Collection<Group>)
         */
        Builder groupId(Consumer<Group.Builder>... groupId);

        /**
         * <p>
         * A descriptive name for the request.
         * </p>
         * 
         * @param name
         *        A descriptive name for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to begin
         * with migrationhub-strategy-.
         * </p>
         * 
         * @param s3bucketForReportData
         *        The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to
         *        begin with migrationhub-strategy-.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3bucketForReportData(String s3bucketForReportData);

        /**
         * <p>
         * The Amazon S3 key name of the import file.
         * </p>
         * 
         * @param s3key
         *        The Amazon S3 key name of the import file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3key(String s3key);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubStrategyRequest.BuilderImpl implements Builder {
        private String s3Bucket;

        private String dataSourceType;

        private List<Group> groupId = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String s3bucketForReportData;

        private String s3key;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportFileTaskRequest model) {
            super(model);
            s3Bucket(model.s3Bucket);
            dataSourceType(model.dataSourceType);
            groupId(model.groupId);
            name(model.name);
            s3bucketForReportData(model.s3bucketForReportData);
            s3key(model.s3key);
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getDataSourceType() {
            return dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public final Builder dataSourceType(DataSourceType dataSourceType) {
            this.dataSourceType(dataSourceType == null ? null : dataSourceType.toString());
            return this;
        }

        public final List<Group.Builder> getGroupId() {
            List<Group.Builder> result = GroupIdsCopier.copyToBuilder(this.groupId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupId(Collection<Group.BuilderImpl> groupId) {
            this.groupId = GroupIdsCopier.copyFromBuilder(groupId);
        }

        @Override
        public final Builder groupId(Collection<Group> groupId) {
            this.groupId = GroupIdsCopier.copy(groupId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupId(Group... groupId) {
            groupId(Arrays.asList(groupId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupId(Consumer<Group.Builder>... groupId) {
            groupId(Stream.of(groupId).map(c -> Group.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getS3bucketForReportData() {
            return s3bucketForReportData;
        }

        public final void setS3bucketForReportData(String s3bucketForReportData) {
            this.s3bucketForReportData = s3bucketForReportData;
        }

        @Override
        public final Builder s3bucketForReportData(String s3bucketForReportData) {
            this.s3bucketForReportData = s3bucketForReportData;
            return this;
        }

        public final String getS3key() {
            return s3key;
        }

        public final void setS3key(String s3key) {
            this.s3key = s3key;
        }

        @Override
        public final Builder s3key(String s3key) {
            this.s3key = s3key;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportFileTaskRequest build() {
            return new StartImportFileTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
