/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about all the available strategy options for migrating and modernizing an application component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StrategyOption implements SdkPojo, Serializable, ToCopyableBuilder<StrategyOption.Builder, StrategyOption> {
    private static final SdkField<Boolean> IS_PREFERRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPreferred").getter(getter(StrategyOption::isPreferred)).setter(setter(Builder::isPreferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPreferred").build()).build();

    private static final SdkField<String> STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("strategy").getter(getter(StrategyOption::strategyAsString)).setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategy").build()).build();

    private static final SdkField<String> TARGET_DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetDestination").getter(getter(StrategyOption::targetDestinationAsString))
            .setter(setter(Builder::targetDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDestination").build()).build();

    private static final SdkField<String> TOOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toolName").getter(getter(StrategyOption::toolNameAsString)).setter(setter(Builder::toolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_PREFERRED_FIELD,
            STRATEGY_FIELD, TARGET_DESTINATION_FIELD, TOOL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isPreferred;

    private final String strategy;

    private final String targetDestination;

    private final String toolName;

    private StrategyOption(BuilderImpl builder) {
        this.isPreferred = builder.isPreferred;
        this.strategy = builder.strategy;
        this.targetDestination = builder.targetDestination;
        this.toolName = builder.toolName;
    }

    /**
     * <p>
     * Indicates if a specific strategy is preferred for the application component.
     * </p>
     * 
     * @return Indicates if a specific strategy is preferred for the application component.
     */
    public final Boolean isPreferred() {
        return isPreferred;
    }

    /**
     * <p>
     * Type of transformation. For example, Rehost, Replatform, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link Strategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return Type of transformation. For example, Rehost, Replatform, and so on.
     * @see Strategy
     */
    public final Strategy strategy() {
        return Strategy.fromValue(strategy);
    }

    /**
     * <p>
     * Type of transformation. For example, Rehost, Replatform, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link Strategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return Type of transformation. For example, Rehost, Replatform, and so on.
     * @see Strategy
     */
    public final String strategyAsString() {
        return strategy;
    }

    /**
     * <p>
     * Destination information about where the application component can migrate to. For example, <code>EC2</code>,
     * <code>ECS</code>, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetDestination}
     * will return {@link TargetDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetDestinationAsString}.
     * </p>
     * 
     * @return Destination information about where the application component can migrate to. For example,
     *         <code>EC2</code>, <code>ECS</code>, and so on.
     * @see TargetDestination
     */
    public final TargetDestination targetDestination() {
        return TargetDestination.fromValue(targetDestination);
    }

    /**
     * <p>
     * Destination information about where the application component can migrate to. For example, <code>EC2</code>,
     * <code>ECS</code>, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetDestination}
     * will return {@link TargetDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetDestinationAsString}.
     * </p>
     * 
     * @return Destination information about where the application component can migrate to. For example,
     *         <code>EC2</code>, <code>ECS</code>, and so on.
     * @see TargetDestination
     */
    public final String targetDestinationAsString() {
        return targetDestination;
    }

    /**
     * <p>
     * The name of the tool that can be used to transform an application component using this strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #toolName} will
     * return {@link TransformationToolName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #toolNameAsString}.
     * </p>
     * 
     * @return The name of the tool that can be used to transform an application component using this strategy.
     * @see TransformationToolName
     */
    public final TransformationToolName toolName() {
        return TransformationToolName.fromValue(toolName);
    }

    /**
     * <p>
     * The name of the tool that can be used to transform an application component using this strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #toolName} will
     * return {@link TransformationToolName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #toolNameAsString}.
     * </p>
     * 
     * @return The name of the tool that can be used to transform an application component using this strategy.
     * @see TransformationToolName
     */
    public final String toolNameAsString() {
        return toolName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isPreferred());
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetDestinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(toolNameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StrategyOption)) {
            return false;
        }
        StrategyOption other = (StrategyOption) obj;
        return Objects.equals(isPreferred(), other.isPreferred()) && Objects.equals(strategyAsString(), other.strategyAsString())
                && Objects.equals(targetDestinationAsString(), other.targetDestinationAsString())
                && Objects.equals(toolNameAsString(), other.toolNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StrategyOption").add("IsPreferred", isPreferred()).add("Strategy", strategyAsString())
                .add("TargetDestination", targetDestinationAsString()).add("ToolName", toolNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isPreferred":
            return Optional.ofNullable(clazz.cast(isPreferred()));
        case "strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        case "targetDestination":
            return Optional.ofNullable(clazz.cast(targetDestinationAsString()));
        case "toolName":
            return Optional.ofNullable(clazz.cast(toolNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isPreferred", IS_PREFERRED_FIELD);
        map.put("strategy", STRATEGY_FIELD);
        map.put("targetDestination", TARGET_DESTINATION_FIELD);
        map.put("toolName", TOOL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StrategyOption, T> g) {
        return obj -> g.apply((StrategyOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StrategyOption> {
        /**
         * <p>
         * Indicates if a specific strategy is preferred for the application component.
         * </p>
         * 
         * @param isPreferred
         *        Indicates if a specific strategy is preferred for the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPreferred(Boolean isPreferred);

        /**
         * <p>
         * Type of transformation. For example, Rehost, Replatform, and so on.
         * </p>
         * 
         * @param strategy
         *        Type of transformation. For example, Rehost, Replatform, and so on.
         * @see Strategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Strategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * Type of transformation. For example, Rehost, Replatform, and so on.
         * </p>
         * 
         * @param strategy
         *        Type of transformation. For example, Rehost, Replatform, and so on.
         * @see Strategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Strategy
         */
        Builder strategy(Strategy strategy);

        /**
         * <p>
         * Destination information about where the application component can migrate to. For example, <code>EC2</code>,
         * <code>ECS</code>, and so on.
         * </p>
         * 
         * @param targetDestination
         *        Destination information about where the application component can migrate to. For example,
         *        <code>EC2</code>, <code>ECS</code>, and so on.
         * @see TargetDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDestination
         */
        Builder targetDestination(String targetDestination);

        /**
         * <p>
         * Destination information about where the application component can migrate to. For example, <code>EC2</code>,
         * <code>ECS</code>, and so on.
         * </p>
         * 
         * @param targetDestination
         *        Destination information about where the application component can migrate to. For example,
         *        <code>EC2</code>, <code>ECS</code>, and so on.
         * @see TargetDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDestination
         */
        Builder targetDestination(TargetDestination targetDestination);

        /**
         * <p>
         * The name of the tool that can be used to transform an application component using this strategy.
         * </p>
         * 
         * @param toolName
         *        The name of the tool that can be used to transform an application component using this strategy.
         * @see TransformationToolName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformationToolName
         */
        Builder toolName(String toolName);

        /**
         * <p>
         * The name of the tool that can be used to transform an application component using this strategy.
         * </p>
         * 
         * @param toolName
         *        The name of the tool that can be used to transform an application component using this strategy.
         * @see TransformationToolName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformationToolName
         */
        Builder toolName(TransformationToolName toolName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isPreferred;

        private String strategy;

        private String targetDestination;

        private String toolName;

        private BuilderImpl() {
        }

        private BuilderImpl(StrategyOption model) {
            isPreferred(model.isPreferred);
            strategy(model.strategy);
            targetDestination(model.targetDestination);
            toolName(model.toolName);
        }

        public final Boolean getIsPreferred() {
            return isPreferred;
        }

        public final void setIsPreferred(Boolean isPreferred) {
            this.isPreferred = isPreferred;
        }

        @Override
        public final Builder isPreferred(Boolean isPreferred) {
            this.isPreferred = isPreferred;
            return this;
        }

        public final String getStrategy() {
            return strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(Strategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final String getTargetDestination() {
            return targetDestination;
        }

        public final void setTargetDestination(String targetDestination) {
            this.targetDestination = targetDestination;
        }

        @Override
        public final Builder targetDestination(String targetDestination) {
            this.targetDestination = targetDestination;
            return this;
        }

        @Override
        public final Builder targetDestination(TargetDestination targetDestination) {
            this.targetDestination(targetDestination == null ? null : targetDestination.toString());
            return this;
        }

        public final String getToolName() {
            return toolName;
        }

        public final void setToolName(String toolName) {
            this.toolName = toolName;
        }

        @Override
        public final Builder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        @Override
        public final Builder toolName(TransformationToolName toolName) {
            this.toolName(toolName == null ? null : toolName.toString());
            return this;
        }

        @Override
        public StrategyOption build() {
            return new StrategyOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
