/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the server in vCenter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VcenterBasedRemoteInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<VcenterBasedRemoteInfo.Builder, VcenterBasedRemoteInfo> {
    private static final SdkField<String> OS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("osType")
            .getter(getter(VcenterBasedRemoteInfo::osTypeAsString)).setter(setter(Builder::osType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osType").build()).build();

    private static final SdkField<String> VCENTER_CONFIGURATION_TIME_STAMP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("vcenterConfigurationTimeStamp")
            .getter(getter(VcenterBasedRemoteInfo::vcenterConfigurationTimeStamp))
            .setter(setter(Builder::vcenterConfigurationTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcenterConfigurationTimeStamp")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OS_TYPE_FIELD,
            VCENTER_CONFIGURATION_TIME_STAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String osType;

    private final String vcenterConfigurationTimeStamp;

    private VcenterBasedRemoteInfo(BuilderImpl builder) {
        this.osType = builder.osType;
        this.vcenterConfigurationTimeStamp = builder.vcenterConfigurationTimeStamp;
    }

    /**
     * <p>
     * The type of the operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osType} will
     * return {@link OSType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osTypeAsString}.
     * </p>
     * 
     * @return The type of the operating system.
     * @see OSType
     */
    public final OSType osType() {
        return OSType.fromValue(osType);
    }

    /**
     * <p>
     * The type of the operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osType} will
     * return {@link OSType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osTypeAsString}.
     * </p>
     * 
     * @return The type of the operating system.
     * @see OSType
     */
    public final String osTypeAsString() {
        return osType;
    }

    /**
     * <p>
     * The time when the remote server based on vCenter was last configured.
     * </p>
     * 
     * @return The time when the remote server based on vCenter was last configured.
     */
    public final String vcenterConfigurationTimeStamp() {
        return vcenterConfigurationTimeStamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(osTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vcenterConfigurationTimeStamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VcenterBasedRemoteInfo)) {
            return false;
        }
        VcenterBasedRemoteInfo other = (VcenterBasedRemoteInfo) obj;
        return Objects.equals(osTypeAsString(), other.osTypeAsString())
                && Objects.equals(vcenterConfigurationTimeStamp(), other.vcenterConfigurationTimeStamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VcenterBasedRemoteInfo").add("OsType", osTypeAsString())
                .add("VcenterConfigurationTimeStamp", vcenterConfigurationTimeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "osType":
            return Optional.ofNullable(clazz.cast(osTypeAsString()));
        case "vcenterConfigurationTimeStamp":
            return Optional.ofNullable(clazz.cast(vcenterConfigurationTimeStamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("osType", OS_TYPE_FIELD);
        map.put("vcenterConfigurationTimeStamp", VCENTER_CONFIGURATION_TIME_STAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VcenterBasedRemoteInfo, T> g) {
        return obj -> g.apply((VcenterBasedRemoteInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VcenterBasedRemoteInfo> {
        /**
         * <p>
         * The type of the operating system.
         * </p>
         * 
         * @param osType
         *        The type of the operating system.
         * @see OSType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OSType
         */
        Builder osType(String osType);

        /**
         * <p>
         * The type of the operating system.
         * </p>
         * 
         * @param osType
         *        The type of the operating system.
         * @see OSType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OSType
         */
        Builder osType(OSType osType);

        /**
         * <p>
         * The time when the remote server based on vCenter was last configured.
         * </p>
         * 
         * @param vcenterConfigurationTimeStamp
         *        The time when the remote server based on vCenter was last configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcenterConfigurationTimeStamp(String vcenterConfigurationTimeStamp);
    }

    static final class BuilderImpl implements Builder {
        private String osType;

        private String vcenterConfigurationTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VcenterBasedRemoteInfo model) {
            osType(model.osType);
            vcenterConfigurationTimeStamp(model.vcenterConfigurationTimeStamp);
        }

        public final String getOsType() {
            return osType;
        }

        public final void setOsType(String osType) {
            this.osType = osType;
        }

        @Override
        public final Builder osType(String osType) {
            this.osType = osType;
            return this;
        }

        @Override
        public final Builder osType(OSType osType) {
            this.osType(osType == null ? null : osType.toString());
            return this;
        }

        public final String getVcenterConfigurationTimeStamp() {
            return vcenterConfigurationTimeStamp;
        }

        public final void setVcenterConfigurationTimeStamp(String vcenterConfigurationTimeStamp) {
            this.vcenterConfigurationTimeStamp = vcenterConfigurationTimeStamp;
        }

        @Override
        public final Builder vcenterConfigurationTimeStamp(String vcenterConfigurationTimeStamp) {
            this.vcenterConfigurationTimeStamp = vcenterConfigurationTimeStamp;
            return this;
        }

        @Override
        public VcenterBasedRemoteInfo build() {
            return new VcenterBasedRemoteInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
