/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the version control configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VersionControlInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<VersionControlInfo.Builder, VersionControlInfo> {
    private static final SdkField<String> VERSION_CONTROL_CONFIGURATION_TIME_STAMP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("versionControlConfigurationTimeStamp")
            .getter(getter(VersionControlInfo::versionControlConfigurationTimeStamp))
            .setter(setter(Builder::versionControlConfigurationTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("versionControlConfigurationTimeStamp").build()).build();

    private static final SdkField<String> VERSION_CONTROL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionControlType").getter(getter(VersionControlInfo::versionControlTypeAsString))
            .setter(setter(Builder::versionControlType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionControlType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERSION_CONTROL_CONFIGURATION_TIME_STAMP_FIELD, VERSION_CONTROL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String versionControlConfigurationTimeStamp;

    private final String versionControlType;

    private VersionControlInfo(BuilderImpl builder) {
        this.versionControlConfigurationTimeStamp = builder.versionControlConfigurationTimeStamp;
        this.versionControlType = builder.versionControlType;
    }

    /**
     * <p>
     * The time when the version control system was last configured.
     * </p>
     * 
     * @return The time when the version control system was last configured.
     */
    public final String versionControlConfigurationTimeStamp() {
        return versionControlConfigurationTimeStamp;
    }

    /**
     * <p>
     * The type of version control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #versionControlType} will return {@link VersionControlType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #versionControlTypeAsString}.
     * </p>
     * 
     * @return The type of version control.
     * @see VersionControlType
     */
    public final VersionControlType versionControlType() {
        return VersionControlType.fromValue(versionControlType);
    }

    /**
     * <p>
     * The type of version control.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #versionControlType} will return {@link VersionControlType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #versionControlTypeAsString}.
     * </p>
     * 
     * @return The type of version control.
     * @see VersionControlType
     */
    public final String versionControlTypeAsString() {
        return versionControlType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(versionControlConfigurationTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(versionControlTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionControlInfo)) {
            return false;
        }
        VersionControlInfo other = (VersionControlInfo) obj;
        return Objects.equals(versionControlConfigurationTimeStamp(), other.versionControlConfigurationTimeStamp())
                && Objects.equals(versionControlTypeAsString(), other.versionControlTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VersionControlInfo")
                .add("VersionControlConfigurationTimeStamp", versionControlConfigurationTimeStamp())
                .add("VersionControlType", versionControlTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "versionControlConfigurationTimeStamp":
            return Optional.ofNullable(clazz.cast(versionControlConfigurationTimeStamp()));
        case "versionControlType":
            return Optional.ofNullable(clazz.cast(versionControlTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("versionControlConfigurationTimeStamp", VERSION_CONTROL_CONFIGURATION_TIME_STAMP_FIELD);
        map.put("versionControlType", VERSION_CONTROL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VersionControlInfo, T> g) {
        return obj -> g.apply((VersionControlInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VersionControlInfo> {
        /**
         * <p>
         * The time when the version control system was last configured.
         * </p>
         * 
         * @param versionControlConfigurationTimeStamp
         *        The time when the version control system was last configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionControlConfigurationTimeStamp(String versionControlConfigurationTimeStamp);

        /**
         * <p>
         * The type of version control.
         * </p>
         * 
         * @param versionControlType
         *        The type of version control.
         * @see VersionControlType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionControlType
         */
        Builder versionControlType(String versionControlType);

        /**
         * <p>
         * The type of version control.
         * </p>
         * 
         * @param versionControlType
         *        The type of version control.
         * @see VersionControlType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionControlType
         */
        Builder versionControlType(VersionControlType versionControlType);
    }

    static final class BuilderImpl implements Builder {
        private String versionControlConfigurationTimeStamp;

        private String versionControlType;

        private BuilderImpl() {
        }

        private BuilderImpl(VersionControlInfo model) {
            versionControlConfigurationTimeStamp(model.versionControlConfigurationTimeStamp);
            versionControlType(model.versionControlType);
        }

        public final String getVersionControlConfigurationTimeStamp() {
            return versionControlConfigurationTimeStamp;
        }

        public final void setVersionControlConfigurationTimeStamp(String versionControlConfigurationTimeStamp) {
            this.versionControlConfigurationTimeStamp = versionControlConfigurationTimeStamp;
        }

        @Override
        public final Builder versionControlConfigurationTimeStamp(String versionControlConfigurationTimeStamp) {
            this.versionControlConfigurationTimeStamp = versionControlConfigurationTimeStamp;
            return this;
        }

        public final String getVersionControlType() {
            return versionControlType;
        }

        public final void setVersionControlType(String versionControlType) {
            this.versionControlType = versionControlType;
        }

        @Override
        public final Builder versionControlType(String versionControlType) {
            this.versionControlType = versionControlType;
            return this;
        }

        @Override
        public final Builder versionControlType(VersionControlType versionControlType) {
            this.versionControlType(versionControlType == null ? null : versionControlType.toString());
            return this;
        }

        @Override
        public VersionControlInfo build() {
            return new VersionControlInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
