/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mobile.model.MobileRequest;
import software.amazon.awssdk.services.mobile.model.Platform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportBundleRequest
extends MobileRequest
implements ToCopyableBuilder<Builder, ExportBundleRequest> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(ExportBundleRequest.getter(ExportBundleRequest::bundleId)).setter(ExportBundleRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("bundleId").build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(ExportBundleRequest.getter(ExportBundleRequest::projectId)).setter(ExportBundleRequest.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectId").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(ExportBundleRequest.getter(ExportBundleRequest::platformAsString)).setter(ExportBundleRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("platform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD, PROJECT_ID_FIELD, PLATFORM_FIELD));
    private final String bundleId;
    private final String projectId;
    private final String platform;

    private ExportBundleRequest(BuilderImpl builder) {
        super(builder);
        this.bundleId = builder.bundleId;
        this.projectId = builder.projectId;
        this.platform = builder.platform;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String projectId() {
        return this.projectId;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportBundleRequest)) {
            return false;
        }
        ExportBundleRequest other = (ExportBundleRequest)((Object)obj);
        return Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.platformAsString(), other.platformAsString());
    }

    public String toString() {
        return ToString.builder((String)"ExportBundleRequest").add("BundleId", (Object)this.bundleId()).add("ProjectId", (Object)this.projectId()).add("Platform", (Object)this.platformAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportBundleRequest, T> g) {
        return obj -> g.apply((ExportBundleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MobileRequest.BuilderImpl
    implements Builder {
        private String bundleId;
        private String projectId;
        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportBundleRequest model) {
            super(model);
            this.bundleId(model.bundleId);
            this.projectId(model.projectId);
            this.platform(model.platform);
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportBundleRequest build() {
            return new ExportBundleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MobileRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportBundleRequest> {
        public Builder bundleId(String var1);

        public Builder projectId(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

