/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mobile.model.Platform;
import software.amazon.awssdk.services.mobile.model.PlatformsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BundleDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BundleDetails> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(BundleDetails.getter(BundleDetails::bundleId)).setter(BundleDetails.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(BundleDetails.getter(BundleDetails::title)).setter(BundleDetails.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(BundleDetails.getter(BundleDetails::version)).setter(BundleDetails.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(BundleDetails.getter(BundleDetails::description)).setter(BundleDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iconUrl").getter(BundleDetails.getter(BundleDetails::iconUrl)).setter(BundleDetails.setter(Builder::iconUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iconUrl").build()}).build();
    private static final SdkField<List<String>> AVAILABLE_PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("availablePlatforms").getter(BundleDetails.getter(BundleDetails::availablePlatformsAsStrings)).setter(BundleDetails.setter(Builder::availablePlatformsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availablePlatforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD, TITLE_FIELD, VERSION_FIELD, DESCRIPTION_FIELD, ICON_URL_FIELD, AVAILABLE_PLATFORMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bundleId;
    private final String title;
    private final String version;
    private final String description;
    private final String iconUrl;
    private final List<String> availablePlatforms;

    private BundleDetails(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.title = builder.title;
        this.version = builder.version;
        this.description = builder.description;
        this.iconUrl = builder.iconUrl;
        this.availablePlatforms = builder.availablePlatforms;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String title() {
        return this.title;
    }

    public String version() {
        return this.version;
    }

    public String description() {
        return this.description;
    }

    public String iconUrl() {
        return this.iconUrl;
    }

    public List<Platform> availablePlatforms() {
        return PlatformsCopier.copyStringToEnum(this.availablePlatforms);
    }

    public boolean hasAvailablePlatforms() {
        return this.availablePlatforms != null && !(this.availablePlatforms instanceof SdkAutoConstructList);
    }

    public List<String> availablePlatformsAsStrings() {
        return this.availablePlatforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailablePlatforms() ? this.availablePlatformsAsStrings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleDetails)) {
            return false;
        }
        BundleDetails other = (BundleDetails)obj;
        return Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.iconUrl(), other.iconUrl()) && this.hasAvailablePlatforms() == other.hasAvailablePlatforms() && Objects.equals(this.availablePlatformsAsStrings(), other.availablePlatformsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"BundleDetails").add("BundleId", (Object)this.bundleId()).add("Title", (Object)this.title()).add("Version", (Object)this.version()).add("Description", (Object)this.description()).add("IconUrl", (Object)this.iconUrl()).add("AvailablePlatforms", this.hasAvailablePlatforms() ? this.availablePlatformsAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "iconUrl": {
                return Optional.ofNullable(clazz.cast(this.iconUrl()));
            }
            case "availablePlatforms": {
                return Optional.ofNullable(clazz.cast(this.availablePlatformsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BundleDetails, T> g) {
        return obj -> g.apply((BundleDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bundleId;
        private String title;
        private String version;
        private String description;
        private String iconUrl;
        private List<String> availablePlatforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BundleDetails model) {
            this.bundleId(model.bundleId);
            this.title(model.title);
            this.version(model.version);
            this.description(model.description);
            this.iconUrl(model.iconUrl);
            this.availablePlatformsWithStrings(model.availablePlatforms);
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getIconUrl() {
            return this.iconUrl;
        }

        @Override
        public final Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public final void setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
        }

        public final Collection<String> getAvailablePlatforms() {
            if (this.availablePlatforms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availablePlatforms;
        }

        @Override
        public final Builder availablePlatformsWithStrings(Collection<String> availablePlatforms) {
            this.availablePlatforms = PlatformsCopier.copy(availablePlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availablePlatformsWithStrings(String ... availablePlatforms) {
            this.availablePlatformsWithStrings(Arrays.asList(availablePlatforms));
            return this;
        }

        @Override
        public final Builder availablePlatforms(Collection<Platform> availablePlatforms) {
            this.availablePlatforms = PlatformsCopier.copyEnumToString(availablePlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availablePlatforms(Platform ... availablePlatforms) {
            this.availablePlatforms(Arrays.asList(availablePlatforms));
            return this;
        }

        public final void setAvailablePlatforms(Collection<String> availablePlatforms) {
            this.availablePlatforms = PlatformsCopier.copy(availablePlatforms);
        }

        public BundleDetails build() {
            return new BundleDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BundleDetails> {
        public Builder bundleId(String var1);

        public Builder title(String var1);

        public Builder version(String var1);

        public Builder description(String var1);

        public Builder iconUrl(String var1);

        public Builder availablePlatformsWithStrings(Collection<String> var1);

        public Builder availablePlatformsWithStrings(String ... var1);

        public Builder availablePlatforms(Collection<Platform> var1);

        public Builder availablePlatforms(Platform ... var1);
    }
}

