/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.mobile.model.CreateProjectRequest;
import software.amazon.awssdk.services.mobile.model.CreateProjectResponse;
import software.amazon.awssdk.services.mobile.model.DeleteProjectRequest;
import software.amazon.awssdk.services.mobile.model.DeleteProjectResponse;
import software.amazon.awssdk.services.mobile.model.DescribeBundleRequest;
import software.amazon.awssdk.services.mobile.model.DescribeBundleResponse;
import software.amazon.awssdk.services.mobile.model.DescribeProjectRequest;
import software.amazon.awssdk.services.mobile.model.DescribeProjectResponse;
import software.amazon.awssdk.services.mobile.model.ExportBundleRequest;
import software.amazon.awssdk.services.mobile.model.ExportBundleResponse;
import software.amazon.awssdk.services.mobile.model.ExportProjectRequest;
import software.amazon.awssdk.services.mobile.model.ExportProjectResponse;
import software.amazon.awssdk.services.mobile.model.ListBundlesRequest;
import software.amazon.awssdk.services.mobile.model.ListBundlesResponse;
import software.amazon.awssdk.services.mobile.model.ListProjectsRequest;
import software.amazon.awssdk.services.mobile.model.ListProjectsResponse;
import software.amazon.awssdk.services.mobile.model.UpdateProjectRequest;
import software.amazon.awssdk.services.mobile.model.UpdateProjectResponse;
import software.amazon.awssdk.services.mobile.paginators.ListBundlesPublisher;
import software.amazon.awssdk.services.mobile.paginators.ListProjectsPublisher;

/**
 * Service client for accessing AWS Mobile asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AWS Mobile Service provides mobile app and website developers with capabilities required to configure AWS resources
 * and bootstrap their developer desktop projects with the necessary SDKs, constants, tools and samples to make use of
 * those resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface MobileAsyncClient extends SdkClient {
    String SERVICE_NAME = "AWSMobileHubService";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mobile";

    /**
     * Create a {@link MobileAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MobileAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MobileAsyncClient}.
     */
    static MobileAsyncClientBuilder builder() {
        return new DefaultMobileAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates an AWS Mobile Hub project.
     * </p>
     *
     * @param createProjectRequest
     *        Request structure used to request a project be created.
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>LimitExceededException There are too many AWS Mobile Hub projects in the account or the account has
     *         exceeded the maximum number of resources in some AWS service. You should create another sub-account using
     *         AWS Organizations or remove some resources and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Mobile Hub project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on {@link CreateProjectRequest.Builder} to create a request.
     *        Request structure used to request a project be created.
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>LimitExceededException There are too many AWS Mobile Hub projects in the account or the account has
     *         exceeded the maximum number of resources in some AWS service. You should create another sub-account using
     *         AWS Organizations or remove some resources and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Delets a project in AWS Mobile Hub.
     * </p>
     *
     * @param deleteProjectRequest
     *        Request structure used to request a project be deleted.
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delets a project in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProjectRequest.Builder} to create a request.
     *        Request structure used to request a project be deleted.
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Get the bundle details for the requested bundle id.
     * </p>
     *
     * @param describeBundleRequest
     *        Request structure to request the details of a specific bundle.
     * @return A Java Future containing the result of the DescribeBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.DescribeBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBundleResponse> describeBundle(DescribeBundleRequest describeBundleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the bundle details for the requested bundle id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBundleRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBundleRequest#builder()}
     * </p>
     *
     * @param describeBundleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBundleRequest.Builder} to create a request.
     *        Request structure to request the details of a specific bundle.
     * @return A Java Future containing the result of the DescribeBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.DescribeBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBundleResponse> describeBundle(Consumer<DescribeBundleRequest.Builder> describeBundleRequest) {
        return describeBundle(DescribeBundleRequest.builder().applyMutation(describeBundleRequest).build());
    }

    /**
     * <p>
     * Gets details about a project in AWS Mobile Hub.
     * </p>
     *
     * @param describeProjectRequest
     *        Request structure used to request details about a project.
     * @return A Java Future containing the result of the DescribeProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeProjectResponse> describeProject(DescribeProjectRequest describeProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a project in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProjectRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProjectRequest#builder()}
     * </p>
     *
     * @param describeProjectRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProjectRequest.Builder} to create a request.
     *        Request structure used to request details about a project.
     * @return A Java Future containing the result of the DescribeProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeProjectResponse> describeProject(
            Consumer<DescribeProjectRequest.Builder> describeProjectRequest) {
        return describeProject(DescribeProjectRequest.builder().applyMutation(describeProjectRequest).build());
    }

    /**
     * <p>
     * Generates customized software development kit (SDK) and or tool packages used to integrate mobile web or mobile
     * app clients with backend AWS resources.
     * </p>
     *
     * @param exportBundleRequest
     *        Request structure used to request generation of custom SDK and tool packages required to integrate mobile
     *        web or app clients with backed AWS resources.
     * @return A Java Future containing the result of the ExportBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ExportBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExportBundleResponse> exportBundle(ExportBundleRequest exportBundleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates customized software development kit (SDK) and or tool packages used to integrate mobile web or mobile
     * app clients with backend AWS resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportBundleRequest.Builder} avoiding the need to
     * create one manually via {@link ExportBundleRequest#builder()}
     * </p>
     *
     * @param exportBundleRequest
     *        A {@link Consumer} that will call methods on {@link ExportBundleRequest.Builder} to create a request.
     *        Request structure used to request generation of custom SDK and tool packages required to integrate mobile
     *        web or app clients with backed AWS resources.
     * @return A Java Future containing the result of the ExportBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ExportBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExportBundleResponse> exportBundle(Consumer<ExportBundleRequest.Builder> exportBundleRequest) {
        return exportBundle(ExportBundleRequest.builder().applyMutation(exportBundleRequest).build());
    }

    /**
     * <p>
     * Exports project configuration to a snapshot which can be downloaded and shared. Note that mobile app push
     * credentials are encrypted in exported projects, so they can only be shared successfully within the same AWS
     * account.
     * </p>
     *
     * @param exportProjectRequest
     *        Request structure used in requests to export project configuration details.
     * @return A Java Future containing the result of the ExportProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ExportProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExportProjectResponse> exportProject(ExportProjectRequest exportProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports project configuration to a snapshot which can be downloaded and shared. Note that mobile app push
     * credentials are encrypted in exported projects, so they can only be shared successfully within the same AWS
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportProjectRequest.Builder} avoiding the need to
     * create one manually via {@link ExportProjectRequest#builder()}
     * </p>
     *
     * @param exportProjectRequest
     *        A {@link Consumer} that will call methods on {@link ExportProjectRequest.Builder} to create a request.
     *        Request structure used in requests to export project configuration details.
     * @return A Java Future containing the result of the ExportProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ExportProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExportProjectResponse> exportProject(Consumer<ExportProjectRequest.Builder> exportProjectRequest) {
        return exportProject(ExportProjectRequest.builder().applyMutation(exportProjectRequest).build());
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     *
     * @param listBundlesRequest
     *        Request structure to request all available bundles.
     * @return A Java Future containing the result of the ListBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBundlesResponse> listBundles(ListBundlesRequest listBundlesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBundlesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBundlesRequest#builder()}
     * </p>
     *
     * @param listBundlesRequest
     *        A {@link Consumer} that will call methods on {@link ListBundlesRequest.Builder} to create a request.
     *        Request structure to request all available bundles.
     * @return A Java Future containing the result of the ListBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBundlesResponse> listBundles(Consumer<ListBundlesRequest.Builder> listBundlesRequest) {
        return listBundles(ListBundlesRequest.builder().applyMutation(listBundlesRequest).build());
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     *
     * @return A Java Future containing the result of the ListBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBundlesResponse> listBundles() {
        return listBundles(ListBundlesRequest.builder().build());
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesPublisher publisher = client.listBundlesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesPublisher publisher = client.listBundlesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mobile.model.ListBundlesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mobile.model.ListBundlesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBundlesPublisher listBundlesPaginator() {
        return listBundlesPaginator(ListBundlesRequest.builder().build());
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesPublisher publisher = client.listBundlesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesPublisher publisher = client.listBundlesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mobile.model.ListBundlesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mobile.model.ListBundlesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)} operation.</b>
     * </p>
     *
     * @param listBundlesRequest
     *        Request structure to request all available bundles.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBundlesPublisher listBundlesPaginator(ListBundlesRequest listBundlesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesPublisher publisher = client.listBundlesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesPublisher publisher = client.listBundlesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mobile.model.ListBundlesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mobile.model.ListBundlesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBundlesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBundlesRequest#builder()}
     * </p>
     *
     * @param listBundlesRequest
     *        A {@link Consumer} that will call methods on {@link ListBundlesRequest.Builder} to create a request.
     *        Request structure to request all available bundles.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBundlesPublisher listBundlesPaginator(Consumer<ListBundlesRequest.Builder> listBundlesRequest) {
        return listBundlesPaginator(ListBundlesRequest.builder().applyMutation(listBundlesRequest).build());
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     *
     * @param listProjectsRequest
     *        Request structure used to request projects list in AWS Mobile Hub.
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     *        Request structure used to request projects list in AWS Mobile Hub.
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     *
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects() {
        return listProjects(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mobile.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mobile.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator() {
        return listProjectsPaginator(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mobile.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mobile.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     *        Request structure used to request projects list in AWS Mobile Hub.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mobile.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mobile.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     *        Request structure used to request projects list in AWS Mobile Hub.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Update an existing project.
     * </p>
     *
     * @param updateProjectRequest
     *        Request structure used for requests to update project configuration.
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>AccountActionRequiredException Account Action is required in order to continue the request.</li>
     *         <li>LimitExceededException There are too many AWS Mobile Hub projects in the account or the account has
     *         exceeded the maximum number of resources in some AWS service. You should create another sub-account using
     *         AWS Organizations or remove some resources and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProjectResponse> updateProject(UpdateProjectRequest updateProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProjectRequest.Builder} to create a request.
     *        Request structure used for requests to update project configuration.
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException The service has encountered an unexpected error condition which prevents it
     *         from servicing the request.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable. The request should be retried
     *         after some time delay.</li>
     *         <li>UnauthorizedException Credentials of the caller are insufficient to authorize the request.</li>
     *         <li>TooManyRequestsException Too many requests have been received for this AWS account in too short a
     *         time. The request should be retried after some time delay.</li>
     *         <li>BadRequestException The request cannot be processed because some parameter is not valid or the
     *         project state prevents the operation from being performed.</li>
     *         <li>NotFoundException No entity can be found with the specified identifier.</li>
     *         <li>AccountActionRequiredException Account Action is required in order to continue the request.</li>
     *         <li>LimitExceededException There are too many AWS Mobile Hub projects in the account or the account has
     *         exceeded the maximum number of resources in some AWS service. You should create another sub-account using
     *         AWS Organizations or remove some resources and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MobileException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MobileAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProjectResponse> updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest) {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }
}
