/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mobile.model.AccountActionRequiredException;
import software.amazon.awssdk.services.mobile.model.BadRequestException;
import software.amazon.awssdk.services.mobile.model.CreateProjectRequest;
import software.amazon.awssdk.services.mobile.model.CreateProjectResponse;
import software.amazon.awssdk.services.mobile.model.DeleteProjectRequest;
import software.amazon.awssdk.services.mobile.model.DeleteProjectResponse;
import software.amazon.awssdk.services.mobile.model.DescribeBundleRequest;
import software.amazon.awssdk.services.mobile.model.DescribeBundleResponse;
import software.amazon.awssdk.services.mobile.model.DescribeProjectRequest;
import software.amazon.awssdk.services.mobile.model.DescribeProjectResponse;
import software.amazon.awssdk.services.mobile.model.ExportBundleRequest;
import software.amazon.awssdk.services.mobile.model.ExportBundleResponse;
import software.amazon.awssdk.services.mobile.model.ExportProjectRequest;
import software.amazon.awssdk.services.mobile.model.ExportProjectResponse;
import software.amazon.awssdk.services.mobile.model.InternalFailureException;
import software.amazon.awssdk.services.mobile.model.LimitExceededException;
import software.amazon.awssdk.services.mobile.model.ListBundlesRequest;
import software.amazon.awssdk.services.mobile.model.ListBundlesResponse;
import software.amazon.awssdk.services.mobile.model.ListProjectsRequest;
import software.amazon.awssdk.services.mobile.model.ListProjectsResponse;
import software.amazon.awssdk.services.mobile.model.MobileException;
import software.amazon.awssdk.services.mobile.model.NotFoundException;
import software.amazon.awssdk.services.mobile.model.ServiceUnavailableException;
import software.amazon.awssdk.services.mobile.model.TooManyRequestsException;
import software.amazon.awssdk.services.mobile.model.UnauthorizedException;
import software.amazon.awssdk.services.mobile.model.UpdateProjectRequest;
import software.amazon.awssdk.services.mobile.model.UpdateProjectResponse;
import software.amazon.awssdk.services.mobile.paginators.ListBundlesIterable;
import software.amazon.awssdk.services.mobile.paginators.ListProjectsIterable;

/**
 * Service client for accessing AWS Mobile. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Mobile Service provides mobile app and website developers with capabilities required to configure AWS resources
 * and bootstrap their developer desktop projects with the necessary SDKs, constants, tools and samples to make use of
 * those resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface MobileClient extends SdkClient {
    String SERVICE_NAME = "AWSMobileHubService";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mobile";

    /**
     * Create a {@link MobileClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MobileClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MobileClient}.
     */
    static MobileClientBuilder builder() {
        return new DefaultMobileClientBuilder();
    }

    /**
     * <p>
     * Creates an AWS Mobile Hub project.
     * </p>
     *
     * @param createProjectRequest
     *        Request structure used to request a project be created.
     * @return Result of the CreateProject operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws LimitExceededException
     *         There are too many AWS Mobile Hub projects in the account or the account has exceeded the maximum number
     *         of resources in some AWS service. You should create another sub-account using AWS Organizations or remove
     *         some resources and retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws InternalFailureException,
            ServiceUnavailableException, UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Mobile Hub project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on {@link CreateProjectRequest.Builder} to create a request.
     *        Request structure used to request a project be created.
     * @return Result of the CreateProject operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws LimitExceededException
     *         There are too many AWS Mobile Hub projects in the account or the account has exceeded the maximum number
     *         of resources in some AWS service. You should create another sub-account using AWS Organizations or remove
     *         some resources and retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException,
            MobileException {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Delets a project in AWS Mobile Hub.
     * </p>
     *
     * @param deleteProjectRequest
     *        Request structure used to request a project be deleted.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws InternalFailureException,
            ServiceUnavailableException, UnauthorizedException, TooManyRequestsException, NotFoundException, AwsServiceException,
            SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delets a project in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProjectRequest.Builder} to create a request.
     *        Request structure used to request a project be deleted.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            NotFoundException, AwsServiceException, SdkClientException, MobileException {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Get the bundle details for the requested bundle id.
     * </p>
     *
     * @param describeBundleRequest
     *        Request structure to request the details of a specific bundle.
     * @return Result of the DescribeBundle operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.DescribeBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBundleResponse describeBundle(DescribeBundleRequest describeBundleRequest) throws InternalFailureException,
            ServiceUnavailableException, UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException,
            AwsServiceException, SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the bundle details for the requested bundle id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBundleRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBundleRequest#builder()}
     * </p>
     *
     * @param describeBundleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBundleRequest.Builder} to create a request.
     *        Request structure to request the details of a specific bundle.
     * @return Result of the DescribeBundle operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.DescribeBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBundleResponse describeBundle(Consumer<DescribeBundleRequest.Builder> describeBundleRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, NotFoundException, AwsServiceException, SdkClientException, MobileException {
        return describeBundle(DescribeBundleRequest.builder().applyMutation(describeBundleRequest).build());
    }

    /**
     * <p>
     * Gets details about a project in AWS Mobile Hub.
     * </p>
     *
     * @param describeProjectRequest
     *        Request structure used to request details about a project.
     * @return Result of the DescribeProject operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, NotFoundException, AwsServiceException, SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a project in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProjectRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProjectRequest#builder()}
     * </p>
     *
     * @param describeProjectRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProjectRequest.Builder} to create a request.
     *        Request structure used to request details about a project.
     * @return Result of the DescribeProject operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProjectResponse describeProject(Consumer<DescribeProjectRequest.Builder> describeProjectRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, NotFoundException, AwsServiceException, SdkClientException, MobileException {
        return describeProject(DescribeProjectRequest.builder().applyMutation(describeProjectRequest).build());
    }

    /**
     * <p>
     * Generates customized software development kit (SDK) and or tool packages used to integrate mobile web or mobile
     * app clients with backend AWS resources.
     * </p>
     *
     * @param exportBundleRequest
     *        Request structure used to request generation of custom SDK and tool packages required to integrate mobile
     *        web or app clients with backed AWS resources.
     * @return Result of the ExportBundle operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ExportBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportBundleResponse exportBundle(ExportBundleRequest exportBundleRequest) throws InternalFailureException,
            ServiceUnavailableException, UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException,
            AwsServiceException, SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates customized software development kit (SDK) and or tool packages used to integrate mobile web or mobile
     * app clients with backend AWS resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportBundleRequest.Builder} avoiding the need to
     * create one manually via {@link ExportBundleRequest#builder()}
     * </p>
     *
     * @param exportBundleRequest
     *        A {@link Consumer} that will call methods on {@link ExportBundleRequest.Builder} to create a request.
     *        Request structure used to request generation of custom SDK and tool packages required to integrate mobile
     *        web or app clients with backed AWS resources.
     * @return Result of the ExportBundle operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ExportBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportBundleResponse exportBundle(Consumer<ExportBundleRequest.Builder> exportBundleRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, NotFoundException, AwsServiceException, SdkClientException, MobileException {
        return exportBundle(ExportBundleRequest.builder().applyMutation(exportBundleRequest).build());
    }

    /**
     * <p>
     * Exports project configuration to a snapshot which can be downloaded and shared. Note that mobile app push
     * credentials are encrypted in exported projects, so they can only be shared successfully within the same AWS
     * account.
     * </p>
     *
     * @param exportProjectRequest
     *        Request structure used in requests to export project configuration details.
     * @return Result of the ExportProject operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ExportProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportProject" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportProjectResponse exportProject(ExportProjectRequest exportProjectRequest) throws InternalFailureException,
            ServiceUnavailableException, UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException,
            AwsServiceException, SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports project configuration to a snapshot which can be downloaded and shared. Note that mobile app push
     * credentials are encrypted in exported projects, so they can only be shared successfully within the same AWS
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportProjectRequest.Builder} avoiding the need to
     * create one manually via {@link ExportProjectRequest#builder()}
     * </p>
     *
     * @param exportProjectRequest
     *        A {@link Consumer} that will call methods on {@link ExportProjectRequest.Builder} to create a request.
     *        Request structure used in requests to export project configuration details.
     * @return Result of the ExportProject operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ExportProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ExportProject" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportProjectResponse exportProject(Consumer<ExportProjectRequest.Builder> exportProjectRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, NotFoundException, AwsServiceException, SdkClientException, MobileException {
        return exportProject(ExportProjectRequest.builder().applyMutation(exportProjectRequest).build());
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     *
     * @return Result of the ListBundles operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListBundles
     * @see #listBundles(ListBundlesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBundlesResponse listBundles() throws InternalFailureException, ServiceUnavailableException,
            UnauthorizedException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            MobileException {
        return listBundles(ListBundlesRequest.builder().build());
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     *
     * @param listBundlesRequest
     *        Request structure to request all available bundles.
     * @return Result of the ListBundles operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBundlesResponse listBundles(ListBundlesRequest listBundlesRequest) throws InternalFailureException,
            ServiceUnavailableException, UnauthorizedException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBundlesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBundlesRequest#builder()}
     * </p>
     *
     * @param listBundlesRequest
     *        A {@link Consumer} that will call methods on {@link ListBundlesRequest.Builder} to create a request.
     *        Request structure to request all available bundles.
     * @return Result of the ListBundles operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBundlesResponse listBundles(Consumer<ListBundlesRequest.Builder> listBundlesRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, MobileException {
        return listBundles(ListBundlesRequest.builder().applyMutation(listBundlesRequest).build());
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesIterable responses = client.listBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mobile.paginators.ListBundlesIterable responses = client.listBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.mobile.model.ListBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesIterable responses = client.listBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListBundles
     * @see #listBundlesPaginator(ListBundlesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBundlesIterable listBundlesPaginator() throws InternalFailureException, ServiceUnavailableException,
            UnauthorizedException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            MobileException {
        return listBundlesPaginator(ListBundlesRequest.builder().build());
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesIterable responses = client.listBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mobile.paginators.ListBundlesIterable responses = client.listBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.mobile.model.ListBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesIterable responses = client.listBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)} operation.</b>
     * </p>
     *
     * @param listBundlesRequest
     *        Request structure to request all available bundles.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBundlesIterable listBundlesPaginator(ListBundlesRequest listBundlesRequest) throws InternalFailureException,
            ServiceUnavailableException, UnauthorizedException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all available bundles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesIterable responses = client.listBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mobile.paginators.ListBundlesIterable responses = client.listBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.mobile.model.ListBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListBundlesIterable responses = client.listBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBundles(software.amazon.awssdk.services.mobile.model.ListBundlesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBundlesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBundlesRequest#builder()}
     * </p>
     *
     * @param listBundlesRequest
     *        A {@link Consumer} that will call methods on {@link ListBundlesRequest.Builder} to create a request.
     *        Request structure to request all available bundles.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBundlesIterable listBundlesPaginator(Consumer<ListBundlesRequest.Builder> listBundlesRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, MobileException {
        return listBundlesPaginator(ListBundlesRequest.builder().applyMutation(listBundlesRequest).build());
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     *
     * @return Result of the ListProjects operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListProjects
     * @see #listProjects(ListProjectsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects() throws InternalFailureException, ServiceUnavailableException,
            UnauthorizedException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            MobileException {
        return listProjects(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     *
     * @param listProjectsRequest
     *        Request structure used to request projects list in AWS Mobile Hub.
     * @return Result of the ListProjects operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InternalFailureException,
            ServiceUnavailableException, UnauthorizedException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     *        Request structure used to request projects list in AWS Mobile Hub.
     * @return Result of the ListProjects operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsResponse listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, MobileException {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mobile.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.mobile.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListProjects
     * @see #listProjectsPaginator(ListProjectsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator() throws InternalFailureException, ServiceUnavailableException,
            UnauthorizedException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            MobileException {
        return listProjectsPaginator(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mobile.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.mobile.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     *        Request structure used to request projects list in AWS Mobile Hub.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws InternalFailureException,
            ServiceUnavailableException, UnauthorizedException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists projects in AWS Mobile Hub.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mobile.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.mobile.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mobile.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.mobile.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     *        Request structure used to request projects list in AWS Mobile Hub.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, AwsServiceException, SdkClientException, MobileException {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Update an existing project.
     * </p>
     *
     * @param updateProjectRequest
     *        Request structure used for requests to update project configuration.
     * @return Result of the UpdateProject operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws AccountActionRequiredException
     *         Account Action is required in order to continue the request.
     * @throws LimitExceededException
     *         There are too many AWS Mobile Hub projects in the account or the account has exceeded the maximum number
     *         of resources in some AWS service. You should create another sub-account using AWS Organizations or remove
     *         some resources and retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws InternalFailureException,
            ServiceUnavailableException, UnauthorizedException, TooManyRequestsException, BadRequestException, NotFoundException,
            AccountActionRequiredException, LimitExceededException, AwsServiceException, SdkClientException, MobileException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProjectRequest.Builder} to create a request.
     *        Request structure used for requests to update project configuration.
     * @return Result of the UpdateProject operation returned by the service.
     * @throws InternalFailureException
     *         The service has encountered an unexpected error condition which prevents it from servicing the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable. The request should be retried after some time delay.
     * @throws UnauthorizedException
     *         Credentials of the caller are insufficient to authorize the request.
     * @throws TooManyRequestsException
     *         Too many requests have been received for this AWS account in too short a time. The request should be
     *         retried after some time delay.
     * @throws BadRequestException
     *         The request cannot be processed because some parameter is not valid or the project state prevents the
     *         operation from being performed.
     * @throws NotFoundException
     *         No entity can be found with the specified identifier.
     * @throws AccountActionRequiredException
     *         Account Action is required in order to continue the request.
     * @throws LimitExceededException
     *         There are too many AWS Mobile Hub projects in the account or the account has exceeded the maximum number
     *         of resources in some AWS service. You should create another sub-account using AWS Organizations or remove
     *         some resources and retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MobileException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MobileClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mobile-2017-07-01/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProjectResponse updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest)
            throws InternalFailureException, ServiceUnavailableException, UnauthorizedException, TooManyRequestsException,
            BadRequestException, NotFoundException, AccountActionRequiredException, LimitExceededException, AwsServiceException,
            SdkClientException, MobileException {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
