/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mobile.model.MobileResponse;
import software.amazon.awssdk.services.mobile.model.Resource;
import software.amazon.awssdk.services.mobile.model.ResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProjectResponse
extends MobileResponse
implements ToCopyableBuilder<Builder, DeleteProjectResponse> {
    private static final SdkField<List<Resource>> DELETED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deletedResources").getter(DeleteProjectResponse.getter(DeleteProjectResponse::deletedResources)).setter(DeleteProjectResponse.setter(Builder::deletedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Resource>> ORPHANED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orphanedResources").getter(DeleteProjectResponse.getter(DeleteProjectResponse::orphanedResources)).setter(DeleteProjectResponse.setter(Builder::orphanedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orphanedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_RESOURCES_FIELD, ORPHANED_RESOURCES_FIELD));
    private final List<Resource> deletedResources;
    private final List<Resource> orphanedResources;

    private DeleteProjectResponse(BuilderImpl builder) {
        super(builder);
        this.deletedResources = builder.deletedResources;
        this.orphanedResources = builder.orphanedResources;
    }

    public final boolean hasDeletedResources() {
        return this.deletedResources != null && !(this.deletedResources instanceof SdkAutoConstructList);
    }

    public final List<Resource> deletedResources() {
        return this.deletedResources;
    }

    public final boolean hasOrphanedResources() {
        return this.orphanedResources != null && !(this.orphanedResources instanceof SdkAutoConstructList);
    }

    public final List<Resource> orphanedResources() {
        return this.orphanedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeletedResources() ? this.deletedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrphanedResources() ? this.orphanedResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProjectResponse)) {
            return false;
        }
        DeleteProjectResponse other = (DeleteProjectResponse)((Object)obj);
        return this.hasDeletedResources() == other.hasDeletedResources() && Objects.equals(this.deletedResources(), other.deletedResources()) && this.hasOrphanedResources() == other.hasOrphanedResources() && Objects.equals(this.orphanedResources(), other.orphanedResources());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteProjectResponse").add("DeletedResources", this.hasDeletedResources() ? this.deletedResources() : null).add("OrphanedResources", this.hasOrphanedResources() ? this.orphanedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deletedResources": {
                return Optional.ofNullable(clazz.cast(this.deletedResources()));
            }
            case "orphanedResources": {
                return Optional.ofNullable(clazz.cast(this.orphanedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProjectResponse, T> g) {
        return obj -> g.apply((DeleteProjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MobileResponse.BuilderImpl
    implements Builder {
        private List<Resource> deletedResources = DefaultSdkAutoConstructList.getInstance();
        private List<Resource> orphanedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProjectResponse model) {
            super(model);
            this.deletedResources(model.deletedResources);
            this.orphanedResources(model.orphanedResources);
        }

        public final Collection<Resource.Builder> getDeletedResources() {
            if (this.deletedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deletedResources != null ? (Collection)this.deletedResources.stream().map(Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deletedResources(Collection<Resource> deletedResources) {
            this.deletedResources = ResourcesCopier.copy(deletedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedResources(Resource ... deletedResources) {
            this.deletedResources(Arrays.asList(deletedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedResources(Consumer<Resource.Builder> ... deletedResources) {
            this.deletedResources(Stream.of(deletedResources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeletedResources(Collection<Resource.BuilderImpl> deletedResources) {
            this.deletedResources = ResourcesCopier.copyFromBuilder(deletedResources);
        }

        public final Collection<Resource.Builder> getOrphanedResources() {
            if (this.orphanedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.orphanedResources != null ? (Collection)this.orphanedResources.stream().map(Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orphanedResources(Collection<Resource> orphanedResources) {
            this.orphanedResources = ResourcesCopier.copy(orphanedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orphanedResources(Resource ... orphanedResources) {
            this.orphanedResources(Arrays.asList(orphanedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orphanedResources(Consumer<Resource.Builder> ... orphanedResources) {
            this.orphanedResources(Stream.of(orphanedResources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrphanedResources(Collection<Resource.BuilderImpl> orphanedResources) {
            this.orphanedResources = ResourcesCopier.copyFromBuilder(orphanedResources);
        }

        @Override
        public DeleteProjectResponse build() {
            return new DeleteProjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MobileResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteProjectResponse> {
        public Builder deletedResources(Collection<Resource> var1);

        public Builder deletedResources(Resource ... var1);

        public Builder deletedResources(Consumer<Resource.Builder> ... var1);

        public Builder orphanedResources(Collection<Resource> var1);

        public Builder orphanedResources(Resource ... var1);

        public Builder orphanedResources(Consumer<Resource.Builder> ... var1);
    }
}

