/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure contains a list of all available bundles with details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBundlesResponse extends MobileResponse implements
        ToCopyableBuilder<ListBundlesResponse.Builder, ListBundlesResponse> {
    private static final SdkField<List<BundleDetails>> BUNDLE_LIST_FIELD = SdkField
            .<List<BundleDetails>> builder(MarshallingType.LIST)
            .memberName("bundleList")
            .getter(getter(ListBundlesResponse::bundleList))
            .setter(setter(Builder::bundleList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BundleDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(BundleDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBundlesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BundleDetails> bundleList;

    private final String nextToken;

    private ListBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.bundleList = builder.bundleList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BundleList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBundleList() {
        return bundleList != null && !(bundleList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of bundles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBundleList} method.
     * </p>
     * 
     * @return A list of bundles.
     */
    public final List<BundleDetails> bundleList() {
        return bundleList;
    }

    /**
     * <p>
     * Pagination token. If non-null pagination token is returned in a result, then pass its value in another request to
     * fetch more entries.
     * </p>
     * 
     * @return Pagination token. If non-null pagination token is returned in a result, then pass its value in another
     *         request to fetch more entries.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBundleList() ? bundleList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBundlesResponse)) {
            return false;
        }
        ListBundlesResponse other = (ListBundlesResponse) obj;
        return hasBundleList() == other.hasBundleList() && Objects.equals(bundleList(), other.bundleList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBundlesResponse").add("BundleList", hasBundleList() ? bundleList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bundleList":
            return Optional.ofNullable(clazz.cast(bundleList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBundlesResponse, T> g) {
        return obj -> g.apply((ListBundlesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MobileResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBundlesResponse> {
        /**
         * <p>
         * A list of bundles.
         * </p>
         * 
         * @param bundleList
         *        A list of bundles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleList(Collection<BundleDetails> bundleList);

        /**
         * <p>
         * A list of bundles.
         * </p>
         * 
         * @param bundleList
         *        A list of bundles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleList(BundleDetails... bundleList);

        /**
         * <p>
         * A list of bundles.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<BundleDetails>.Builder} avoiding the
         * need to create one manually via {@link List<BundleDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BundleDetails>.Builder#build()} is called immediately and
         * its result is passed to {@link #bundleList(List<BundleDetails>)}.
         * 
         * @param bundleList
         *        a consumer that will call methods on {@link List<BundleDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bundleList(List<BundleDetails>)
         */
        Builder bundleList(Consumer<BundleDetails.Builder>... bundleList);

        /**
         * <p>
         * Pagination token. If non-null pagination token is returned in a result, then pass its value in another
         * request to fetch more entries.
         * </p>
         * 
         * @param nextToken
         *        Pagination token. If non-null pagination token is returned in a result, then pass its value in another
         *        request to fetch more entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MobileResponse.BuilderImpl implements Builder {
        private List<BundleDetails> bundleList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBundlesResponse model) {
            super(model);
            bundleList(model.bundleList);
            nextToken(model.nextToken);
        }

        public final List<BundleDetails.Builder> getBundleList() {
            List<BundleDetails.Builder> result = BundleListCopier.copyToBuilder(this.bundleList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBundleList(Collection<BundleDetails.BuilderImpl> bundleList) {
            this.bundleList = BundleListCopier.copyFromBuilder(bundleList);
        }

        @Override
        public final Builder bundleList(Collection<BundleDetails> bundleList) {
            this.bundleList = BundleListCopier.copy(bundleList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleList(BundleDetails... bundleList) {
            bundleList(Arrays.asList(bundleList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleList(Consumer<BundleDetails.Builder>... bundleList) {
            bundleList(Stream.of(bundleList).map(c -> BundleDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBundlesResponse build() {
            return new ListBundlesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
