/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request structure used to request a project be created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectRequest extends MobileRequest implements
        ToCopyableBuilder<CreateProjectRequest.Builder, CreateProjectRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateProjectRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(CreateProjectRequest::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("region").build()).build();

    private static final SdkField<SdkBytes> CONTENTS_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("contents")
            .getter(getter(CreateProjectRequest::contents))
            .setter(setter(Builder::contents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contents").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotId").getter(getter(CreateProjectRequest::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("snapshotId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REGION_FIELD,
            CONTENTS_FIELD, SNAPSHOT_ID_FIELD));

    private final String name;

    private final String region;

    private final SdkBytes contents;

    private final String snapshotId;

    private CreateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.region = builder.region;
        this.contents = builder.contents;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * Name of the project.
     * </p>
     * 
     * @return Name of the project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Default region where project resources should be created.
     * </p>
     * 
     * @return Default region where project resources should be created.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * ZIP or YAML file which contains configuration settings to be used when creating the project. This may be the
     * contents of the file downloaded from the URL provided in an export project operation.
     * </p>
     * 
     * @return ZIP or YAML file which contains configuration settings to be used when creating the project. This may be
     *         the contents of the file downloaded from the URL provided in an export project operation.
     */
    public final SdkBytes contents() {
        return contents;
    }

    /**
     * <p>
     * Unique identifier for an exported snapshot of project configuration. This snapshot identifier is included in the
     * share URL when a project is exported.
     * </p>
     * 
     * @return Unique identifier for an exported snapshot of project configuration. This snapshot identifier is included
     *         in the share URL when a project is exported.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(contents());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(region(), other.region())
                && Objects.equals(contents(), other.contents()) && Objects.equals(snapshotId(), other.snapshotId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProjectRequest").add("Name", name()).add("Region", region()).add("Contents", contents())
                .add("SnapshotId", snapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "contents":
            return Optional.ofNullable(clazz.cast(contents()));
        case "snapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectRequest, T> g) {
        return obj -> g.apply((CreateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MobileRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectRequest> {
        /**
         * <p>
         * Name of the project.
         * </p>
         * 
         * @param name
         *        Name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Default region where project resources should be created.
         * </p>
         * 
         * @param region
         *        Default region where project resources should be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * ZIP or YAML file which contains configuration settings to be used when creating the project. This may be the
         * contents of the file downloaded from the URL provided in an export project operation.
         * </p>
         * 
         * @param contents
         *        ZIP or YAML file which contains configuration settings to be used when creating the project. This may
         *        be the contents of the file downloaded from the URL provided in an export project operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contents(SdkBytes contents);

        /**
         * <p>
         * Unique identifier for an exported snapshot of project configuration. This snapshot identifier is included in
         * the share URL when a project is exported.
         * </p>
         * 
         * @param snapshotId
         *        Unique identifier for an exported snapshot of project configuration. This snapshot identifier is
         *        included in the share URL when a project is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MobileRequest.BuilderImpl implements Builder {
        private String name;

        private String region;

        private SdkBytes contents;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            super(model);
            name(model.name);
            region(model.region);
            contents(model.contents);
            snapshotId(model.snapshotId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final ByteBuffer getContents() {
            return contents == null ? null : contents.asByteBuffer();
        }

        public final void setContents(ByteBuffer contents) {
            contents(contents == null ? null : SdkBytes.fromByteBuffer(contents));
        }

        @Override
        @Transient
        public final Builder contents(SdkBytes contents) {
            this.contents = contents;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
