/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mobile.model.BundleDetails;
import software.amazon.awssdk.services.mobile.model.BundleListCopier;
import software.amazon.awssdk.services.mobile.model.MobileResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBundlesResponse
extends MobileResponse
implements ToCopyableBuilder<Builder, ListBundlesResponse> {
    private static final SdkField<List<BundleDetails>> BUNDLE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bundleList").getter(ListBundlesResponse.getter(ListBundlesResponse::bundleList)).setter(ListBundlesResponse.setter(Builder::bundleList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BundleDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBundlesResponse.getter(ListBundlesResponse::nextToken)).setter(ListBundlesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<BundleDetails> bundleList;
    private final String nextToken;

    private ListBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.bundleList = builder.bundleList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBundleList() {
        return this.bundleList != null && !(this.bundleList instanceof SdkAutoConstructList);
    }

    public final List<BundleDetails> bundleList() {
        return this.bundleList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBundleList() ? this.bundleList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBundlesResponse)) {
            return false;
        }
        ListBundlesResponse other = (ListBundlesResponse)((Object)obj);
        return this.hasBundleList() == other.hasBundleList() && Objects.equals(this.bundleList(), other.bundleList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBundlesResponse").add("BundleList", this.hasBundleList() ? this.bundleList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bundleList": {
                return Optional.ofNullable(clazz.cast(this.bundleList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBundlesResponse, T> g) {
        return obj -> g.apply((ListBundlesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MobileResponse.BuilderImpl
    implements Builder {
        private List<BundleDetails> bundleList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBundlesResponse model) {
            super(model);
            this.bundleList(model.bundleList);
            this.nextToken(model.nextToken);
        }

        public final List<BundleDetails.Builder> getBundleList() {
            List<BundleDetails.Builder> result = BundleListCopier.copyToBuilder(this.bundleList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBundleList(Collection<BundleDetails.BuilderImpl> bundleList) {
            this.bundleList = BundleListCopier.copyFromBuilder(bundleList);
        }

        @Override
        @Transient
        public final Builder bundleList(Collection<BundleDetails> bundleList) {
            this.bundleList = BundleListCopier.copy(bundleList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bundleList(BundleDetails ... bundleList) {
            this.bundleList(Arrays.asList(bundleList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bundleList(Consumer<BundleDetails.Builder> ... bundleList) {
            this.bundleList(Stream.of(bundleList).map(c -> (BundleDetails)((BundleDetails.Builder)BundleDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBundlesResponse build() {
            return new ListBundlesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MobileResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBundlesResponse> {
        public Builder bundleList(Collection<BundleDetails> var1);

        public Builder bundleList(BundleDetails ... var1);

        public Builder bundleList(Consumer<BundleDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

