/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mobile.MobileClient;
import software.amazon.awssdk.services.mobile.internal.UserAgentUtils;
import software.amazon.awssdk.services.mobile.model.ListProjectsRequest;
import software.amazon.awssdk.services.mobile.model.ListProjectsResponse;

public class ListProjectsIterable
implements SdkIterable<ListProjectsResponse> {
    private final MobileClient client;
    private final ListProjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProjectsIterable(MobileClient client, ListProjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProjectsResponseFetcher();
    }

    public Iterator<ListProjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProjectsResponseFetcher
    implements SyncPageFetcher<ListProjectsResponse> {
        private ListProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProjectsResponse nextPage(ListProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListProjectsIterable.this.client.listProjects(ListProjectsIterable.this.firstRequest);
            }
            return ListProjectsIterable.this.client.listProjects((ListProjectsRequest)((Object)ListProjectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

