/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure used in response to request to delete a project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteProjectResponse extends MobileResponse implements
        ToCopyableBuilder<DeleteProjectResponse.Builder, DeleteProjectResponse> {
    private static final SdkField<List<Resource>> DELETED_RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("deletedResources")
            .getter(getter(DeleteProjectResponse::deletedResources))
            .setter(setter(Builder::deletedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Resource>> ORPHANED_RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("orphanedResources")
            .getter(getter(DeleteProjectResponse::orphanedResources))
            .setter(setter(Builder::orphanedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orphanedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_RESOURCES_FIELD,
            ORPHANED_RESOURCES_FIELD));

    private final List<Resource> deletedResources;

    private final List<Resource> orphanedResources;

    private DeleteProjectResponse(BuilderImpl builder) {
        super(builder);
        this.deletedResources = builder.deletedResources;
        this.orphanedResources = builder.orphanedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeletedResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeletedResources() {
        return deletedResources != null && !(deletedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Resources which were deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeletedResources} method.
     * </p>
     * 
     * @return Resources which were deleted.
     */
    public final List<Resource> deletedResources() {
        return deletedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrphanedResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrphanedResources() {
        return orphanedResources != null && !(orphanedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Resources which were not deleted, due to a risk of losing potentially important data or files.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrphanedResources} method.
     * </p>
     * 
     * @return Resources which were not deleted, due to a risk of losing potentially important data or files.
     */
    public final List<Resource> orphanedResources() {
        return orphanedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeletedResources() ? deletedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrphanedResources() ? orphanedResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProjectResponse)) {
            return false;
        }
        DeleteProjectResponse other = (DeleteProjectResponse) obj;
        return hasDeletedResources() == other.hasDeletedResources()
                && Objects.equals(deletedResources(), other.deletedResources())
                && hasOrphanedResources() == other.hasOrphanedResources()
                && Objects.equals(orphanedResources(), other.orphanedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteProjectResponse")
                .add("DeletedResources", hasDeletedResources() ? deletedResources() : null)
                .add("OrphanedResources", hasOrphanedResources() ? orphanedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deletedResources":
            return Optional.ofNullable(clazz.cast(deletedResources()));
        case "orphanedResources":
            return Optional.ofNullable(clazz.cast(orphanedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProjectResponse, T> g) {
        return obj -> g.apply((DeleteProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MobileResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteProjectResponse> {
        /**
         * <p>
         * Resources which were deleted.
         * </p>
         * 
         * @param deletedResources
         *        Resources which were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedResources(Collection<Resource> deletedResources);

        /**
         * <p>
         * Resources which were deleted.
         * </p>
         * 
         * @param deletedResources
         *        Resources which were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedResources(Resource... deletedResources);

        /**
         * <p>
         * Resources which were deleted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mobile.model.Resource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mobile.model.Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mobile.model.Resource.Builder#build()} is called immediately and its
         * result is passed to {@link #deletedResources(List<Resource>)}.
         * 
         * @param deletedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mobile.model.Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletedResources(java.util.Collection<Resource>)
         */
        Builder deletedResources(Consumer<Resource.Builder>... deletedResources);

        /**
         * <p>
         * Resources which were not deleted, due to a risk of losing potentially important data or files.
         * </p>
         * 
         * @param orphanedResources
         *        Resources which were not deleted, due to a risk of losing potentially important data or files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orphanedResources(Collection<Resource> orphanedResources);

        /**
         * <p>
         * Resources which were not deleted, due to a risk of losing potentially important data or files.
         * </p>
         * 
         * @param orphanedResources
         *        Resources which were not deleted, due to a risk of losing potentially important data or files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orphanedResources(Resource... orphanedResources);

        /**
         * <p>
         * Resources which were not deleted, due to a risk of losing potentially important data or files.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mobile.model.Resource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mobile.model.Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mobile.model.Resource.Builder#build()} is called immediately and its
         * result is passed to {@link #orphanedResources(List<Resource>)}.
         * 
         * @param orphanedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mobile.model.Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orphanedResources(java.util.Collection<Resource>)
         */
        Builder orphanedResources(Consumer<Resource.Builder>... orphanedResources);
    }

    static final class BuilderImpl extends MobileResponse.BuilderImpl implements Builder {
        private List<Resource> deletedResources = DefaultSdkAutoConstructList.getInstance();

        private List<Resource> orphanedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProjectResponse model) {
            super(model);
            deletedResources(model.deletedResources);
            orphanedResources(model.orphanedResources);
        }

        public final List<Resource.Builder> getDeletedResources() {
            List<Resource.Builder> result = ResourcesCopier.copyToBuilder(this.deletedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeletedResources(Collection<Resource.BuilderImpl> deletedResources) {
            this.deletedResources = ResourcesCopier.copyFromBuilder(deletedResources);
        }

        @Override
        public final Builder deletedResources(Collection<Resource> deletedResources) {
            this.deletedResources = ResourcesCopier.copy(deletedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedResources(Resource... deletedResources) {
            deletedResources(Arrays.asList(deletedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedResources(Consumer<Resource.Builder>... deletedResources) {
            deletedResources(Stream.of(deletedResources).map(c -> Resource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Resource.Builder> getOrphanedResources() {
            List<Resource.Builder> result = ResourcesCopier.copyToBuilder(this.orphanedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrphanedResources(Collection<Resource.BuilderImpl> orphanedResources) {
            this.orphanedResources = ResourcesCopier.copyFromBuilder(orphanedResources);
        }

        @Override
        public final Builder orphanedResources(Collection<Resource> orphanedResources) {
            this.orphanedResources = ResourcesCopier.copy(orphanedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orphanedResources(Resource... orphanedResources) {
            orphanedResources(Arrays.asList(orphanedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orphanedResources(Consumer<Resource.Builder>... orphanedResources) {
            orphanedResources(Stream.of(orphanedResources).map(c -> Resource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteProjectResponse build() {
            return new DeleteProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
