/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure used for requests of project details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectResponse extends MobileResponse implements
        ToCopyableBuilder<DescribeProjectResponse.Builder, DescribeProjectResponse> {
    private static final SdkField<ProjectDetails> DETAILS_FIELD = SdkField.<ProjectDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeProjectResponse::details)).setter(setter(Builder::details))
            .constructor(ProjectDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_FIELD));

    private final ProjectDetails details;

    private DescribeProjectResponse(BuilderImpl builder) {
        super(builder);
        this.details = builder.details;
    }

    /**
     * Returns the value of the Details property for this object.
     * 
     * @return The value of the Details property for this object.
     */
    public ProjectDetails details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectResponse)) {
            return false;
        }
        DescribeProjectResponse other = (DescribeProjectResponse) obj;
        return Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProjectResponse").add("Details", details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectResponse, T> g) {
        return obj -> g.apply((DescribeProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MobileResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProjectResponse> {
        /**
         * Sets the value of the Details property for this object.
         *
         * @param details
         *        The new value for the Details property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(ProjectDetails details);

        /**
         * Sets the value of the Details property for this object.
         *
         * This is a convenience that creates an instance of the {@link ProjectDetails.Builder} avoiding the need to
         * create one manually via {@link ProjectDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(ProjectDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link ProjectDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(ProjectDetails)
         */
        default Builder details(Consumer<ProjectDetails.Builder> details) {
            return details(ProjectDetails.builder().applyMutation(details).build());
        }
    }

    static final class BuilderImpl extends MobileResponse.BuilderImpl implements Builder {
        private ProjectDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectResponse model) {
            super(model);
            details(model.details);
        }

        public final ProjectDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        @Override
        public final Builder details(ProjectDetails details) {
            this.details = details;
            return this;
        }

        public final void setDetails(ProjectDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public DescribeProjectResponse build() {
            return new DescribeProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
