/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Too many requests have been received for this AWS account in too short a time. The request should be retried after
 * some time delay.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TooManyRequestsException extends MobileException implements
        ToCopyableBuilder<TooManyRequestsException.Builder, TooManyRequestsException> {
    private static final SdkField<String> RETRY_AFTER_SECONDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TooManyRequestsException::retryAfterSeconds)).setter(setter(Builder::retryAfterSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Retry-After").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRY_AFTER_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String retryAfterSeconds;

    private TooManyRequestsException(BuilderImpl builder) {
        super(builder);
        this.retryAfterSeconds = builder.retryAfterSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the RetryAfterSeconds property for this object.
     * 
     * @return The value of the RetryAfterSeconds property for this object.
     */
    public String retryAfterSeconds() {
        return retryAfterSeconds;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TooManyRequestsException, T> g) {
        return obj -> g.apply((TooManyRequestsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TooManyRequestsException>, MobileException.Builder {
        /**
         * Sets the value of the RetryAfterSeconds property for this object.
         *
         * @param retryAfterSeconds
         *        The new value for the RetryAfterSeconds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryAfterSeconds(String retryAfterSeconds);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends MobileException.BuilderImpl implements Builder {
        private String retryAfterSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TooManyRequestsException model) {
            super(model);
            retryAfterSeconds(model.retryAfterSeconds);
        }

        public final String getRetryAfterSeconds() {
            return retryAfterSeconds;
        }

        @Override
        public final Builder retryAfterSeconds(String retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        public final void setRetryAfterSeconds(String retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public TooManyRequestsException build() {
            return new TooManyRequestsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
