/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mpa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mpa.model.ActionCompletionStrategy;
import software.amazon.awssdk.services.mpa.model.SessionStatus;
import software.amazon.awssdk.services.mpa.model.SessionStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSessionsResponseSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListSessionsResponseSession> {
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionArn").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::sessionArn)).setter(ListSessionsResponseSession.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionArn").build()}).build();
    private static final SdkField<String> APPROVAL_TEAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovalTeamName").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::approvalTeamName)).setter(ListSessionsResponseSession.setter(Builder::approvalTeamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalTeamName").build()}).build();
    private static final SdkField<String> APPROVAL_TEAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovalTeamArn").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::approvalTeamArn)).setter(ListSessionsResponseSession.setter(Builder::approvalTeamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalTeamArn").build()}).build();
    private static final SdkField<Instant> INITIATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InitiationTime").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::initiationTime)).setter(ListSessionsResponseSession.setter(Builder::initiationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationTime").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::expirationTime)).setter(ListSessionsResponseSession.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::completionTime)).setter(ListSessionsResponseSession.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::description)).setter(ListSessionsResponseSession.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionName").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::actionName)).setter(ListSessionsResponseSession.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()}).build();
    private static final SdkField<String> PROTECTED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectedResourceArn").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::protectedResourceArn)).setter(ListSessionsResponseSession.setter(Builder::protectedResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceArn").build()}).build();
    private static final SdkField<String> REQUESTER_SERVICE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterServicePrincipal").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::requesterServicePrincipal)).setter(ListSessionsResponseSession.setter(Builder::requesterServicePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterServicePrincipal").build()}).build();
    private static final SdkField<String> REQUESTER_PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterPrincipalArn").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::requesterPrincipalArn)).setter(ListSessionsResponseSession.setter(Builder::requesterPrincipalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPrincipalArn").build()}).build();
    private static final SdkField<String> REQUESTER_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterRegion").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::requesterRegion)).setter(ListSessionsResponseSession.setter(Builder::requesterRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterRegion").build()}).build();
    private static final SdkField<String> REQUESTER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterAccountId").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::requesterAccountId)).setter(ListSessionsResponseSession.setter(Builder::requesterAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAccountId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::statusAsString)).setter(ListSessionsResponseSession.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::statusCodeAsString)).setter(ListSessionsResponseSession.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::statusMessage)).setter(ListSessionsResponseSession.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> ACTION_COMPLETION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionCompletionStrategy").getter(ListSessionsResponseSession.getter(ListSessionsResponseSession::actionCompletionStrategyAsString)).setter(ListSessionsResponseSession.setter(Builder::actionCompletionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionCompletionStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ARN_FIELD, APPROVAL_TEAM_NAME_FIELD, APPROVAL_TEAM_ARN_FIELD, INITIATION_TIME_FIELD, EXPIRATION_TIME_FIELD, COMPLETION_TIME_FIELD, DESCRIPTION_FIELD, ACTION_NAME_FIELD, PROTECTED_RESOURCE_ARN_FIELD, REQUESTER_SERVICE_PRINCIPAL_FIELD, REQUESTER_PRINCIPAL_ARN_FIELD, REQUESTER_REGION_FIELD, REQUESTER_ACCOUNT_ID_FIELD, STATUS_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, ACTION_COMPLETION_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSessionsResponseSession.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sessionArn;
    private final String approvalTeamName;
    private final String approvalTeamArn;
    private final Instant initiationTime;
    private final Instant expirationTime;
    private final Instant completionTime;
    private final String description;
    private final String actionName;
    private final String protectedResourceArn;
    private final String requesterServicePrincipal;
    private final String requesterPrincipalArn;
    private final String requesterRegion;
    private final String requesterAccountId;
    private final String status;
    private final String statusCode;
    private final String statusMessage;
    private final String actionCompletionStrategy;

    private ListSessionsResponseSession(BuilderImpl builder) {
        this.sessionArn = builder.sessionArn;
        this.approvalTeamName = builder.approvalTeamName;
        this.approvalTeamArn = builder.approvalTeamArn;
        this.initiationTime = builder.initiationTime;
        this.expirationTime = builder.expirationTime;
        this.completionTime = builder.completionTime;
        this.description = builder.description;
        this.actionName = builder.actionName;
        this.protectedResourceArn = builder.protectedResourceArn;
        this.requesterServicePrincipal = builder.requesterServicePrincipal;
        this.requesterPrincipalArn = builder.requesterPrincipalArn;
        this.requesterRegion = builder.requesterRegion;
        this.requesterAccountId = builder.requesterAccountId;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.actionCompletionStrategy = builder.actionCompletionStrategy;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final String approvalTeamName() {
        return this.approvalTeamName;
    }

    public final String approvalTeamArn() {
        return this.approvalTeamArn;
    }

    public final Instant initiationTime() {
        return this.initiationTime;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final String description() {
        return this.description;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final String protectedResourceArn() {
        return this.protectedResourceArn;
    }

    public final String requesterServicePrincipal() {
        return this.requesterServicePrincipal;
    }

    public final String requesterPrincipalArn() {
        return this.requesterPrincipalArn;
    }

    public final String requesterRegion() {
        return this.requesterRegion;
    }

    public final String requesterAccountId() {
        return this.requesterAccountId;
    }

    public final SessionStatus status() {
        return SessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SessionStatusCode statusCode() {
        return SessionStatusCode.fromValue(this.statusCode);
    }

    public final String statusCodeAsString() {
        return this.statusCode;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final ActionCompletionStrategy actionCompletionStrategy() {
        return ActionCompletionStrategy.fromValue(this.actionCompletionStrategy);
    }

    public final String actionCompletionStrategyAsString() {
        return this.actionCompletionStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalTeamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalTeamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterServicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionCompletionStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionsResponseSession)) {
            return false;
        }
        ListSessionsResponseSession other = (ListSessionsResponseSession)obj;
        return Objects.equals(this.sessionArn(), other.sessionArn()) && Objects.equals(this.approvalTeamName(), other.approvalTeamName()) && Objects.equals(this.approvalTeamArn(), other.approvalTeamArn()) && Objects.equals(this.initiationTime(), other.initiationTime()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.protectedResourceArn(), other.protectedResourceArn()) && Objects.equals(this.requesterServicePrincipal(), other.requesterServicePrincipal()) && Objects.equals(this.requesterPrincipalArn(), other.requesterPrincipalArn()) && Objects.equals(this.requesterRegion(), other.requesterRegion()) && Objects.equals(this.requesterAccountId(), other.requesterAccountId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.actionCompletionStrategyAsString(), other.actionCompletionStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListSessionsResponseSession").add("SessionArn", (Object)this.sessionArn()).add("ApprovalTeamName", (Object)this.approvalTeamName()).add("ApprovalTeamArn", (Object)this.approvalTeamArn()).add("InitiationTime", (Object)this.initiationTime()).add("ExpirationTime", (Object)this.expirationTime()).add("CompletionTime", (Object)this.completionTime()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ActionName", (Object)this.actionName()).add("ProtectedResourceArn", (Object)this.protectedResourceArn()).add("RequesterServicePrincipal", (Object)this.requesterServicePrincipal()).add("RequesterPrincipalArn", (Object)this.requesterPrincipalArn()).add("RequesterRegion", (Object)this.requesterRegion()).add("RequesterAccountId", (Object)this.requesterAccountId()).add("Status", (Object)this.statusAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ActionCompletionStrategy", (Object)this.actionCompletionStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "ApprovalTeamName": {
                return Optional.ofNullable(clazz.cast(this.approvalTeamName()));
            }
            case "ApprovalTeamArn": {
                return Optional.ofNullable(clazz.cast(this.approvalTeamArn()));
            }
            case "InitiationTime": {
                return Optional.ofNullable(clazz.cast(this.initiationTime()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ActionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "ProtectedResourceArn": {
                return Optional.ofNullable(clazz.cast(this.protectedResourceArn()));
            }
            case "RequesterServicePrincipal": {
                return Optional.ofNullable(clazz.cast(this.requesterServicePrincipal()));
            }
            case "RequesterPrincipalArn": {
                return Optional.ofNullable(clazz.cast(this.requesterPrincipalArn()));
            }
            case "RequesterRegion": {
                return Optional.ofNullable(clazz.cast(this.requesterRegion()));
            }
            case "RequesterAccountId": {
                return Optional.ofNullable(clazz.cast(this.requesterAccountId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ActionCompletionStrategy": {
                return Optional.ofNullable(clazz.cast(this.actionCompletionStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SessionArn", SESSION_ARN_FIELD);
        map.put("ApprovalTeamName", APPROVAL_TEAM_NAME_FIELD);
        map.put("ApprovalTeamArn", APPROVAL_TEAM_ARN_FIELD);
        map.put("InitiationTime", INITIATION_TIME_FIELD);
        map.put("ExpirationTime", EXPIRATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ActionName", ACTION_NAME_FIELD);
        map.put("ProtectedResourceArn", PROTECTED_RESOURCE_ARN_FIELD);
        map.put("RequesterServicePrincipal", REQUESTER_SERVICE_PRINCIPAL_FIELD);
        map.put("RequesterPrincipalArn", REQUESTER_PRINCIPAL_ARN_FIELD);
        map.put("RequesterRegion", REQUESTER_REGION_FIELD);
        map.put("RequesterAccountId", REQUESTER_ACCOUNT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ActionCompletionStrategy", ACTION_COMPLETION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSessionsResponseSession, T> g) {
        return obj -> g.apply((ListSessionsResponseSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionArn;
        private String approvalTeamName;
        private String approvalTeamArn;
        private Instant initiationTime;
        private Instant expirationTime;
        private Instant completionTime;
        private String description;
        private String actionName;
        private String protectedResourceArn;
        private String requesterServicePrincipal;
        private String requesterPrincipalArn;
        private String requesterRegion;
        private String requesterAccountId;
        private String status;
        private String statusCode;
        private String statusMessage;
        private String actionCompletionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionsResponseSession model) {
            this.sessionArn(model.sessionArn);
            this.approvalTeamName(model.approvalTeamName);
            this.approvalTeamArn(model.approvalTeamArn);
            this.initiationTime(model.initiationTime);
            this.expirationTime(model.expirationTime);
            this.completionTime(model.completionTime);
            this.description(model.description);
            this.actionName(model.actionName);
            this.protectedResourceArn(model.protectedResourceArn);
            this.requesterServicePrincipal(model.requesterServicePrincipal);
            this.requesterPrincipalArn(model.requesterPrincipalArn);
            this.requesterRegion(model.requesterRegion);
            this.requesterAccountId(model.requesterAccountId);
            this.status(model.status);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.actionCompletionStrategy(model.actionCompletionStrategy);
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getApprovalTeamName() {
            return this.approvalTeamName;
        }

        public final void setApprovalTeamName(String approvalTeamName) {
            this.approvalTeamName = approvalTeamName;
        }

        @Override
        public final Builder approvalTeamName(String approvalTeamName) {
            this.approvalTeamName = approvalTeamName;
            return this;
        }

        public final String getApprovalTeamArn() {
            return this.approvalTeamArn;
        }

        public final void setApprovalTeamArn(String approvalTeamArn) {
            this.approvalTeamArn = approvalTeamArn;
        }

        @Override
        public final Builder approvalTeamArn(String approvalTeamArn) {
            this.approvalTeamArn = approvalTeamArn;
            return this;
        }

        public final Instant getInitiationTime() {
            return this.initiationTime;
        }

        public final void setInitiationTime(Instant initiationTime) {
            this.initiationTime = initiationTime;
        }

        @Override
        public final Builder initiationTime(Instant initiationTime) {
            this.initiationTime = initiationTime;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getProtectedResourceArn() {
            return this.protectedResourceArn;
        }

        public final void setProtectedResourceArn(String protectedResourceArn) {
            this.protectedResourceArn = protectedResourceArn;
        }

        @Override
        public final Builder protectedResourceArn(String protectedResourceArn) {
            this.protectedResourceArn = protectedResourceArn;
            return this;
        }

        public final String getRequesterServicePrincipal() {
            return this.requesterServicePrincipal;
        }

        public final void setRequesterServicePrincipal(String requesterServicePrincipal) {
            this.requesterServicePrincipal = requesterServicePrincipal;
        }

        @Override
        public final Builder requesterServicePrincipal(String requesterServicePrincipal) {
            this.requesterServicePrincipal = requesterServicePrincipal;
            return this;
        }

        public final String getRequesterPrincipalArn() {
            return this.requesterPrincipalArn;
        }

        public final void setRequesterPrincipalArn(String requesterPrincipalArn) {
            this.requesterPrincipalArn = requesterPrincipalArn;
        }

        @Override
        public final Builder requesterPrincipalArn(String requesterPrincipalArn) {
            this.requesterPrincipalArn = requesterPrincipalArn;
            return this;
        }

        public final String getRequesterRegion() {
            return this.requesterRegion;
        }

        public final void setRequesterRegion(String requesterRegion) {
            this.requesterRegion = requesterRegion;
        }

        @Override
        public final Builder requesterRegion(String requesterRegion) {
            this.requesterRegion = requesterRegion;
            return this;
        }

        public final String getRequesterAccountId() {
            return this.requesterAccountId;
        }

        public final void setRequesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
        }

        @Override
        public final Builder requesterAccountId(String requesterAccountId) {
            this.requesterAccountId = requesterAccountId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(SessionStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getActionCompletionStrategy() {
            return this.actionCompletionStrategy;
        }

        public final void setActionCompletionStrategy(String actionCompletionStrategy) {
            this.actionCompletionStrategy = actionCompletionStrategy;
        }

        @Override
        public final Builder actionCompletionStrategy(String actionCompletionStrategy) {
            this.actionCompletionStrategy = actionCompletionStrategy;
            return this;
        }

        @Override
        public final Builder actionCompletionStrategy(ActionCompletionStrategy actionCompletionStrategy) {
            this.actionCompletionStrategy(actionCompletionStrategy == null ? null : actionCompletionStrategy.toString());
            return this;
        }

        public ListSessionsResponseSession build() {
            return new ListSessionsResponseSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListSessionsResponseSession> {
        public Builder sessionArn(String var1);

        public Builder approvalTeamName(String var1);

        public Builder approvalTeamArn(String var1);

        public Builder initiationTime(Instant var1);

        public Builder expirationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder description(String var1);

        public Builder actionName(String var1);

        public Builder protectedResourceArn(String var1);

        public Builder requesterServicePrincipal(String var1);

        public Builder requesterPrincipalArn(String var1);

        public Builder requesterRegion(String var1);

        public Builder requesterAccountId(String var1);

        public Builder status(String var1);

        public Builder status(SessionStatus var1);

        public Builder statusCode(String var1);

        public Builder statusCode(SessionStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder actionCompletionStrategy(String var1);

        public Builder actionCompletionStrategy(ActionCompletionStrategy var1);
    }
}

