/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mpa.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartActiveApprovalTeamDeletionResponse extends MpaResponse implements
        ToCopyableBuilder<StartActiveApprovalTeamDeletionResponse.Builder, StartActiveApprovalTeamDeletionResponse> {
    private static final SdkField<Instant> DELETION_COMPLETION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeletionCompletionTime")
            .getter(getter(StartActiveApprovalTeamDeletionResponse::deletionCompletionTime))
            .setter(setter(Builder::deletionCompletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionCompletionTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> DELETION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeletionStartTime")
            .getter(getter(StartActiveApprovalTeamDeletionResponse::deletionStartTime))
            .setter(setter(Builder::deletionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DELETION_COMPLETION_TIME_FIELD, DELETION_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant deletionCompletionTime;

    private final Instant deletionStartTime;

    private StartActiveApprovalTeamDeletionResponse(BuilderImpl builder) {
        super(builder);
        this.deletionCompletionTime = builder.deletionCompletionTime;
        this.deletionStartTime = builder.deletionStartTime;
    }

    /**
     * <p>
     * Timestamp when the deletion process is scheduled to complete.
     * </p>
     * 
     * @return Timestamp when the deletion process is scheduled to complete.
     */
    public final Instant deletionCompletionTime() {
        return deletionCompletionTime;
    }

    /**
     * <p>
     * Timestamp when the deletion process was initiated.
     * </p>
     * 
     * @return Timestamp when the deletion process was initiated.
     */
    public final Instant deletionStartTime() {
        return deletionStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deletionCompletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(deletionStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartActiveApprovalTeamDeletionResponse)) {
            return false;
        }
        StartActiveApprovalTeamDeletionResponse other = (StartActiveApprovalTeamDeletionResponse) obj;
        return Objects.equals(deletionCompletionTime(), other.deletionCompletionTime())
                && Objects.equals(deletionStartTime(), other.deletionStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartActiveApprovalTeamDeletionResponse")
                .add("DeletionCompletionTime", deletionCompletionTime()).add("DeletionStartTime", deletionStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletionCompletionTime":
            return Optional.ofNullable(clazz.cast(deletionCompletionTime()));
        case "DeletionStartTime":
            return Optional.ofNullable(clazz.cast(deletionStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeletionCompletionTime", DELETION_COMPLETION_TIME_FIELD);
        map.put("DeletionStartTime", DELETION_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartActiveApprovalTeamDeletionResponse, T> g) {
        return obj -> g.apply((StartActiveApprovalTeamDeletionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MpaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartActiveApprovalTeamDeletionResponse> {
        /**
         * <p>
         * Timestamp when the deletion process is scheduled to complete.
         * </p>
         * 
         * @param deletionCompletionTime
         *        Timestamp when the deletion process is scheduled to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionCompletionTime(Instant deletionCompletionTime);

        /**
         * <p>
         * Timestamp when the deletion process was initiated.
         * </p>
         * 
         * @param deletionStartTime
         *        Timestamp when the deletion process was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionStartTime(Instant deletionStartTime);
    }

    static final class BuilderImpl extends MpaResponse.BuilderImpl implements Builder {
        private Instant deletionCompletionTime;

        private Instant deletionStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartActiveApprovalTeamDeletionResponse model) {
            super(model);
            deletionCompletionTime(model.deletionCompletionTime);
            deletionStartTime(model.deletionStartTime);
        }

        public final Instant getDeletionCompletionTime() {
            return deletionCompletionTime;
        }

        public final void setDeletionCompletionTime(Instant deletionCompletionTime) {
            this.deletionCompletionTime = deletionCompletionTime;
        }

        @Override
        public final Builder deletionCompletionTime(Instant deletionCompletionTime) {
            this.deletionCompletionTime = deletionCompletionTime;
            return this;
        }

        public final Instant getDeletionStartTime() {
            return deletionStartTime;
        }

        public final void setDeletionStartTime(Instant deletionStartTime) {
            this.deletionStartTime = deletionStartTime;
        }

        @Override
        public final Builder deletionStartTime(Instant deletionStartTime) {
            this.deletionStartTime = deletionStartTime;
            return this;
        }

        @Override
        public StartActiveApprovalTeamDeletionResponse build() {
            return new StartActiveApprovalTeamDeletionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
