/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The Amazon Resource Name (ARN) of the broker.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerSummary implements SdkPojo, Serializable, ToCopyableBuilder<BrokerSummary.Builder, BrokerSummary> {
    private static final SdkField<String> BROKER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BrokerSummary::brokerArn)).setter(setter(Builder::brokerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerArn").build()).build();

    private static final SdkField<String> BROKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BrokerSummary::brokerId)).setter(setter(Builder::brokerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()).build();

    private static final SdkField<String> BROKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BrokerSummary::brokerName)).setter(setter(Builder::brokerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerName").build()).build();

    private static final SdkField<String> BROKER_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BrokerSummary::brokerStateAsString)).setter(setter(Builder::brokerState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerState").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(BrokerSummary::created))
            .setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BrokerSummary::deploymentModeAsString)).setter(setter(Builder::deploymentMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentMode").build()).build();

    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BrokerSummary::hostInstanceType)).setter(setter(Builder::hostInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ARN_FIELD,
            BROKER_ID_FIELD, BROKER_NAME_FIELD, BROKER_STATE_FIELD, CREATED_FIELD, DEPLOYMENT_MODE_FIELD,
            HOST_INSTANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String brokerArn;

    private final String brokerId;

    private final String brokerName;

    private final String brokerState;

    private final Instant created;

    private final String deploymentMode;

    private final String hostInstanceType;

    private BrokerSummary(BuilderImpl builder) {
        this.brokerArn = builder.brokerArn;
        this.brokerId = builder.brokerId;
        this.brokerName = builder.brokerName;
        this.brokerState = builder.brokerState;
        this.created = builder.created;
        this.deploymentMode = builder.deploymentMode;
        this.hostInstanceType = builder.hostInstanceType;
    }

    /**
     * The Amazon Resource Name (ARN) of the broker.
     * 
     * @return The Amazon Resource Name (ARN) of the broker.
     */
    public String brokerArn() {
        return brokerArn;
    }

    /**
     * The unique ID that Amazon MQ generates for the broker.
     * 
     * @return The unique ID that Amazon MQ generates for the broker.
     */
    public String brokerId() {
        return brokerId;
    }

    /**
     * The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain only
     * letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard characters, or
     * special characters.
     * 
     * @return The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain
     *         only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard
     *         characters, or special characters.
     */
    public String brokerName() {
        return brokerName;
    }

    /**
     * The status of the broker.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brokerState} will
     * return {@link BrokerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brokerStateAsString}.
     * </p>
     * 
     * @return The status of the broker.
     * @see BrokerState
     */
    public BrokerState brokerState() {
        return BrokerState.fromValue(brokerState);
    }

    /**
     * The status of the broker.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brokerState} will
     * return {@link BrokerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brokerStateAsString}.
     * </p>
     * 
     * @return The status of the broker.
     * @see BrokerState
     */
    public String brokerStateAsString() {
        return brokerState;
    }

    /**
     * The time when the broker was created.
     * 
     * @return The time when the broker was created.
     */
    public Instant created() {
        return created;
    }

    /**
     * Required. The deployment mode of the broker.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentMode}
     * will return {@link DeploymentMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentModeAsString}.
     * </p>
     * 
     * @return Required. The deployment mode of the broker.
     * @see DeploymentMode
     */
    public DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(deploymentMode);
    }

    /**
     * Required. The deployment mode of the broker.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentMode}
     * will return {@link DeploymentMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentModeAsString}.
     * </p>
     * 
     * @return Required. The deployment mode of the broker.
     * @see DeploymentMode
     */
    public String deploymentModeAsString() {
        return deploymentMode;
    }

    /**
     * The broker's instance type.
     * 
     * @return The broker's instance type.
     */
    public String hostInstanceType() {
        return hostInstanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brokerArn());
        hashCode = 31 * hashCode + Objects.hashCode(brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(brokerName());
        hashCode = 31 * hashCode + Objects.hashCode(brokerStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostInstanceType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerSummary)) {
            return false;
        }
        BrokerSummary other = (BrokerSummary) obj;
        return Objects.equals(brokerArn(), other.brokerArn()) && Objects.equals(brokerId(), other.brokerId())
                && Objects.equals(brokerName(), other.brokerName())
                && Objects.equals(brokerStateAsString(), other.brokerStateAsString())
                && Objects.equals(created(), other.created())
                && Objects.equals(deploymentModeAsString(), other.deploymentModeAsString())
                && Objects.equals(hostInstanceType(), other.hostInstanceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BrokerSummary").add("BrokerArn", brokerArn()).add("BrokerId", brokerId())
                .add("BrokerName", brokerName()).add("BrokerState", brokerStateAsString()).add("Created", created())
                .add("DeploymentMode", deploymentModeAsString()).add("HostInstanceType", hostInstanceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerArn":
            return Optional.ofNullable(clazz.cast(brokerArn()));
        case "BrokerId":
            return Optional.ofNullable(clazz.cast(brokerId()));
        case "BrokerName":
            return Optional.ofNullable(clazz.cast(brokerName()));
        case "BrokerState":
            return Optional.ofNullable(clazz.cast(brokerStateAsString()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "DeploymentMode":
            return Optional.ofNullable(clazz.cast(deploymentModeAsString()));
        case "HostInstanceType":
            return Optional.ofNullable(clazz.cast(hostInstanceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerSummary, T> g) {
        return obj -> g.apply((BrokerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerSummary> {
        /**
         * The Amazon Resource Name (ARN) of the broker.
         * 
         * @param brokerArn
         *        The Amazon Resource Name (ARN) of the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerArn(String brokerArn);

        /**
         * The unique ID that Amazon MQ generates for the broker.
         * 
         * @param brokerId
         *        The unique ID that Amazon MQ generates for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerId(String brokerId);

        /**
         * The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain
         * only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard
         * characters, or special characters.
         * 
         * @param brokerName
         *        The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must
         *        contain only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets,
         *        wildcard characters, or special characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerName(String brokerName);

        /**
         * The status of the broker.
         * 
         * @param brokerState
         *        The status of the broker.
         * @see BrokerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerState
         */
        Builder brokerState(String brokerState);

        /**
         * The status of the broker.
         * 
         * @param brokerState
         *        The status of the broker.
         * @see BrokerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerState
         */
        Builder brokerState(BrokerState brokerState);

        /**
         * The time when the broker was created.
         * 
         * @param created
         *        The time when the broker was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * Required. The deployment mode of the broker.
         * 
         * @param deploymentMode
         *        Required. The deployment mode of the broker.
         * @see DeploymentMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentMode
         */
        Builder deploymentMode(String deploymentMode);

        /**
         * Required. The deployment mode of the broker.
         * 
         * @param deploymentMode
         *        Required. The deployment mode of the broker.
         * @see DeploymentMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentMode
         */
        Builder deploymentMode(DeploymentMode deploymentMode);

        /**
         * The broker's instance type.
         * 
         * @param hostInstanceType
         *        The broker's instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostInstanceType(String hostInstanceType);
    }

    static final class BuilderImpl implements Builder {
        private String brokerArn;

        private String brokerId;

        private String brokerName;

        private String brokerState;

        private Instant created;

        private String deploymentMode;

        private String hostInstanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerSummary model) {
            brokerArn(model.brokerArn);
            brokerId(model.brokerId);
            brokerName(model.brokerName);
            brokerState(model.brokerState);
            created(model.created);
            deploymentMode(model.deploymentMode);
            hostInstanceType(model.hostInstanceType);
        }

        public final String getBrokerArn() {
            return brokerArn;
        }

        @Override
        public final Builder brokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
            return this;
        }

        public final void setBrokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
        }

        public final String getBrokerId() {
            return brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final String getBrokerName() {
            return brokerName;
        }

        @Override
        public final Builder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public final void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        public final String getBrokerState() {
            return brokerState;
        }

        @Override
        public final Builder brokerState(String brokerState) {
            this.brokerState = brokerState;
            return this;
        }

        @Override
        public final Builder brokerState(BrokerState brokerState) {
            this.brokerState(brokerState == null ? null : brokerState.toString());
            return this;
        }

        public final void setBrokerState(String brokerState) {
            this.brokerState = brokerState;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getDeploymentMode() {
            return deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode == null ? null : deploymentMode.toString());
            return this;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        public final String getHostInstanceType() {
            return hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        @Override
        public BrokerSummary build() {
            return new BrokerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
