/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationRevisionsResponse extends MqResponse implements
        ToCopyableBuilder<ListConfigurationRevisionsResponse.Builder, ListConfigurationRevisionsResponse> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListConfigurationRevisionsResponse::configurationId)).setter(setter(Builder::configurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListConfigurationRevisionsResponse::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListConfigurationRevisionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ConfigurationRevision>> REVISIONS_FIELD = SdkField
            .<List<ConfigurationRevision>> builder(MarshallingType.LIST)
            .getter(getter(ListConfigurationRevisionsResponse::revisions))
            .setter(setter(Builder::revisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationRevision> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationRevision::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REVISIONS_FIELD));

    private final String configurationId;

    private final Integer maxResults;

    private final String nextToken;

    private final List<ConfigurationRevision> revisions;

    private ListConfigurationRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.revisions = builder.revisions;
    }

    /**
     * The unique ID that Amazon MQ generates for the configuration.
     * 
     * @return The unique ID that Amazon MQ generates for the configuration.
     */
    public String configurationId() {
        return configurationId;
    }

    /**
     * The maximum number of configuration revisions that can be returned per page (20 by default). This value must be
     * an integer from 5 to 100.
     * 
     * @return The maximum number of configuration revisions that can be returned per page (20 by default). This value
     *         must be an integer from 5 to 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
     * nextToken empty.
     * 
     * @return The token that specifies the next page of results Amazon MQ should return. To request the first page,
     *         leave nextToken empty.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Revisions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRevisions() {
        return revisions != null && !(revisions instanceof SdkAutoConstructList);
    }

    /**
     * The list of all revisions for the specified configuration.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRevisions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of all revisions for the specified configuration.
     */
    public List<ConfigurationRevision> revisions() {
        return revisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(revisions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationRevisionsResponse)) {
            return false;
        }
        ListConfigurationRevisionsResponse other = (ListConfigurationRevisionsResponse) obj;
        return Objects.equals(configurationId(), other.configurationId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(revisions(), other.revisions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListConfigurationRevisionsResponse").add("ConfigurationId", configurationId())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Revisions", revisions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationId":
            return Optional.ofNullable(clazz.cast(configurationId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Revisions":
            return Optional.ofNullable(clazz.cast(revisions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationRevisionsResponse, T> g) {
        return obj -> g.apply((ListConfigurationRevisionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConfigurationRevisionsResponse> {
        /**
         * The unique ID that Amazon MQ generates for the configuration.
         * 
         * @param configurationId
         *        The unique ID that Amazon MQ generates for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationId(String configurationId);

        /**
         * The maximum number of configuration revisions that can be returned per page (20 by default). This value must
         * be an integer from 5 to 100.
         * 
         * @param maxResults
         *        The maximum number of configuration revisions that can be returned per page (20 by default). This
         *        value must be an integer from 5 to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
         * nextToken empty.
         * 
         * @param nextToken
         *        The token that specifies the next page of results Amazon MQ should return. To request the first page,
         *        leave nextToken empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * The list of all revisions for the specified configuration.
         * 
         * @param revisions
         *        The list of all revisions for the specified configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(Collection<ConfigurationRevision> revisions);

        /**
         * The list of all revisions for the specified configuration.
         * 
         * @param revisions
         *        The list of all revisions for the specified configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisions(ConfigurationRevision... revisions);

        /**
         * The list of all revisions for the specified configuration. This is a convenience that creates an instance of
         * the {@link List<ConfigurationRevision>.Builder} avoiding the need to create one manually via {@link List
         * <ConfigurationRevision>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationRevision>.Builder#build()} is called
         * immediately and its result is passed to {@link #revisions(List<ConfigurationRevision>)}.
         * 
         * @param revisions
         *        a consumer that will call methods on {@link List<ConfigurationRevision>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisions(List<ConfigurationRevision>)
         */
        Builder revisions(Consumer<ConfigurationRevision.Builder>... revisions);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private String configurationId;

        private Integer maxResults;

        private String nextToken;

        private List<ConfigurationRevision> revisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationRevisionsResponse model) {
            super(model);
            configurationId(model.configurationId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            revisions(model.revisions);
        }

        public final String getConfigurationId() {
            return configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ConfigurationRevision.Builder> getRevisions() {
            return revisions != null ? revisions.stream().map(ConfigurationRevision::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder revisions(Collection<ConfigurationRevision> revisions) {
            this.revisions = ___listOfConfigurationRevisionCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(ConfigurationRevision... revisions) {
            revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<ConfigurationRevision.Builder>... revisions) {
            revisions(Stream.of(revisions).map(c -> ConfigurationRevision.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRevisions(Collection<ConfigurationRevision.BuilderImpl> revisions) {
            this.revisions = ___listOfConfigurationRevisionCopier.copyFromBuilder(revisions);
        }

        @Override
        public ListConfigurationRevisionsResponse build() {
            return new ListConfigurationRevisionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
