/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The metadata of the LDAP server used to authenticate and authorize connections to the broker.
 */
@Generated("software.amazon.awssdk:codegen")
public final class LdapServerMetadataOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<LdapServerMetadataOutput.Builder, LdapServerMetadataOutput> {
    private static final SdkField<List<String>> HOSTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Hosts")
            .getter(getter(LdapServerMetadataOutput::hosts))
            .setter(setter(Builder::hosts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hosts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleBase").getter(getter(LdapServerMetadataOutput::roleBase)).setter(setter(Builder::roleBase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleBase").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(LdapServerMetadataOutput::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final SdkField<String> ROLE_SEARCH_MATCHING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleSearchMatching").getter(getter(LdapServerMetadataOutput::roleSearchMatching))
            .setter(setter(Builder::roleSearchMatching))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleSearchMatching").build())
            .build();

    private static final SdkField<Boolean> ROLE_SEARCH_SUBTREE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RoleSearchSubtree").getter(getter(LdapServerMetadataOutput::roleSearchSubtree))
            .setter(setter(Builder::roleSearchSubtree))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleSearchSubtree").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccountUsername").getter(getter(LdapServerMetadataOutput::serviceAccountUsername))
            .setter(setter(Builder::serviceAccountUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountUsername").build())
            .build();

    private static final SdkField<String> USER_BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserBase").getter(getter(LdapServerMetadataOutput::userBase)).setter(setter(Builder::userBase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userBase").build()).build();

    private static final SdkField<String> USER_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserRoleName").getter(getter(LdapServerMetadataOutput::userRoleName))
            .setter(setter(Builder::userRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRoleName").build()).build();

    private static final SdkField<String> USER_SEARCH_MATCHING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserSearchMatching").getter(getter(LdapServerMetadataOutput::userSearchMatching))
            .setter(setter(Builder::userSearchMatching))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSearchMatching").build())
            .build();

    private static final SdkField<Boolean> USER_SEARCH_SUBTREE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UserSearchSubtree").getter(getter(LdapServerMetadataOutput::userSearchSubtree))
            .setter(setter(Builder::userSearchSubtree))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSearchSubtree").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTS_FIELD, ROLE_BASE_FIELD,
            ROLE_NAME_FIELD, ROLE_SEARCH_MATCHING_FIELD, ROLE_SEARCH_SUBTREE_FIELD, SERVICE_ACCOUNT_USERNAME_FIELD,
            USER_BASE_FIELD, USER_ROLE_NAME_FIELD, USER_SEARCH_MATCHING_FIELD, USER_SEARCH_SUBTREE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> hosts;

    private final String roleBase;

    private final String roleName;

    private final String roleSearchMatching;

    private final Boolean roleSearchSubtree;

    private final String serviceAccountUsername;

    private final String userBase;

    private final String userRoleName;

    private final String userSearchMatching;

    private final Boolean userSearchSubtree;

    private LdapServerMetadataOutput(BuilderImpl builder) {
        this.hosts = builder.hosts;
        this.roleBase = builder.roleBase;
        this.roleName = builder.roleName;
        this.roleSearchMatching = builder.roleSearchMatching;
        this.roleSearchSubtree = builder.roleSearchSubtree;
        this.serviceAccountUsername = builder.serviceAccountUsername;
        this.userBase = builder.userBase;
        this.userRoleName = builder.userRoleName;
        this.userSearchMatching = builder.userSearchMatching;
        this.userSearchSubtree = builder.userSearchSubtree;
    }

    /**
     * Returns true if the Hosts property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasHosts() {
        return hosts != null && !(hosts instanceof SdkAutoConstructList);
    }

    /**
     * Fully qualified domain name of the LDAP server. Optional failover server.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHosts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Fully qualified domain name of the LDAP server. Optional failover server.
     */
    public final List<String> hosts() {
        return hosts;
    }

    /**
     * Fully qualified name of the directory to search for a user’s groups.
     * 
     * @return Fully qualified name of the directory to search for a user’s groups.
     */
    public final String roleBase() {
        return roleBase;
    }

    /**
     * Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group
     * membership query.
     * 
     * @return Specifies the LDAP attribute that identifies the group name attribute in the object returned from the
     *         group membership query.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * The search criteria for groups.
     * 
     * @return The search criteria for groups.
     */
    public final String roleSearchMatching() {
        return roleSearchMatching;
    }

    /**
     * The directory search scope for the role. If set to true, scope is to search the entire sub-tree.
     * 
     * @return The directory search scope for the role. If set to true, scope is to search the entire sub-tree.
     */
    public final Boolean roleSearchSubtree() {
        return roleSearchSubtree;
    }

    /**
     * Service account username.
     * 
     * @return Service account username.
     */
    public final String serviceAccountUsername() {
        return serviceAccountUsername;
    }

    /**
     * Fully qualified name of the directory where you want to search for users.
     * 
     * @return Fully qualified name of the directory where you want to search for users.
     */
    public final String userBase() {
        return userBase;
    }

    /**
     * Specifies the name of the LDAP attribute for the user group membership.
     * 
     * @return Specifies the name of the LDAP attribute for the user group membership.
     */
    public final String userRoleName() {
        return userRoleName;
    }

    /**
     * The search criteria for users.
     * 
     * @return The search criteria for users.
     */
    public final String userSearchMatching() {
        return userSearchMatching;
    }

    /**
     * The directory search scope for the user. If set to true, scope is to search the entire sub-tree.
     * 
     * @return The directory search scope for the user. If set to true, scope is to search the entire sub-tree.
     */
    public final Boolean userSearchSubtree() {
        return userSearchSubtree;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHosts() ? hosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleBase());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(roleSearchMatching());
        hashCode = 31 * hashCode + Objects.hashCode(roleSearchSubtree());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountUsername());
        hashCode = 31 * hashCode + Objects.hashCode(userBase());
        hashCode = 31 * hashCode + Objects.hashCode(userRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(userSearchMatching());
        hashCode = 31 * hashCode + Objects.hashCode(userSearchSubtree());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LdapServerMetadataOutput)) {
            return false;
        }
        LdapServerMetadataOutput other = (LdapServerMetadataOutput) obj;
        return hasHosts() == other.hasHosts() && Objects.equals(hosts(), other.hosts())
                && Objects.equals(roleBase(), other.roleBase()) && Objects.equals(roleName(), other.roleName())
                && Objects.equals(roleSearchMatching(), other.roleSearchMatching())
                && Objects.equals(roleSearchSubtree(), other.roleSearchSubtree())
                && Objects.equals(serviceAccountUsername(), other.serviceAccountUsername())
                && Objects.equals(userBase(), other.userBase()) && Objects.equals(userRoleName(), other.userRoleName())
                && Objects.equals(userSearchMatching(), other.userSearchMatching())
                && Objects.equals(userSearchSubtree(), other.userSearchSubtree());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LdapServerMetadataOutput").add("Hosts", hasHosts() ? hosts() : null).add("RoleBase", roleBase())
                .add("RoleName", roleName()).add("RoleSearchMatching", roleSearchMatching())
                .add("RoleSearchSubtree", roleSearchSubtree()).add("ServiceAccountUsername", serviceAccountUsername())
                .add("UserBase", userBase()).add("UserRoleName", userRoleName()).add("UserSearchMatching", userSearchMatching())
                .add("UserSearchSubtree", userSearchSubtree()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hosts":
            return Optional.ofNullable(clazz.cast(hosts()));
        case "RoleBase":
            return Optional.ofNullable(clazz.cast(roleBase()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "RoleSearchMatching":
            return Optional.ofNullable(clazz.cast(roleSearchMatching()));
        case "RoleSearchSubtree":
            return Optional.ofNullable(clazz.cast(roleSearchSubtree()));
        case "ServiceAccountUsername":
            return Optional.ofNullable(clazz.cast(serviceAccountUsername()));
        case "UserBase":
            return Optional.ofNullable(clazz.cast(userBase()));
        case "UserRoleName":
            return Optional.ofNullable(clazz.cast(userRoleName()));
        case "UserSearchMatching":
            return Optional.ofNullable(clazz.cast(userSearchMatching()));
        case "UserSearchSubtree":
            return Optional.ofNullable(clazz.cast(userSearchSubtree()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LdapServerMetadataOutput, T> g) {
        return obj -> g.apply((LdapServerMetadataOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LdapServerMetadataOutput> {
        /**
         * Fully qualified domain name of the LDAP server. Optional failover server.
         * 
         * @param hosts
         *        Fully qualified domain name of the LDAP server. Optional failover server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(Collection<String> hosts);

        /**
         * Fully qualified domain name of the LDAP server. Optional failover server.
         * 
         * @param hosts
         *        Fully qualified domain name of the LDAP server. Optional failover server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(String... hosts);

        /**
         * Fully qualified name of the directory to search for a user’s groups.
         * 
         * @param roleBase
         *        Fully qualified name of the directory to search for a user’s groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleBase(String roleBase);

        /**
         * Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group
         * membership query.
         * 
         * @param roleName
         *        Specifies the LDAP attribute that identifies the group name attribute in the object returned from the
         *        group membership query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * The search criteria for groups.
         * 
         * @param roleSearchMatching
         *        The search criteria for groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleSearchMatching(String roleSearchMatching);

        /**
         * The directory search scope for the role. If set to true, scope is to search the entire sub-tree.
         * 
         * @param roleSearchSubtree
         *        The directory search scope for the role. If set to true, scope is to search the entire sub-tree.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleSearchSubtree(Boolean roleSearchSubtree);

        /**
         * Service account username.
         * 
         * @param serviceAccountUsername
         *        Service account username.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountUsername(String serviceAccountUsername);

        /**
         * Fully qualified name of the directory where you want to search for users.
         * 
         * @param userBase
         *        Fully qualified name of the directory where you want to search for users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBase(String userBase);

        /**
         * Specifies the name of the LDAP attribute for the user group membership.
         * 
         * @param userRoleName
         *        Specifies the name of the LDAP attribute for the user group membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRoleName(String userRoleName);

        /**
         * The search criteria for users.
         * 
         * @param userSearchMatching
         *        The search criteria for users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSearchMatching(String userSearchMatching);

        /**
         * The directory search scope for the user. If set to true, scope is to search the entire sub-tree.
         * 
         * @param userSearchSubtree
         *        The directory search scope for the user. If set to true, scope is to search the entire sub-tree.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSearchSubtree(Boolean userSearchSubtree);
    }

    static final class BuilderImpl implements Builder {
        private List<String> hosts = DefaultSdkAutoConstructList.getInstance();

        private String roleBase;

        private String roleName;

        private String roleSearchMatching;

        private Boolean roleSearchSubtree;

        private String serviceAccountUsername;

        private String userBase;

        private String userRoleName;

        private String userSearchMatching;

        private Boolean userSearchSubtree;

        private BuilderImpl() {
        }

        private BuilderImpl(LdapServerMetadataOutput model) {
            hosts(model.hosts);
            roleBase(model.roleBase);
            roleName(model.roleName);
            roleSearchMatching(model.roleSearchMatching);
            roleSearchSubtree(model.roleSearchSubtree);
            serviceAccountUsername(model.serviceAccountUsername);
            userBase(model.userBase);
            userRoleName(model.userRoleName);
            userSearchMatching(model.userSearchMatching);
            userSearchSubtree(model.userSearchSubtree);
        }

        public final Collection<String> getHosts() {
            if (hosts instanceof SdkAutoConstructList) {
                return null;
            }
            return hosts;
        }

        @Override
        public final Builder hosts(Collection<String> hosts) {
            this.hosts = ___listOf__stringCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(String... hosts) {
            hosts(Arrays.asList(hosts));
            return this;
        }

        public final void setHosts(Collection<String> hosts) {
            this.hosts = ___listOf__stringCopier.copy(hosts);
        }

        public final String getRoleBase() {
            return roleBase;
        }

        @Override
        public final Builder roleBase(String roleBase) {
            this.roleBase = roleBase;
            return this;
        }

        public final void setRoleBase(String roleBase) {
            this.roleBase = roleBase;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getRoleSearchMatching() {
            return roleSearchMatching;
        }

        @Override
        public final Builder roleSearchMatching(String roleSearchMatching) {
            this.roleSearchMatching = roleSearchMatching;
            return this;
        }

        public final void setRoleSearchMatching(String roleSearchMatching) {
            this.roleSearchMatching = roleSearchMatching;
        }

        public final Boolean getRoleSearchSubtree() {
            return roleSearchSubtree;
        }

        @Override
        public final Builder roleSearchSubtree(Boolean roleSearchSubtree) {
            this.roleSearchSubtree = roleSearchSubtree;
            return this;
        }

        public final void setRoleSearchSubtree(Boolean roleSearchSubtree) {
            this.roleSearchSubtree = roleSearchSubtree;
        }

        public final String getServiceAccountUsername() {
            return serviceAccountUsername;
        }

        @Override
        public final Builder serviceAccountUsername(String serviceAccountUsername) {
            this.serviceAccountUsername = serviceAccountUsername;
            return this;
        }

        public final void setServiceAccountUsername(String serviceAccountUsername) {
            this.serviceAccountUsername = serviceAccountUsername;
        }

        public final String getUserBase() {
            return userBase;
        }

        @Override
        public final Builder userBase(String userBase) {
            this.userBase = userBase;
            return this;
        }

        public final void setUserBase(String userBase) {
            this.userBase = userBase;
        }

        public final String getUserRoleName() {
            return userRoleName;
        }

        @Override
        public final Builder userRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
            return this;
        }

        public final void setUserRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
        }

        public final String getUserSearchMatching() {
            return userSearchMatching;
        }

        @Override
        public final Builder userSearchMatching(String userSearchMatching) {
            this.userSearchMatching = userSearchMatching;
            return this;
        }

        public final void setUserSearchMatching(String userSearchMatching) {
            this.userSearchMatching = userSearchMatching;
        }

        public final Boolean getUserSearchSubtree() {
            return userSearchSubtree;
        }

        @Override
        public final Builder userSearchSubtree(Boolean userSearchSubtree) {
            this.userSearchSubtree = userSearchSubtree;
            return this;
        }

        public final void setUserSearchSubtree(Boolean userSearchSubtree) {
            this.userSearchSubtree = userSearchSubtree;
        }

        @Override
        public LdapServerMetadataOutput build() {
            return new LdapServerMetadataOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
