/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BrokerStorageType {
    EBS("EBS"),
    EFS("EFS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BrokerStorageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BrokerStorageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BrokerStorageType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BrokerStorageType> knownValues() {
        return Stream.of(BrokerStorageType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

