/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Option for host instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerInstanceOption implements SdkPojo, Serializable,
        ToCopyableBuilder<BrokerInstanceOption.Builder, BrokerInstanceOption> {
    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AvailabilityZone>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(BrokerInstanceOption::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineType").getter(getter(BrokerInstanceOption::engineTypeAsString))
            .setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostInstanceType").getter(getter(BrokerInstanceOption::hostInstanceType))
            .setter(setter(Builder::hostInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(BrokerInstanceOption::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<List<String>> SUPPORTED_DEPLOYMENT_MODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedDeploymentModes")
            .getter(getter(BrokerInstanceOption::supportedDeploymentModesAsStrings))
            .setter(setter(Builder::supportedDeploymentModesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDeploymentModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_ENGINE_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedEngineVersions")
            .getter(getter(BrokerInstanceOption::supportedEngineVersions))
            .setter(setter(Builder::supportedEngineVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedEngineVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            ENGINE_TYPE_FIELD, HOST_INSTANCE_TYPE_FIELD, STORAGE_TYPE_FIELD, SUPPORTED_DEPLOYMENT_MODES_FIELD,
            SUPPORTED_ENGINE_VERSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AvailabilityZone> availabilityZones;

    private final String engineType;

    private final String hostInstanceType;

    private final String storageType;

    private final List<String> supportedDeploymentModes;

    private final List<String> supportedEngineVersions;

    private BrokerInstanceOption(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.engineType = builder.engineType;
        this.hostInstanceType = builder.hostInstanceType;
        this.storageType = builder.storageType;
        this.supportedDeploymentModes = builder.supportedDeploymentModes;
        this.supportedEngineVersions = builder.supportedEngineVersions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of available az.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return The list of available az.
     */
    public final List<AvailabilityZone> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The broker's engine type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The broker's engine type.
     * @see EngineType
     */
    public final EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * <p>
     * The broker's engine type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The broker's engine type.
     * @see EngineType
     */
    public final String engineTypeAsString() {
        return engineType;
    }

    /**
     * <p>
     * The broker's instance type.
     * </p>
     * 
     * @return The broker's instance type.
     */
    public final String hostInstanceType() {
        return hostInstanceType;
    }

    /**
     * <p>
     * The broker's storage type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link BrokerStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The broker's storage type.
     * @see BrokerStorageType
     */
    public final BrokerStorageType storageType() {
        return BrokerStorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The broker's storage type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link BrokerStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The broker's storage type.
     * @see BrokerStorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * The list of supported deployment modes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDeploymentModes} method.
     * </p>
     * 
     * @return The list of supported deployment modes.
     */
    public final List<DeploymentMode> supportedDeploymentModes() {
        return ___listOfDeploymentModeCopier.copyStringToEnum(supportedDeploymentModes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedDeploymentModes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedDeploymentModes() {
        return supportedDeploymentModes != null && !(supportedDeploymentModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of supported deployment modes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDeploymentModes} method.
     * </p>
     * 
     * @return The list of supported deployment modes.
     */
    public final List<String> supportedDeploymentModesAsStrings() {
        return supportedDeploymentModes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedEngineVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedEngineVersions() {
        return supportedEngineVersions != null && !(supportedEngineVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of supported engine versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedEngineVersions} method.
     * </p>
     * 
     * @return The list of supported engine versions.
     */
    public final List<String> supportedEngineVersions() {
        return supportedEngineVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedDeploymentModes() ? supportedDeploymentModesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedEngineVersions() ? supportedEngineVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerInstanceOption)) {
            return false;
        }
        BrokerInstanceOption other = (BrokerInstanceOption) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(hostInstanceType(), other.hostInstanceType())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && hasSupportedDeploymentModes() == other.hasSupportedDeploymentModes()
                && Objects.equals(supportedDeploymentModesAsStrings(), other.supportedDeploymentModesAsStrings())
                && hasSupportedEngineVersions() == other.hasSupportedEngineVersions()
                && Objects.equals(supportedEngineVersions(), other.supportedEngineVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrokerInstanceOption")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("EngineType", engineTypeAsString()).add("HostInstanceType", hostInstanceType())
                .add("StorageType", storageTypeAsString())
                .add("SupportedDeploymentModes", hasSupportedDeploymentModes() ? supportedDeploymentModesAsStrings() : null)
                .add("SupportedEngineVersions", hasSupportedEngineVersions() ? supportedEngineVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "EngineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "HostInstanceType":
            return Optional.ofNullable(clazz.cast(hostInstanceType()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "SupportedDeploymentModes":
            return Optional.ofNullable(clazz.cast(supportedDeploymentModesAsStrings()));
        case "SupportedEngineVersions":
            return Optional.ofNullable(clazz.cast(supportedEngineVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerInstanceOption, T> g) {
        return obj -> g.apply((BrokerInstanceOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerInstanceOption> {
        /**
         * <p>
         * The list of available az.
         * </p>
         * 
         * @param availabilityZones
         *        The list of available az.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<AvailabilityZone> availabilityZones);

        /**
         * <p>
         * The list of available az.
         * </p>
         * 
         * @param availabilityZones
         *        The list of available az.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(AvailabilityZone... availabilityZones);

        /**
         * <p>
         * The list of available az.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AvailabilityZone>.Builder} avoiding
         * the need to create one manually via {@link List<AvailabilityZone>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AvailabilityZone>.Builder#build()} is called immediately and
         * its result is passed to {@link #availabilityZones(List<AvailabilityZone>)}.
         * 
         * @param availabilityZones
         *        a consumer that will call methods on {@link List<AvailabilityZone>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZones(List<AvailabilityZone>)
         */
        Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones);

        /**
         * <p>
         * The broker's engine type.
         * </p>
         * 
         * @param engineType
         *        The broker's engine type.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * The broker's engine type.
         * </p>
         * 
         * @param engineType
         *        The broker's engine type.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * <p>
         * The broker's instance type.
         * </p>
         * 
         * @param hostInstanceType
         *        The broker's instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostInstanceType(String hostInstanceType);

        /**
         * <p>
         * The broker's storage type.
         * </p>
         * 
         * @param storageType
         *        The broker's storage type.
         * @see BrokerStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerStorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The broker's storage type.
         * </p>
         * 
         * @param storageType
         *        The broker's storage type.
         * @see BrokerStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerStorageType
         */
        Builder storageType(BrokerStorageType storageType);

        /**
         * <p>
         * The list of supported deployment modes.
         * </p>
         * 
         * @param supportedDeploymentModes
         *        The list of supported deployment modes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDeploymentModesWithStrings(Collection<String> supportedDeploymentModes);

        /**
         * <p>
         * The list of supported deployment modes.
         * </p>
         * 
         * @param supportedDeploymentModes
         *        The list of supported deployment modes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDeploymentModesWithStrings(String... supportedDeploymentModes);

        /**
         * <p>
         * The list of supported deployment modes.
         * </p>
         * 
         * @param supportedDeploymentModes
         *        The list of supported deployment modes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDeploymentModes(Collection<DeploymentMode> supportedDeploymentModes);

        /**
         * <p>
         * The list of supported deployment modes.
         * </p>
         * 
         * @param supportedDeploymentModes
         *        The list of supported deployment modes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDeploymentModes(DeploymentMode... supportedDeploymentModes);

        /**
         * <p>
         * The list of supported engine versions.
         * </p>
         * 
         * @param supportedEngineVersions
         *        The list of supported engine versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEngineVersions(Collection<String> supportedEngineVersions);

        /**
         * <p>
         * The list of supported engine versions.
         * </p>
         * 
         * @param supportedEngineVersions
         *        The list of supported engine versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEngineVersions(String... supportedEngineVersions);
    }

    static final class BuilderImpl implements Builder {
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String engineType;

        private String hostInstanceType;

        private String storageType;

        private List<String> supportedDeploymentModes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedEngineVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerInstanceOption model) {
            availabilityZones(model.availabilityZones);
            engineType(model.engineType);
            hostInstanceType(model.hostInstanceType);
            storageType(model.storageType);
            supportedDeploymentModesWithStrings(model.supportedDeploymentModes);
            supportedEngineVersions(model.supportedEngineVersions);
        }

        public final List<AvailabilityZone.Builder> getAvailabilityZones() {
            List<AvailabilityZone.Builder> result = ___listOfAvailabilityZoneCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = ___listOfAvailabilityZoneCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = ___listOfAvailabilityZoneCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder>... availabilityZones) {
            availabilityZones(Stream.of(availabilityZones).map(c -> AvailabilityZone.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getHostInstanceType() {
            return hostInstanceType;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(BrokerStorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Collection<String> getSupportedDeploymentModes() {
            if (supportedDeploymentModes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedDeploymentModes;
        }

        public final void setSupportedDeploymentModes(Collection<String> supportedDeploymentModes) {
            this.supportedDeploymentModes = ___listOfDeploymentModeCopier.copy(supportedDeploymentModes);
        }

        @Override
        public final Builder supportedDeploymentModesWithStrings(Collection<String> supportedDeploymentModes) {
            this.supportedDeploymentModes = ___listOfDeploymentModeCopier.copy(supportedDeploymentModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDeploymentModesWithStrings(String... supportedDeploymentModes) {
            supportedDeploymentModesWithStrings(Arrays.asList(supportedDeploymentModes));
            return this;
        }

        @Override
        public final Builder supportedDeploymentModes(Collection<DeploymentMode> supportedDeploymentModes) {
            this.supportedDeploymentModes = ___listOfDeploymentModeCopier.copyEnumToString(supportedDeploymentModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDeploymentModes(DeploymentMode... supportedDeploymentModes) {
            supportedDeploymentModes(Arrays.asList(supportedDeploymentModes));
            return this;
        }

        public final Collection<String> getSupportedEngineVersions() {
            if (supportedEngineVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedEngineVersions;
        }

        public final void setSupportedEngineVersions(Collection<String> supportedEngineVersions) {
            this.supportedEngineVersions = ___listOf__stringCopier.copy(supportedEngineVersions);
        }

        @Override
        public final Builder supportedEngineVersions(Collection<String> supportedEngineVersions) {
            this.supportedEngineVersions = ___listOf__stringCopier.copy(supportedEngineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngineVersions(String... supportedEngineVersions) {
            supportedEngineVersions(Arrays.asList(supportedEngineVersions));
            return this;
        }

        @Override
        public BrokerInstanceOption build() {
            return new BrokerInstanceOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
