/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Broker configuration information
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Configurations implements SdkPojo, Serializable, ToCopyableBuilder<Configurations.Builder, Configurations> {
    private static final SdkField<ConfigurationId> CURRENT_FIELD = SdkField.<ConfigurationId> builder(MarshallingType.SDK_POJO)
            .memberName("Current").getter(getter(Configurations::current)).setter(setter(Builder::current))
            .constructor(ConfigurationId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("current").build()).build();

    private static final SdkField<List<ConfigurationId>> HISTORY_FIELD = SdkField
            .<List<ConfigurationId>> builder(MarshallingType.LIST)
            .memberName("History")
            .getter(getter(Configurations::history))
            .setter(setter(Builder::history))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("history").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationId> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConfigurationId> PENDING_FIELD = SdkField.<ConfigurationId> builder(MarshallingType.SDK_POJO)
            .memberName("Pending").getter(getter(Configurations::pending)).setter(setter(Builder::pending))
            .constructor(ConfigurationId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pending").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_FIELD, HISTORY_FIELD,
            PENDING_FIELD));

    private static final long serialVersionUID = 1L;

    private final ConfigurationId current;

    private final List<ConfigurationId> history;

    private final ConfigurationId pending;

    private Configurations(BuilderImpl builder) {
        this.current = builder.current;
        this.history = builder.history;
        this.pending = builder.pending;
    }

    /**
     * <p>
     * The broker's current configuration.
     * </p>
     * 
     * @return The broker's current configuration.
     */
    public final ConfigurationId current() {
        return current;
    }

    /**
     * For responses, this returns true if the service returned a value for the History property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHistory() {
        return history != null && !(history instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The history of configurations applied to the broker.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHistory} method.
     * </p>
     * 
     * @return The history of configurations applied to the broker.
     */
    public final List<ConfigurationId> history() {
        return history;
    }

    /**
     * <p>
     * The broker's pending configuration.
     * </p>
     * 
     * @return The broker's pending configuration.
     */
    public final ConfigurationId pending() {
        return pending;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(current());
        hashCode = 31 * hashCode + Objects.hashCode(hasHistory() ? history() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configurations)) {
            return false;
        }
        Configurations other = (Configurations) obj;
        return Objects.equals(current(), other.current()) && hasHistory() == other.hasHistory()
                && Objects.equals(history(), other.history()) && Objects.equals(pending(), other.pending());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Configurations").add("Current", current()).add("History", hasHistory() ? history() : null)
                .add("Pending", pending()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Current":
            return Optional.ofNullable(clazz.cast(current()));
        case "History":
            return Optional.ofNullable(clazz.cast(history()));
        case "Pending":
            return Optional.ofNullable(clazz.cast(pending()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Configurations, T> g) {
        return obj -> g.apply((Configurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Configurations> {
        /**
         * <p>
         * The broker's current configuration.
         * </p>
         * 
         * @param current
         *        The broker's current configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder current(ConfigurationId current);

        /**
         * <p>
         * The broker's current configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationId.Builder} avoiding the
         * need to create one manually via {@link ConfigurationId#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationId.Builder#build()} is called immediately and its
         * result is passed to {@link #current(ConfigurationId)}.
         * 
         * @param current
         *        a consumer that will call methods on {@link ConfigurationId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #current(ConfigurationId)
         */
        default Builder current(Consumer<ConfigurationId.Builder> current) {
            return current(ConfigurationId.builder().applyMutation(current).build());
        }

        /**
         * <p>
         * The history of configurations applied to the broker.
         * </p>
         * 
         * @param history
         *        The history of configurations applied to the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder history(Collection<ConfigurationId> history);

        /**
         * <p>
         * The history of configurations applied to the broker.
         * </p>
         * 
         * @param history
         *        The history of configurations applied to the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder history(ConfigurationId... history);

        /**
         * <p>
         * The history of configurations applied to the broker.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ConfigurationId>.Builder} avoiding
         * the need to create one manually via {@link List<ConfigurationId>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationId>.Builder#build()} is called immediately and
         * its result is passed to {@link #history(List<ConfigurationId>)}.
         * 
         * @param history
         *        a consumer that will call methods on {@link List<ConfigurationId>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #history(List<ConfigurationId>)
         */
        Builder history(Consumer<ConfigurationId.Builder>... history);

        /**
         * <p>
         * The broker's pending configuration.
         * </p>
         * 
         * @param pending
         *        The broker's pending configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(ConfigurationId pending);

        /**
         * <p>
         * The broker's pending configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationId.Builder} avoiding the
         * need to create one manually via {@link ConfigurationId#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationId.Builder#build()} is called immediately and its
         * result is passed to {@link #pending(ConfigurationId)}.
         * 
         * @param pending
         *        a consumer that will call methods on {@link ConfigurationId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pending(ConfigurationId)
         */
        default Builder pending(Consumer<ConfigurationId.Builder> pending) {
            return pending(ConfigurationId.builder().applyMutation(pending).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConfigurationId current;

        private List<ConfigurationId> history = DefaultSdkAutoConstructList.getInstance();

        private ConfigurationId pending;

        private BuilderImpl() {
        }

        private BuilderImpl(Configurations model) {
            current(model.current);
            history(model.history);
            pending(model.pending);
        }

        public final ConfigurationId.Builder getCurrent() {
            return current != null ? current.toBuilder() : null;
        }

        public final void setCurrent(ConfigurationId.BuilderImpl current) {
            this.current = current != null ? current.build() : null;
        }

        @Override
        public final Builder current(ConfigurationId current) {
            this.current = current;
            return this;
        }

        public final List<ConfigurationId.Builder> getHistory() {
            List<ConfigurationId.Builder> result = ___listOfConfigurationIdCopier.copyToBuilder(this.history);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHistory(Collection<ConfigurationId.BuilderImpl> history) {
            this.history = ___listOfConfigurationIdCopier.copyFromBuilder(history);
        }

        @Override
        public final Builder history(Collection<ConfigurationId> history) {
            this.history = ___listOfConfigurationIdCopier.copy(history);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(ConfigurationId... history) {
            history(Arrays.asList(history));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(Consumer<ConfigurationId.Builder>... history) {
            history(Stream.of(history).map(c -> ConfigurationId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConfigurationId.Builder getPending() {
            return pending != null ? pending.toBuilder() : null;
        }

        public final void setPending(ConfigurationId.BuilderImpl pending) {
            this.pending = pending != null ? pending.build() : null;
        }

        @Override
        public final Builder pending(ConfigurationId pending) {
            this.pending = pending;
            return this;
        }

        @Override
        public Configurations build() {
            return new Configurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
