/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationResponse extends MqResponse implements
        ToCopyableBuilder<CreateConfigurationResponse.Builder, CreateConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> AUTHENTICATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationStrategy").getter(getter(CreateConfigurationResponse::authenticationStrategyAsString))
            .setter(setter(Builder::authenticationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationStrategy").build())
            .build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created")
            .getter(getter(CreateConfigurationResponse::created))
            .setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateConfigurationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ConfigurationRevision> LATEST_REVISION_FIELD = SdkField
            .<ConfigurationRevision> builder(MarshallingType.SDK_POJO).memberName("LatestRevision")
            .getter(getter(CreateConfigurationResponse::latestRevision)).setter(setter(Builder::latestRevision))
            .constructor(ConfigurationRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            AUTHENTICATION_STRATEGY_FIELD, CREATED_FIELD, ID_FIELD, LATEST_REVISION_FIELD, NAME_FIELD));

    private final String arn;

    private final String authenticationStrategy;

    private final Instant created;

    private final String id;

    private final ConfigurationRevision latestRevision;

    private final String name;

    private CreateConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.authenticationStrategy = builder.authenticationStrategy;
        this.created = builder.created;
        this.id = builder.id;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
    }

    /**
     * <p>
     * Required. The Amazon Resource Name (ARN) of the configuration.
     * </p>
     * 
     * @return Required. The Amazon Resource Name (ARN) of the configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationStrategy} will return {@link AuthenticationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationStrategyAsString}.
     * </p>
     * 
     * @return Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
     * @see AuthenticationStrategy
     */
    public final AuthenticationStrategy authenticationStrategy() {
        return AuthenticationStrategy.fromValue(authenticationStrategy);
    }

    /**
     * <p>
     * Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationStrategy} will return {@link AuthenticationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authenticationStrategyAsString}.
     * </p>
     * 
     * @return Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
     * @see AuthenticationStrategy
     */
    public final String authenticationStrategyAsString() {
        return authenticationStrategy;
    }

    /**
     * <p>
     * Required. The date and time of the configuration.
     * </p>
     * 
     * @return Required. The date and time of the configuration.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * Required. The unique ID that Amazon MQ generates for the configuration.
     * </p>
     * 
     * @return Required. The unique ID that Amazon MQ generates for the configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The latest revision of the configuration.
     * </p>
     * 
     * @return The latest revision of the configuration.
     */
    public final ConfigurationRevision latestRevision() {
        return latestRevision;
    }

    /**
     * <p>
     * Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods,
     * underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
     * </p>
     * 
     * @return Required. The name of the configuration. This value can contain only alphanumeric characters, dashes,
     *         periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationResponse)) {
            return false;
        }
        CreateConfigurationResponse other = (CreateConfigurationResponse) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(authenticationStrategyAsString(), other.authenticationStrategyAsString())
                && Objects.equals(created(), other.created()) && Objects.equals(id(), other.id())
                && Objects.equals(latestRevision(), other.latestRevision()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfigurationResponse").add("Arn", arn())
                .add("AuthenticationStrategy", authenticationStrategyAsString()).add("Created", created()).add("Id", id())
                .add("LatestRevision", latestRevision()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AuthenticationStrategy":
            return Optional.ofNullable(clazz.cast(authenticationStrategyAsString()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LatestRevision":
            return Optional.ofNullable(clazz.cast(latestRevision()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationResponse, T> g) {
        return obj -> g.apply((CreateConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateConfigurationResponse> {
        /**
         * <p>
         * Required. The Amazon Resource Name (ARN) of the configuration.
         * </p>
         * 
         * @param arn
         *        Required. The Amazon Resource Name (ARN) of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
         * </p>
         * 
         * @param authenticationStrategy
         *        Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
         * @see AuthenticationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationStrategy
         */
        Builder authenticationStrategy(String authenticationStrategy);

        /**
         * <p>
         * Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
         * </p>
         * 
         * @param authenticationStrategy
         *        Optional. The authentication strategy associated with the configuration. The default is SIMPLE.
         * @see AuthenticationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationStrategy
         */
        Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy);

        /**
         * <p>
         * Required. The date and time of the configuration.
         * </p>
         * 
         * @param created
         *        Required. The date and time of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * Required. The unique ID that Amazon MQ generates for the configuration.
         * </p>
         * 
         * @param id
         *        Required. The unique ID that Amazon MQ generates for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The latest revision of the configuration.
         * </p>
         * 
         * @param latestRevision
         *        The latest revision of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRevision(ConfigurationRevision latestRevision);

        /**
         * <p>
         * The latest revision of the configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationRevision.Builder} avoiding
         * the need to create one manually via {@link ConfigurationRevision#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationRevision.Builder#build()} is called immediately and
         * its result is passed to {@link #latestRevision(ConfigurationRevision)}.
         * 
         * @param latestRevision
         *        a consumer that will call methods on {@link ConfigurationRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRevision(ConfigurationRevision)
         */
        default Builder latestRevision(Consumer<ConfigurationRevision.Builder> latestRevision) {
            return latestRevision(ConfigurationRevision.builder().applyMutation(latestRevision).build());
        }

        /**
         * <p>
         * Required. The name of the configuration. This value can contain only alphanumeric characters, dashes,
         * periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
         * </p>
         * 
         * @param name
         *        Required. The name of the configuration. This value can contain only alphanumeric characters, dashes,
         *        periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private String arn;

        private String authenticationStrategy;

        private Instant created;

        private String id;

        private ConfigurationRevision latestRevision;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationResponse model) {
            super(model);
            arn(model.arn);
            authenticationStrategy(model.authenticationStrategy);
            created(model.created);
            id(model.id);
            latestRevision(model.latestRevision);
            name(model.name);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAuthenticationStrategy() {
            return authenticationStrategy;
        }

        public final void setAuthenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
        }

        @Override
        public final Builder authenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
            return this;
        }

        @Override
        public final Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy) {
            this.authenticationStrategy(authenticationStrategy == null ? null : authenticationStrategy.toString());
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ConfigurationRevision.Builder getLatestRevision() {
            return latestRevision != null ? latestRevision.toBuilder() : null;
        }

        public final void setLatestRevision(ConfigurationRevision.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        public final Builder latestRevision(ConfigurationRevision latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public CreateConfigurationResponse build() {
            return new CreateConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
