/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of information about logs currently enabled and pending to be deployed for the specified broker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogsSummary implements SdkPojo, Serializable, ToCopyableBuilder<LogsSummary.Builder, LogsSummary> {
    private static final SdkField<Boolean> AUDIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Audit")
            .getter(getter(LogsSummary::audit)).setter(setter(Builder::audit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audit").build()).build();

    private static final SdkField<String> AUDIT_LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditLogGroup").getter(getter(LogsSummary::auditLogGroup)).setter(setter(Builder::auditLogGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditLogGroup").build()).build();

    private static final SdkField<Boolean> GENERAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("General").getter(getter(LogsSummary::general)).setter(setter(Builder::general))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("general").build()).build();

    private static final SdkField<String> GENERAL_LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneralLogGroup").getter(getter(LogsSummary::generalLogGroup)).setter(setter(Builder::generalLogGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generalLogGroup").build()).build();

    private static final SdkField<PendingLogs> PENDING_FIELD = SdkField.<PendingLogs> builder(MarshallingType.SDK_POJO)
            .memberName("Pending").getter(getter(LogsSummary::pending)).setter(setter(Builder::pending))
            .constructor(PendingLogs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pending").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_FIELD,
            AUDIT_LOG_GROUP_FIELD, GENERAL_FIELD, GENERAL_LOG_GROUP_FIELD, PENDING_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean audit;

    private final String auditLogGroup;

    private final Boolean general;

    private final String generalLogGroup;

    private final PendingLogs pending;

    private LogsSummary(BuilderImpl builder) {
        this.audit = builder.audit;
        this.auditLogGroup = builder.auditLogGroup;
        this.general = builder.general;
        this.generalLogGroup = builder.generalLogGroup;
        this.pending = builder.pending;
    }

    /**
     * <p>
     * Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     * </p>
     * 
     * @return Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     */
    public final Boolean audit() {
        return audit;
    }

    /**
     * <p>
     * The location of the CloudWatch Logs log group where audit logs are sent.
     * </p>
     * 
     * @return The location of the CloudWatch Logs log group where audit logs are sent.
     */
    public final String auditLogGroup() {
        return auditLogGroup;
    }

    /**
     * <p>
     * Enables general logging.
     * </p>
     * 
     * @return Enables general logging.
     */
    public final Boolean general() {
        return general;
    }

    /**
     * <p>
     * The location of the CloudWatch Logs log group where general logs are sent.
     * </p>
     * 
     * @return The location of the CloudWatch Logs log group where general logs are sent.
     */
    public final String generalLogGroup() {
        return generalLogGroup;
    }

    /**
     * <p>
     * The list of information about logs pending to be deployed for the specified broker.
     * </p>
     * 
     * @return The list of information about logs pending to be deployed for the specified broker.
     */
    public final PendingLogs pending() {
        return pending;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audit());
        hashCode = 31 * hashCode + Objects.hashCode(auditLogGroup());
        hashCode = 31 * hashCode + Objects.hashCode(general());
        hashCode = 31 * hashCode + Objects.hashCode(generalLogGroup());
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsSummary)) {
            return false;
        }
        LogsSummary other = (LogsSummary) obj;
        return Objects.equals(audit(), other.audit()) && Objects.equals(auditLogGroup(), other.auditLogGroup())
                && Objects.equals(general(), other.general()) && Objects.equals(generalLogGroup(), other.generalLogGroup())
                && Objects.equals(pending(), other.pending());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogsSummary").add("Audit", audit()).add("AuditLogGroup", auditLogGroup())
                .add("General", general()).add("GeneralLogGroup", generalLogGroup()).add("Pending", pending()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Audit":
            return Optional.ofNullable(clazz.cast(audit()));
        case "AuditLogGroup":
            return Optional.ofNullable(clazz.cast(auditLogGroup()));
        case "General":
            return Optional.ofNullable(clazz.cast(general()));
        case "GeneralLogGroup":
            return Optional.ofNullable(clazz.cast(generalLogGroup()));
        case "Pending":
            return Optional.ofNullable(clazz.cast(pending()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogsSummary, T> g) {
        return obj -> g.apply((LogsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogsSummary> {
        /**
         * <p>
         * Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
         * </p>
         * 
         * @param audit
         *        Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is
         *        logged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audit(Boolean audit);

        /**
         * <p>
         * The location of the CloudWatch Logs log group where audit logs are sent.
         * </p>
         * 
         * @param auditLogGroup
         *        The location of the CloudWatch Logs log group where audit logs are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditLogGroup(String auditLogGroup);

        /**
         * <p>
         * Enables general logging.
         * </p>
         * 
         * @param general
         *        Enables general logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder general(Boolean general);

        /**
         * <p>
         * The location of the CloudWatch Logs log group where general logs are sent.
         * </p>
         * 
         * @param generalLogGroup
         *        The location of the CloudWatch Logs log group where general logs are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generalLogGroup(String generalLogGroup);

        /**
         * <p>
         * The list of information about logs pending to be deployed for the specified broker.
         * </p>
         * 
         * @param pending
         *        The list of information about logs pending to be deployed for the specified broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(PendingLogs pending);

        /**
         * <p>
         * The list of information about logs pending to be deployed for the specified broker.
         * </p>
         * This is a convenience method that creates an instance of the {@link PendingLogs.Builder} avoiding the need to
         * create one manually via {@link PendingLogs#builder()}.
         *
         * When the {@link Consumer} completes, {@link PendingLogs.Builder#build()} is called immediately and its result
         * is passed to {@link #pending(PendingLogs)}.
         * 
         * @param pending
         *        a consumer that will call methods on {@link PendingLogs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pending(PendingLogs)
         */
        default Builder pending(Consumer<PendingLogs.Builder> pending) {
            return pending(PendingLogs.builder().applyMutation(pending).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean audit;

        private String auditLogGroup;

        private Boolean general;

        private String generalLogGroup;

        private PendingLogs pending;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsSummary model) {
            audit(model.audit);
            auditLogGroup(model.auditLogGroup);
            general(model.general);
            generalLogGroup(model.generalLogGroup);
            pending(model.pending);
        }

        public final Boolean getAudit() {
            return audit;
        }

        public final void setAudit(Boolean audit) {
            this.audit = audit;
        }

        @Override
        public final Builder audit(Boolean audit) {
            this.audit = audit;
            return this;
        }

        public final String getAuditLogGroup() {
            return auditLogGroup;
        }

        public final void setAuditLogGroup(String auditLogGroup) {
            this.auditLogGroup = auditLogGroup;
        }

        @Override
        public final Builder auditLogGroup(String auditLogGroup) {
            this.auditLogGroup = auditLogGroup;
            return this;
        }

        public final Boolean getGeneral() {
            return general;
        }

        public final void setGeneral(Boolean general) {
            this.general = general;
        }

        @Override
        public final Builder general(Boolean general) {
            this.general = general;
            return this;
        }

        public final String getGeneralLogGroup() {
            return generalLogGroup;
        }

        public final void setGeneralLogGroup(String generalLogGroup) {
            this.generalLogGroup = generalLogGroup;
        }

        @Override
        public final Builder generalLogGroup(String generalLogGroup) {
            this.generalLogGroup = generalLogGroup;
            return this;
        }

        public final PendingLogs.Builder getPending() {
            return pending != null ? pending.toBuilder() : null;
        }

        public final void setPending(PendingLogs.BuilderImpl pending) {
            this.pending = pending != null ? pending.build() : null;
        }

        @Override
        public final Builder pending(PendingLogs pending) {
            this.pending = pending;
            return this;
        }

        @Override
        public LogsSummary build() {
            return new LogsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
