/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Types of broker engines.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerEngineType implements SdkPojo, Serializable,
        ToCopyableBuilder<BrokerEngineType.Builder, BrokerEngineType> {
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineType").getter(getter(BrokerEngineType::engineTypeAsString)).setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<List<EngineVersion>> ENGINE_VERSIONS_FIELD = SdkField
            .<List<EngineVersion>> builder(MarshallingType.LIST)
            .memberName("EngineVersions")
            .getter(getter(BrokerEngineType::engineVersions))
            .setter(setter(Builder::engineVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_TYPE_FIELD,
            ENGINE_VERSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engineType;

    private final List<EngineVersion> engineVersions;

    private BrokerEngineType(BuilderImpl builder) {
        this.engineType = builder.engineType;
        this.engineVersions = builder.engineVersions;
    }

    /**
     * <p>
     * The broker's engine type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The broker's engine type.
     * @see EngineType
     */
    public final EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * <p>
     * The broker's engine type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The broker's engine type.
     * @see EngineType
     */
    public final String engineTypeAsString() {
        return engineType;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngineVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngineVersions() {
        return engineVersions != null && !(engineVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of engine versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngineVersions} method.
     * </p>
     * 
     * @return The list of engine versions.
     */
    public final List<EngineVersion> engineVersions() {
        return engineVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEngineVersions() ? engineVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerEngineType)) {
            return false;
        }
        BrokerEngineType other = (BrokerEngineType) obj;
        return Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && hasEngineVersions() == other.hasEngineVersions() && Objects.equals(engineVersions(), other.engineVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrokerEngineType").add("EngineType", engineTypeAsString())
                .add("EngineVersions", hasEngineVersions() ? engineVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "EngineVersions":
            return Optional.ofNullable(clazz.cast(engineVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerEngineType, T> g) {
        return obj -> g.apply((BrokerEngineType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerEngineType> {
        /**
         * <p>
         * The broker's engine type.
         * </p>
         * 
         * @param engineType
         *        The broker's engine type.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * The broker's engine type.
         * </p>
         * 
         * @param engineType
         *        The broker's engine type.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * <p>
         * The list of engine versions.
         * </p>
         * 
         * @param engineVersions
         *        The list of engine versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersions(Collection<EngineVersion> engineVersions);

        /**
         * <p>
         * The list of engine versions.
         * </p>
         * 
         * @param engineVersions
         *        The list of engine versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersions(EngineVersion... engineVersions);

        /**
         * <p>
         * The list of engine versions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EngineVersion>.Builder} avoiding the need
         * to create one manually via {@link List<EngineVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EngineVersion>.Builder#build()} is called immediately and
         * its result is passed to {@link #engineVersions(List<EngineVersion>)}.
         * 
         * @param engineVersions
         *        a consumer that will call methods on {@link List<EngineVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineVersions(List<EngineVersion>)
         */
        Builder engineVersions(Consumer<EngineVersion.Builder>... engineVersions);
    }

    static final class BuilderImpl implements Builder {
        private String engineType;

        private List<EngineVersion> engineVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerEngineType model) {
            engineType(model.engineType);
            engineVersions(model.engineVersions);
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        @Transient
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        @Transient
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final List<EngineVersion.Builder> getEngineVersions() {
            List<EngineVersion.Builder> result = ___listOfEngineVersionCopier.copyToBuilder(this.engineVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngineVersions(Collection<EngineVersion.BuilderImpl> engineVersions) {
            this.engineVersions = ___listOfEngineVersionCopier.copyFromBuilder(engineVersions);
        }

        @Override
        @Transient
        public final Builder engineVersions(Collection<EngineVersion> engineVersions) {
            this.engineVersions = ___listOfEngineVersionCopier.copy(engineVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder engineVersions(EngineVersion... engineVersions) {
            engineVersions(Arrays.asList(engineVersions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder engineVersions(Consumer<EngineVersion.Builder>... engineVersions) {
            engineVersions(Stream.of(engineVersions).map(c -> EngineVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BrokerEngineType build() {
            return new BrokerEngineType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
