/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker.
 * </p>
 * <important>
 * <p>
 * Does not apply to RabbitMQ brokers.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LdapServerMetadataInput implements SdkPojo, Serializable,
        ToCopyableBuilder<LdapServerMetadataInput.Builder, LdapServerMetadataInput> {
    private static final SdkField<List<String>> HOSTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Hosts")
            .getter(getter(LdapServerMetadataInput::hosts))
            .setter(setter(Builder::hosts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hosts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleBase").getter(getter(LdapServerMetadataInput::roleBase)).setter(setter(Builder::roleBase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleBase").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(LdapServerMetadataInput::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final SdkField<String> ROLE_SEARCH_MATCHING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleSearchMatching").getter(getter(LdapServerMetadataInput::roleSearchMatching))
            .setter(setter(Builder::roleSearchMatching))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleSearchMatching").build())
            .build();

    private static final SdkField<Boolean> ROLE_SEARCH_SUBTREE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RoleSearchSubtree").getter(getter(LdapServerMetadataInput::roleSearchSubtree))
            .setter(setter(Builder::roleSearchSubtree))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleSearchSubtree").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccountPassword").getter(getter(LdapServerMetadataInput::serviceAccountPassword))
            .setter(setter(Builder::serviceAccountPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountPassword").build())
            .build();

    private static final SdkField<String> SERVICE_ACCOUNT_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccountUsername").getter(getter(LdapServerMetadataInput::serviceAccountUsername))
            .setter(setter(Builder::serviceAccountUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountUsername").build())
            .build();

    private static final SdkField<String> USER_BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserBase").getter(getter(LdapServerMetadataInput::userBase)).setter(setter(Builder::userBase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userBase").build()).build();

    private static final SdkField<String> USER_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserRoleName").getter(getter(LdapServerMetadataInput::userRoleName))
            .setter(setter(Builder::userRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRoleName").build()).build();

    private static final SdkField<String> USER_SEARCH_MATCHING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserSearchMatching").getter(getter(LdapServerMetadataInput::userSearchMatching))
            .setter(setter(Builder::userSearchMatching))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSearchMatching").build())
            .build();

    private static final SdkField<Boolean> USER_SEARCH_SUBTREE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UserSearchSubtree").getter(getter(LdapServerMetadataInput::userSearchSubtree))
            .setter(setter(Builder::userSearchSubtree))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSearchSubtree").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTS_FIELD, ROLE_BASE_FIELD,
            ROLE_NAME_FIELD, ROLE_SEARCH_MATCHING_FIELD, ROLE_SEARCH_SUBTREE_FIELD, SERVICE_ACCOUNT_PASSWORD_FIELD,
            SERVICE_ACCOUNT_USERNAME_FIELD, USER_BASE_FIELD, USER_ROLE_NAME_FIELD, USER_SEARCH_MATCHING_FIELD,
            USER_SEARCH_SUBTREE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> hosts;

    private final String roleBase;

    private final String roleName;

    private final String roleSearchMatching;

    private final Boolean roleSearchSubtree;

    private final String serviceAccountPassword;

    private final String serviceAccountUsername;

    private final String userBase;

    private final String userRoleName;

    private final String userSearchMatching;

    private final Boolean userSearchSubtree;

    private LdapServerMetadataInput(BuilderImpl builder) {
        this.hosts = builder.hosts;
        this.roleBase = builder.roleBase;
        this.roleName = builder.roleName;
        this.roleSearchMatching = builder.roleSearchMatching;
        this.roleSearchSubtree = builder.roleSearchSubtree;
        this.serviceAccountPassword = builder.serviceAccountPassword;
        this.serviceAccountUsername = builder.serviceAccountUsername;
        this.userBase = builder.userBase;
        this.userRoleName = builder.userRoleName;
        this.userSearchMatching = builder.userSearchMatching;
        this.userSearchSubtree = builder.userSearchSubtree;
    }

    /**
     * For responses, this returns true if the service returned a value for the Hosts property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasHosts() {
        return hosts != null && !(hosts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory . Optional
     * failover server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHosts} method.
     * </p>
     * 
     * @return Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory .
     *         Optional failover server.
     */
    public final List<String> hosts() {
        return hosts;
    }

    /**
     * <p>
     * The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For
     * example, ou=group, ou=corp, dc=corp, dc=example, dc=com.
     * </p>
     * 
     * @return The distinguished name of the node in the directory information tree (DIT) to search for roles or groups.
     *         For example, ou=group, ou=corp, dc=corp, dc=example, dc=com.
     */
    public final String roleBase() {
        return roleBase;
    }

    /**
     * <p>
     * Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group
     * membership query.
     * </p>
     * 
     * @return Specifies the LDAP attribute that identifies the group name attribute in the object returned from the
     *         group membership query.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by
     * userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is
     * substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user
     * janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role entries
     * that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.
     * </p>
     * 
     * @return The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched
     *         by userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username
     *         is substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the
     *         user janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all
     *         role entries that have a member attribute equal to uid=janedoe under the subtree selected by the
     *         roleBase.
     */
    public final String roleSearchMatching() {
        return roleSearchMatching;
    }

    /**
     * <p>
     * The directory search scope for the role. If set to true, scope is to search the entire subtree.
     * </p>
     * 
     * @return The directory search scope for the role. If set to true, scope is to search the entire subtree.
     */
    public final Boolean roleSearchSubtree() {
        return roleSearchSubtree;
    }

    /**
     * <p>
     * Service account password. A service account is an account in your LDAP server that has access to initiate a
     * connection. For example, cn=admin,dc=corp, dc=example, dc=com.
     * </p>
     * 
     * @return Service account password. A service account is an account in your LDAP server that has access to initiate
     *         a connection. For example, cn=admin,dc=corp, dc=example, dc=com.
     */
    public final String serviceAccountPassword() {
        return serviceAccountPassword;
    }

    /**
     * <p>
     * Service account username. A service account is an account in your LDAP server that has access to initiate a
     * connection. For example, cn=admin,dc=corp, dc=example, dc=com.
     * </p>
     * 
     * @return Service account username. A service account is an account in your LDAP server that has access to initiate
     *         a connection. For example, cn=admin,dc=corp, dc=example, dc=com.
     */
    public final String serviceAccountUsername() {
        return serviceAccountUsername;
    }

    /**
     * <p>
     * Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree is
     * specified by a DN, which specifies the base node of the subtree. For example, by setting this option to
     * ou=Users,ou=corp, dc=corp, dc=example, dc=com, the search for user entries is restricted to the subtree beneath
     * ou=Users, ou=corp, dc=corp, dc=example, dc=com.
     * </p>
     * 
     * @return Select a particular subtree of the directory information tree (DIT) to search for user entries. The
     *         subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this
     *         option to ou=Users,ou=corp, dc=corp, dc=example, dc=com, the search for user entries is restricted to the
     *         subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.
     */
    public final String userBase() {
        return userBase;
    }

    /**
     * <p>
     * Specifies the name of the LDAP attribute for the user group membership.
     * </p>
     * 
     * @return Specifies the name of the LDAP attribute for the user group membership.
     */
    public final String userRoleName() {
        return userRoleName;
    }

    /**
     * <p>
     * The LDAP search filter used to find users within the userBase. The client's username is substituted into the {0}
     * placeholder in the search filter. For example, if this option is set to (uid={0}) and the received username is
     * janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in matching an entry
     * like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example, dc=com.
     * </p>
     * 
     * @return The LDAP search filter used to find users within the userBase. The client's username is substituted into
     *         the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the
     *         received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will
     *         result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example, dc=com.
     */
    public final String userSearchMatching() {
        return userSearchMatching;
    }

    /**
     * <p>
     * The directory search scope for the user. If set to true, scope is to search the entire subtree.
     * </p>
     * 
     * @return The directory search scope for the user. If set to true, scope is to search the entire subtree.
     */
    public final Boolean userSearchSubtree() {
        return userSearchSubtree;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHosts() ? hosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleBase());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(roleSearchMatching());
        hashCode = 31 * hashCode + Objects.hashCode(roleSearchSubtree());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountPassword());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountUsername());
        hashCode = 31 * hashCode + Objects.hashCode(userBase());
        hashCode = 31 * hashCode + Objects.hashCode(userRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(userSearchMatching());
        hashCode = 31 * hashCode + Objects.hashCode(userSearchSubtree());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LdapServerMetadataInput)) {
            return false;
        }
        LdapServerMetadataInput other = (LdapServerMetadataInput) obj;
        return hasHosts() == other.hasHosts() && Objects.equals(hosts(), other.hosts())
                && Objects.equals(roleBase(), other.roleBase()) && Objects.equals(roleName(), other.roleName())
                && Objects.equals(roleSearchMatching(), other.roleSearchMatching())
                && Objects.equals(roleSearchSubtree(), other.roleSearchSubtree())
                && Objects.equals(serviceAccountPassword(), other.serviceAccountPassword())
                && Objects.equals(serviceAccountUsername(), other.serviceAccountUsername())
                && Objects.equals(userBase(), other.userBase()) && Objects.equals(userRoleName(), other.userRoleName())
                && Objects.equals(userSearchMatching(), other.userSearchMatching())
                && Objects.equals(userSearchSubtree(), other.userSearchSubtree());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LdapServerMetadataInput").add("Hosts", hasHosts() ? hosts() : null).add("RoleBase", roleBase())
                .add("RoleName", roleName()).add("RoleSearchMatching", roleSearchMatching())
                .add("RoleSearchSubtree", roleSearchSubtree()).add("ServiceAccountPassword", serviceAccountPassword())
                .add("ServiceAccountUsername", serviceAccountUsername()).add("UserBase", userBase())
                .add("UserRoleName", userRoleName()).add("UserSearchMatching", userSearchMatching())
                .add("UserSearchSubtree", userSearchSubtree()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hosts":
            return Optional.ofNullable(clazz.cast(hosts()));
        case "RoleBase":
            return Optional.ofNullable(clazz.cast(roleBase()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "RoleSearchMatching":
            return Optional.ofNullable(clazz.cast(roleSearchMatching()));
        case "RoleSearchSubtree":
            return Optional.ofNullable(clazz.cast(roleSearchSubtree()));
        case "ServiceAccountPassword":
            return Optional.ofNullable(clazz.cast(serviceAccountPassword()));
        case "ServiceAccountUsername":
            return Optional.ofNullable(clazz.cast(serviceAccountUsername()));
        case "UserBase":
            return Optional.ofNullable(clazz.cast(userBase()));
        case "UserRoleName":
            return Optional.ofNullable(clazz.cast(userRoleName()));
        case "UserSearchMatching":
            return Optional.ofNullable(clazz.cast(userSearchMatching()));
        case "UserSearchSubtree":
            return Optional.ofNullable(clazz.cast(userSearchSubtree()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LdapServerMetadataInput, T> g) {
        return obj -> g.apply((LdapServerMetadataInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LdapServerMetadataInput> {
        /**
         * <p>
         * Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory .
         * Optional failover server.
         * </p>
         * 
         * @param hosts
         *        Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory
         *        . Optional failover server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(Collection<String> hosts);

        /**
         * <p>
         * Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory .
         * Optional failover server.
         * </p>
         * 
         * @param hosts
         *        Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory
         *        . Optional failover server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(String... hosts);

        /**
         * <p>
         * The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. For
         * example, ou=group, ou=corp, dc=corp, dc=example, dc=com.
         * </p>
         * 
         * @param roleBase
         *        The distinguished name of the node in the directory information tree (DIT) to search for roles or
         *        groups. For example, ou=group, ou=corp, dc=corp, dc=example, dc=com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleBase(String roleBase);

        /**
         * <p>
         * Specifies the LDAP attribute that identifies the group name attribute in the object returned from the group
         * membership query.
         * </p>
         * 
         * @param roleName
         *        Specifies the LDAP attribute that identifies the group name attribute in the object returned from the
         *        group membership query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The LDAP search filter used to find roles within the roleBase. The distinguished name of the user matched by
         * userSearchMatching is substituted into the {0} placeholder in the search filter. The client's username is
         * substituted into the {1} placeholder. For example, if you set this option to (member=uid={1})for the user
         * janedoe, the search filter becomes (member=uid=janedoe) after string substitution. It matches all role
         * entries that have a member attribute equal to uid=janedoe under the subtree selected by the roleBase.
         * </p>
         * 
         * @param roleSearchMatching
         *        The LDAP search filter used to find roles within the roleBase. The distinguished name of the user
         *        matched by userSearchMatching is substituted into the {0} placeholder in the search filter. The
         *        client's username is substituted into the {1} placeholder. For example, if you set this option to
         *        (member=uid={1})for the user janedoe, the search filter becomes (member=uid=janedoe) after string
         *        substitution. It matches all role entries that have a member attribute equal to uid=janedoe under the
         *        subtree selected by the roleBase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleSearchMatching(String roleSearchMatching);

        /**
         * <p>
         * The directory search scope for the role. If set to true, scope is to search the entire subtree.
         * </p>
         * 
         * @param roleSearchSubtree
         *        The directory search scope for the role. If set to true, scope is to search the entire subtree.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleSearchSubtree(Boolean roleSearchSubtree);

        /**
         * <p>
         * Service account password. A service account is an account in your LDAP server that has access to initiate a
         * connection. For example, cn=admin,dc=corp, dc=example, dc=com.
         * </p>
         * 
         * @param serviceAccountPassword
         *        Service account password. A service account is an account in your LDAP server that has access to
         *        initiate a connection. For example, cn=admin,dc=corp, dc=example, dc=com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountPassword(String serviceAccountPassword);

        /**
         * <p>
         * Service account username. A service account is an account in your LDAP server that has access to initiate a
         * connection. For example, cn=admin,dc=corp, dc=example, dc=com.
         * </p>
         * 
         * @param serviceAccountUsername
         *        Service account username. A service account is an account in your LDAP server that has access to
         *        initiate a connection. For example, cn=admin,dc=corp, dc=example, dc=com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountUsername(String serviceAccountUsername);

        /**
         * <p>
         * Select a particular subtree of the directory information tree (DIT) to search for user entries. The subtree
         * is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to
         * ou=Users,ou=corp, dc=corp, dc=example, dc=com, the search for user entries is restricted to the subtree
         * beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.
         * </p>
         * 
         * @param userBase
         *        Select a particular subtree of the directory information tree (DIT) to search for user entries. The
         *        subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting
         *        this option to ou=Users,ou=corp, dc=corp, dc=example, dc=com, the search for user entries is
         *        restricted to the subtree beneath ou=Users, ou=corp, dc=corp, dc=example, dc=com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBase(String userBase);

        /**
         * <p>
         * Specifies the name of the LDAP attribute for the user group membership.
         * </p>
         * 
         * @param userRoleName
         *        Specifies the name of the LDAP attribute for the user group membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRoleName(String userRoleName);

        /**
         * <p>
         * The LDAP search filter used to find users within the userBase. The client's username is substituted into the
         * {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the received
         * username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It will result in
         * matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example, dc=com.
         * </p>
         * 
         * @param userSearchMatching
         *        The LDAP search filter used to find users within the userBase. The client's username is substituted
         *        into the {0} placeholder in the search filter. For example, if this option is set to (uid={0}) and the
         *        received username is janedoe, the search filter becomes (uid=janedoe) after string substitution. It
         *        will result in matching an entry like uid=janedoe, ou=Users,ou=corp, dc=corp, dc=example, dc=com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSearchMatching(String userSearchMatching);

        /**
         * <p>
         * The directory search scope for the user. If set to true, scope is to search the entire subtree.
         * </p>
         * 
         * @param userSearchSubtree
         *        The directory search scope for the user. If set to true, scope is to search the entire subtree.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSearchSubtree(Boolean userSearchSubtree);
    }

    static final class BuilderImpl implements Builder {
        private List<String> hosts = DefaultSdkAutoConstructList.getInstance();

        private String roleBase;

        private String roleName;

        private String roleSearchMatching;

        private Boolean roleSearchSubtree;

        private String serviceAccountPassword;

        private String serviceAccountUsername;

        private String userBase;

        private String userRoleName;

        private String userSearchMatching;

        private Boolean userSearchSubtree;

        private BuilderImpl() {
        }

        private BuilderImpl(LdapServerMetadataInput model) {
            hosts(model.hosts);
            roleBase(model.roleBase);
            roleName(model.roleName);
            roleSearchMatching(model.roleSearchMatching);
            roleSearchSubtree(model.roleSearchSubtree);
            serviceAccountPassword(model.serviceAccountPassword);
            serviceAccountUsername(model.serviceAccountUsername);
            userBase(model.userBase);
            userRoleName(model.userRoleName);
            userSearchMatching(model.userSearchMatching);
            userSearchSubtree(model.userSearchSubtree);
        }

        public final Collection<String> getHosts() {
            if (hosts instanceof SdkAutoConstructList) {
                return null;
            }
            return hosts;
        }

        public final void setHosts(Collection<String> hosts) {
            this.hosts = ___listOf__stringCopier.copy(hosts);
        }

        @Override
        @Transient
        public final Builder hosts(Collection<String> hosts) {
            this.hosts = ___listOf__stringCopier.copy(hosts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder hosts(String... hosts) {
            hosts(Arrays.asList(hosts));
            return this;
        }

        public final String getRoleBase() {
            return roleBase;
        }

        public final void setRoleBase(String roleBase) {
            this.roleBase = roleBase;
        }

        @Override
        @Transient
        public final Builder roleBase(String roleBase) {
            this.roleBase = roleBase;
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        @Transient
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getRoleSearchMatching() {
            return roleSearchMatching;
        }

        public final void setRoleSearchMatching(String roleSearchMatching) {
            this.roleSearchMatching = roleSearchMatching;
        }

        @Override
        @Transient
        public final Builder roleSearchMatching(String roleSearchMatching) {
            this.roleSearchMatching = roleSearchMatching;
            return this;
        }

        public final Boolean getRoleSearchSubtree() {
            return roleSearchSubtree;
        }

        public final void setRoleSearchSubtree(Boolean roleSearchSubtree) {
            this.roleSearchSubtree = roleSearchSubtree;
        }

        @Override
        @Transient
        public final Builder roleSearchSubtree(Boolean roleSearchSubtree) {
            this.roleSearchSubtree = roleSearchSubtree;
            return this;
        }

        public final String getServiceAccountPassword() {
            return serviceAccountPassword;
        }

        public final void setServiceAccountPassword(String serviceAccountPassword) {
            this.serviceAccountPassword = serviceAccountPassword;
        }

        @Override
        @Transient
        public final Builder serviceAccountPassword(String serviceAccountPassword) {
            this.serviceAccountPassword = serviceAccountPassword;
            return this;
        }

        public final String getServiceAccountUsername() {
            return serviceAccountUsername;
        }

        public final void setServiceAccountUsername(String serviceAccountUsername) {
            this.serviceAccountUsername = serviceAccountUsername;
        }

        @Override
        @Transient
        public final Builder serviceAccountUsername(String serviceAccountUsername) {
            this.serviceAccountUsername = serviceAccountUsername;
            return this;
        }

        public final String getUserBase() {
            return userBase;
        }

        public final void setUserBase(String userBase) {
            this.userBase = userBase;
        }

        @Override
        @Transient
        public final Builder userBase(String userBase) {
            this.userBase = userBase;
            return this;
        }

        public final String getUserRoleName() {
            return userRoleName;
        }

        public final void setUserRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
        }

        @Override
        @Transient
        public final Builder userRoleName(String userRoleName) {
            this.userRoleName = userRoleName;
            return this;
        }

        public final String getUserSearchMatching() {
            return userSearchMatching;
        }

        public final void setUserSearchMatching(String userSearchMatching) {
            this.userSearchMatching = userSearchMatching;
        }

        @Override
        @Transient
        public final Builder userSearchMatching(String userSearchMatching) {
            this.userSearchMatching = userSearchMatching;
            return this;
        }

        public final Boolean getUserSearchSubtree() {
            return userSearchSubtree;
        }

        public final void setUserSearchSubtree(Boolean userSearchSubtree) {
            this.userSearchSubtree = userSearchSubtree;
        }

        @Override
        @Transient
        public final Builder userSearchSubtree(Boolean userSearchSubtree) {
            this.userSearchSubtree = userSearchSubtree;
            return this;
        }

        @Override
        public LdapServerMetadataInput build() {
            return new LdapServerMetadataInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
