/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationResponse extends MqResponse implements
        ToCopyableBuilder<UpdateConfigurationResponse.Builder, UpdateConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created")
            .getter(getter(UpdateConfigurationResponse::created))
            .setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateConfigurationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ConfigurationRevision> LATEST_REVISION_FIELD = SdkField
            .<ConfigurationRevision> builder(MarshallingType.SDK_POJO).memberName("LatestRevision")
            .getter(getter(UpdateConfigurationResponse::latestRevision)).setter(setter(Builder::latestRevision))
            .constructor(ConfigurationRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<SanitizationWarning>> WARNINGS_FIELD = SdkField
            .<List<SanitizationWarning>> builder(MarshallingType.LIST)
            .memberName("Warnings")
            .getter(getter(UpdateConfigurationResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SanitizationWarning> builder(MarshallingType.SDK_POJO)
                                            .constructor(SanitizationWarning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_FIELD,
            ID_FIELD, LATEST_REVISION_FIELD, NAME_FIELD, WARNINGS_FIELD));

    private final String arn;

    private final Instant created;

    private final String id;

    private final ConfigurationRevision latestRevision;

    private final String name;

    private final List<SanitizationWarning> warnings;

    private UpdateConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.created = builder.created;
        this.id = builder.id;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.warnings = builder.warnings;
    }

    /**
     * <p>
     * Required. The Amazon Resource Name (ARN) of the configuration.
     * </p>
     * 
     * @return Required. The Amazon Resource Name (ARN) of the configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Required. The date and time of the configuration.
     * </p>
     * 
     * @return Required. The date and time of the configuration.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * Required. The unique ID that Amazon MQ generates for the configuration.
     * </p>
     * 
     * @return Required. The unique ID that Amazon MQ generates for the configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The latest revision of the configuration.
     * </p>
     * 
     * @return The latest revision of the configuration.
     */
    public final ConfigurationRevision latestRevision() {
        return latestRevision;
    }

    /**
     * <p>
     * Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods,
     * underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
     * </p>
     * 
     * @return Required. The name of the configuration. This value can contain only alphanumeric characters, dashes,
     *         periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Warnings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the first 20 warnings about the configuration XML elements or attributes that were sanitized.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWarnings} method.
     * </p>
     * 
     * @return The list of the first 20 warnings about the configuration XML elements or attributes that were sanitized.
     */
    public final List<SanitizationWarning> warnings() {
        return warnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationResponse)) {
            return false;
        }
        UpdateConfigurationResponse other = (UpdateConfigurationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(created(), other.created())
                && Objects.equals(id(), other.id()) && Objects.equals(latestRevision(), other.latestRevision())
                && Objects.equals(name(), other.name()) && hasWarnings() == other.hasWarnings()
                && Objects.equals(warnings(), other.warnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfigurationResponse").add("Arn", arn()).add("Created", created()).add("Id", id())
                .add("LatestRevision", latestRevision()).add("Name", name()).add("Warnings", hasWarnings() ? warnings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LatestRevision":
            return Optional.ofNullable(clazz.cast(latestRevision()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConfigurationResponse> {
        /**
         * <p>
         * Required. The Amazon Resource Name (ARN) of the configuration.
         * </p>
         * 
         * @param arn
         *        Required. The Amazon Resource Name (ARN) of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Required. The date and time of the configuration.
         * </p>
         * 
         * @param created
         *        Required. The date and time of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * Required. The unique ID that Amazon MQ generates for the configuration.
         * </p>
         * 
         * @param id
         *        Required. The unique ID that Amazon MQ generates for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The latest revision of the configuration.
         * </p>
         * 
         * @param latestRevision
         *        The latest revision of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRevision(ConfigurationRevision latestRevision);

        /**
         * <p>
         * The latest revision of the configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigurationRevision.Builder} avoiding the need
         * to create one manually via {@link ConfigurationRevision#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationRevision.Builder#build()} is called immediately and
         * its result is passed to {@link #latestRevision(ConfigurationRevision)}.
         * 
         * @param latestRevision
         *        a consumer that will call methods on {@link ConfigurationRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRevision(ConfigurationRevision)
         */
        default Builder latestRevision(Consumer<ConfigurationRevision.Builder> latestRevision) {
            return latestRevision(ConfigurationRevision.builder().applyMutation(latestRevision).build());
        }

        /**
         * <p>
         * Required. The name of the configuration. This value can contain only alphanumeric characters, dashes,
         * periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
         * </p>
         * 
         * @param name
         *        Required. The name of the configuration. This value can contain only alphanumeric characters, dashes,
         *        periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The list of the first 20 warnings about the configuration XML elements or attributes that were sanitized.
         * </p>
         * 
         * @param warnings
         *        The list of the first 20 warnings about the configuration XML elements or attributes that were
         *        sanitized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<SanitizationWarning> warnings);

        /**
         * <p>
         * The list of the first 20 warnings about the configuration XML elements or attributes that were sanitized.
         * </p>
         * 
         * @param warnings
         *        The list of the first 20 warnings about the configuration XML elements or attributes that were
         *        sanitized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(SanitizationWarning... warnings);

        /**
         * <p>
         * The list of the first 20 warnings about the configuration XML elements or attributes that were sanitized.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SanitizationWarning>.Builder} avoiding the
         * need to create one manually via {@link List<SanitizationWarning>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SanitizationWarning>.Builder#build()} is called immediately
         * and its result is passed to {@link #warnings(List<SanitizationWarning>)}.
         * 
         * @param warnings
         *        a consumer that will call methods on {@link List<SanitizationWarning>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warnings(List<SanitizationWarning>)
         */
        Builder warnings(Consumer<SanitizationWarning.Builder>... warnings);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant created;

        private String id;

        private ConfigurationRevision latestRevision;

        private String name;

        private List<SanitizationWarning> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationResponse model) {
            super(model);
            arn(model.arn);
            created(model.created);
            id(model.id);
            latestRevision(model.latestRevision);
            name(model.name);
            warnings(model.warnings);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        @Transient
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ConfigurationRevision.Builder getLatestRevision() {
            return latestRevision != null ? latestRevision.toBuilder() : null;
        }

        public final void setLatestRevision(ConfigurationRevision.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        @Transient
        public final Builder latestRevision(ConfigurationRevision latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<SanitizationWarning.Builder> getWarnings() {
            List<SanitizationWarning.Builder> result = ___listOfSanitizationWarningCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<SanitizationWarning.BuilderImpl> warnings) {
            this.warnings = ___listOfSanitizationWarningCopier.copyFromBuilder(warnings);
        }

        @Override
        @Transient
        public final Builder warnings(Collection<SanitizationWarning> warnings) {
            this.warnings = ___listOfSanitizationWarningCopier.copy(warnings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder warnings(SanitizationWarning... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder warnings(Consumer<SanitizationWarning.Builder>... warnings) {
            warnings(Stream.of(warnings).map(c -> SanitizationWarning.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateConfigurationResponse build() {
            return new UpdateConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
