/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationRevisionResponse extends MqResponse implements
        ToCopyableBuilder<DescribeConfigurationRevisionResponse.Builder, DescribeConfigurationRevisionResponse> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationId").getter(getter(DescribeConfigurationRevisionResponse::configurationId))
            .setter(setter(Builder::configurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created")
            .getter(getter(DescribeConfigurationRevisionResponse::created))
            .setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Data")
            .getter(getter(DescribeConfigurationRevisionResponse::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeConfigurationRevisionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD,
            CREATED_FIELD, DATA_FIELD, DESCRIPTION_FIELD));

    private final String configurationId;

    private final Instant created;

    private final String data;

    private final String description;

    private DescribeConfigurationRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.created = builder.created;
        this.data = builder.data;
        this.description = builder.description;
    }

    /**
     * <p>
     * Required. The unique ID that Amazon MQ generates for the configuration.
     * </p>
     * 
     * @return Required. The unique ID that Amazon MQ generates for the configuration.
     */
    public final String configurationId() {
        return configurationId;
    }

    /**
     * <p>
     * Required. The date and time of the configuration.
     * </p>
     * 
     * @return Required. The date and time of the configuration.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * Required. The base64-encoded XML configuration.
     * </p>
     * 
     * @return Required. The base64-encoded XML configuration.
     */
    public final String data() {
        return data;
    }

    /**
     * <p>
     * The description of the configuration.
     * </p>
     * 
     * @return The description of the configuration.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRevisionResponse)) {
            return false;
        }
        DescribeConfigurationRevisionResponse other = (DescribeConfigurationRevisionResponse) obj;
        return Objects.equals(configurationId(), other.configurationId()) && Objects.equals(created(), other.created())
                && Objects.equals(data(), other.data()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigurationRevisionResponse").add("ConfigurationId", configurationId())
                .add("Created", created()).add("Data", data()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationId":
            return Optional.ofNullable(clazz.cast(configurationId()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRevisionResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationRevisionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConfigurationRevisionResponse> {
        /**
         * <p>
         * Required. The unique ID that Amazon MQ generates for the configuration.
         * </p>
         * 
         * @param configurationId
         *        Required. The unique ID that Amazon MQ generates for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationId(String configurationId);

        /**
         * <p>
         * Required. The date and time of the configuration.
         * </p>
         * 
         * @param created
         *        Required. The date and time of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * Required. The base64-encoded XML configuration.
         * </p>
         * 
         * @param data
         *        Required. The base64-encoded XML configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);

        /**
         * <p>
         * The description of the configuration.
         * </p>
         * 
         * @param description
         *        The description of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private String configurationId;

        private Instant created;

        private String data;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRevisionResponse model) {
            super(model);
            configurationId(model.configurationId);
            created(model.created);
            data(model.data);
            description(model.description);
        }

        public final String getConfigurationId() {
            return configurationId;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        @Transient
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        @Transient
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getData() {
            return data;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        @Transient
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public DescribeConfigurationRevisionResponse build() {
            return new DescribeConfigurationRevisionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
